/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.linux;

import com.pnfsoftware.jeb.corei.debuggers.linux.OI;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.JX;
import com.pnfsoftware.jebglobal.Wh;
import com.pnfsoftware.jebglobal.d;
import com.pnfsoftware.jebglobal.nl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class LinuxDbgClient {
    private static final ILogger Le;
    static final boolean eO = true;
    private JX Qx;

    public static void main(String[] stringArray) throws Exception {
        String string = "192.168.1.24";
        int n = 4400;
        LinuxDbgClient linuxDbgClient = new LinuxDbgClient("192.168.1.24", 4400);
        JX jX = linuxDbgClient.Qx();
        String string2 = "";
        block3: while (true) {
            try {
                while (true) {
                    String[] stringArray2;
                    System.out.print("> ");
                    String string3 = LinuxDbgClient.eO().trim();
                    if (string3.isEmpty()) {
                        string3 = string2;
                    } else {
                        string2 = string3;
                    }
                    if ((stringArray2 = string3.split("\\s+")).length == 0) continue;
                    String string4 = stringArray2[0];
                    if (string4.equals("exit")) break block3;
                    if (jX == null) {
                        Le.error("Debugger not connected", new Object[0]);
                        continue;
                    }
                    if (string4.equals("pause")) {
                        throw new RuntimeException("Pausing must be done on the target system!");
                    }
                    if (string4.equals("kill")) {
                        jX.eO(true);
                        break block3;
                    }
                    if (string4.equals("detach")) {
                        jX.eO(false);
                        break block3;
                    }
                    if (!jX.TI()) {
                        Le.error("The target is running... in all-stop mode, GDB is now expected a response! (The request was not sent)", new Object[0]);
                        continue;
                    }
                    if (string4.equals("info")) {
                        Le.info("Status: %s", jX.OP().lS());
                        continue;
                    }
                    if (string4.equals("r")) {
                        Le.info("Registers: %s", jX.kV());
                        continue;
                    }
                    if (string4.equals("wrt")) {
                        Wh wh2 = jX.kV();
                        long l2 = wh2.getValueAsLong(0);
                        wh2.setValueAsLong(0, 100L);
                        if (!jX.eO(wh2)) {
                            Le.info("failed writing registers", new Object[0]);
                            continue;
                        }
                        wh2 = jX.kV();
                        long l3 = wh2.getValueAsLong(0);
                        if (l3 != 100L) {
                            Le.info("it looks like register #0 was not updated properly: %Xh", l3);
                            continue;
                        }
                        wh2.setValueAsLong(0, l2);
                        jX.eO(wh2);
                        continue;
                    }
                    if (string4.equals("c") || string4.equals("continue")) {
                        if (stringArray2.length >= 2) {
                            int n2 = Integer.parseInt(stringArray2[1], 16);
                            jX.OP().Qx(n2);
                            continue;
                        }
                        boolean bl2 = jX.lS();
                        Le.info("%b", bl2);
                        continue;
                    }
                    if (string4.equals("step") || string4.equals("stepi")) {
                        boolean bl3 = jX.FZ();
                        Le.info("%b", bl3);
                        continue;
                    }
                    if (string4.equals("stepo")) {
                        boolean bl4 = jX.Ga();
                        Le.info("%b", bl4);
                        continue;
                    }
                    if (string4.equals("stop")) {
                        jX.OP().KQ();
                        continue;
                    }
                    if (string4.equals("supported")) {
                        Le.info("Supported:\n%s", jX.Kg());
                        continue;
                    }
                    if (string4.equals("lldb")) {
                        Le.info("Host Info: %s", jX.DA());
                        Le.info("Server Info: %s", jX.aO());
                        Le.info("Target Process Info: %s", jX.gU());
                        Le.info("Target Registers Layout: %s", jX.qb());
                        continue;
                    }
                    if (string4.equals("osdata")) {
                        Le.info(jX.OP().Qx(), new Object[0]);
                        continue;
                    }
                    if (string4.equals("nonstop")) {
                        Le.info("%b", jX.Le(true));
                        continue;
                    }
                    if (string4.equals("allstop")) {
                        Le.info("%b", jX.Le(false));
                        continue;
                    }
                    if (string4.equals("find")) {
                        long l4;
                        if (stringArray2.length < 4) continue;
                        long l5 = Conversion.stringToLong(stringArray2[1]);
                        long l6 = Conversion.stringToLong(stringArray2[2]);
                        byte[] byArray = Formatter.hexStringToByteArray(stringArray2[3]);
                        if (byArray == null || (l4 = jX.oH().findBytes(l5, l6, byArray)) < 0L) continue;
                        long l7 = l5 + l4;
                        Le.info("Found at %Xh", l7);
                        byte[] byArray2 = new byte[32];
                        int n3 = jX.oH().read(l7, byArray2.length, byArray2, 0);
                        if (n3 <= 0) continue;
                        Le.info("%s", Formatter.formatBinaryBlock(byArray2, 0, n3, -l7, true));
                        continue;
                    }
                    if (string3.startsWith("exec:")) {
                        String string5 = jX.OP().eO(string3.substring(5));
                        Le.info(string5, new Object[0]);
                        continue;
                    }
                    if (string3.startsWith("raw:")) {
                        byte[] byArray = jX.lS(string3.substring(4).trim());
                        if (byArray == null) continue;
                        Le.info(Strings.decodeLocal(byArray), new Object[0]);
                        continue;
                    }
                    ExecutionResult executionResult = jX.sh().execute(string3);
                    if (executionResult == null) continue;
                    if (executionResult.getCode() != 0) {
                        Le.i("Command execution failed with code %d", executionResult.getCode());
                    }
                    Le.i(executionResult.getMessage().toString(), new Object[0]);
                }
            }
            catch (d | nl vH2) {
                Le.catching(vH2);
                continue;
            }
            catch (Exception exception) {
                Le.catching(exception);
            }
            break;
        }
        linuxDbgClient.Le();
        Le.info("Done.", new Object[0]);
        System.exit(0);
    }

    static String eO() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public LinuxDbgClient(String string, int n) {
        this.Qx = new JX(string, n);
        this.Qx.Qx();
        this.Qx.eO(new OI(this));
    }

    public void Le() {
        if (this.Qx != null) {
            if (this.Qx.TI()) {
                this.Qx.lS();
            }
            this.Qx.eO(false);
            this.Qx = null;
        }
    }

    public JX Qx() {
        return this.Qx;
    }

    static /* synthetic */ ILogger lS() {
        return Le;
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        Le = GlobalLog.getLogger();
    }
}

