/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android.vm;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnitIdentifier;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.NS;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.ae;
import com.pnfsoftware.jeb.corei.parsers.apk.pX;

public class JDbgIdentifier
extends AbstractUnitIdentifier
implements IDebuggerUnitIdentifier {
    static final String TYPE = "dbug_apk";
    public static final String propnameBlockingQueryTimeoutSeconds = "BlockingQueryTimeoutSeconds";
    public static final String propnameAttachPortRangeStart = "AttachPortRangeStart";
    public static final String propnameAttachPortRangeSize = "AttachPortRangeSize";
    public static final String propnameUseNativeDebugger = "UseNativeDebugger";
    public static final String propnameNativeAttachPortRangeStart = "NativeAttachPortRangeStart";
    public static final String propnameNativeAttachPortRangeSize = "NativeAttachPortRangeSize";
    public static final String propnamePreferLldbserver = "PreferLldbserver";
    public static final String propnamePreferredLldbserverVersion = "PreferredLldbserverVersion";
    public static final String propnamePreferredGdbserverVersion = "PreferredGdbserverVersion";

    public JDbgIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android Debugger", "Debugger module for Android applications", "PNF Software", Version.create(0, 2, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameBlockingQueryTimeoutSeconds, PropertyTypeInteger.create(0, Integer.MAX_VALUE, 15), "Maximum time in seconds to wait for a response from the debugger server");
        this.pdm.addDefinition(propnameAttachPortRangeStart, PropertyTypeInteger.create(1024, 65535, 8900), "Preferred TCP port to use and listen to when attaching to the JDWP debugger");
        this.pdm.addDefinition(propnameAttachPortRangeSize, PropertyTypeInteger.create(1, 100, 20), "Number of ports to try after the preferred port if the preferred port is in useby another program");
        this.pdm.addDefinition(propnameUseNativeDebugger, PropertyTypeString.create("DEFAULT"), "If the client does not provide this information, this setting is used to determine whether the native debugger should be used as well. Use DEFAULT to let JEB choose (which will result in a yes if and only if a native library folder containing SO files exist), else use ALWAYS or NEVER.");
        this.pdm.addDefinition(propnameNativeAttachPortRangeStart, PropertyTypeInteger.create(1024, 65535, 8950), "Preferred TCP port to use and listen to when attaching to the native debugger");
        this.pdm.addDefinition(propnameNativeAttachPortRangeSize, PropertyTypeInteger.create(1, 100, 20), "Number of ports to try after the preferred port if the preferred port is in useby another program");
        this.pdm.addDefinition(propnamePreferLldbserver, PropertyTypeBoolean.create(true), "Prefer the use of LLDB server over GDB server for debugging native Android code.");
        this.pdm.addDefinition(propnamePreferredLldbserverVersion, PropertyTypeString.create(), "Preferred LLDB server version to use. JEB does not ship with all versions of LLDB server for all platforms. See the core/assets/ folder in your jeb.jar software archive.It is recommended to use the default.");
        this.pdm.addDefinition(propnamePreferredGdbserverVersion, PropertyTypeString.create(), "Preferred GDB server version to use. JEB does not ship with all versions of GDB server for all platforms. See the core/assets/ folder in your jeb.jar software archive.It is recommended to use the default.");
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        return iUnitCreator instanceof pX;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        if (!(iUnitCreator instanceof IUnit)) {
            throw new IllegalArgumentException();
        }
        IUnit iUnit = (IUnit)iUnitCreator;
        if (string.isEmpty()) {
            string = "VM";
        }
        ae ae2 = new ae(string, iUnitProcessor, iUnitCreator, this.pdm);
        ae2.process();
        iUnit.addChild(ae2, false);
        return ae2;
    }

    @Override
    public IDebuggerTargetEnumerator getTargetEnumerator() {
        return new NS();
    }
}

