/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Ser
public class ContainerUnit
extends AbstractUnit {
    public static final Comparator<IUnit> CONTAINERS_FIRST = new Comparator<IUnit>(){

        @Override
        public int compare(IUnit iUnit, IUnit iUnit2) {
            if (iUnit instanceof ContainerUnit && iUnit2 instanceof ContainerUnit) {
                return iUnit.getName().compareTo(iUnit2.getName());
            }
            if (iUnit instanceof ContainerUnit) {
                return -1;
            }
            if (iUnit2 instanceof ContainerUnit) {
                return 1;
            }
            return iUnit.getName().compareTo(iUnit2.getName());
        }
    };

    public ContainerUnit(String string, String string2, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(string, string2, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    public ContainerUnit(String string, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        this("composite", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public boolean process() {
        return this.process(true);
    }

    public boolean process(boolean bl2) {
        this.setProcessed(true);
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ContainerUnit) {
            ContainerUnit containerUnit = (ContainerUnit)object;
            return Strings.equals(containerUnit.getFormatType(), this.getFormatType()) && Strings.equals(containerUnit.getName(), this.getName());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public ContainerUnit getRootContainer() {
        if (this.getParent() instanceof ContainerUnit) {
            return ((ContainerUnit)this.getParent()).getRootContainer();
        }
        return this;
    }

    @Override
    public List<? extends IUnit> getChildren() {
        ArrayList<? extends IUnit> arrayList = new ArrayList<IUnit>(super.getChildren());
        Collections.sort(arrayList, CONTAINERS_FIRST);
        return arrayList;
    }
}

