/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerEventType;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerEventData;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.util.format.Formatter;

public class DebuggerEventData
implements IDebuggerEventData {
    DebuggerEventType type;
    long threadId;
    String address;
    UnitAddress<ICodeUnit> ua;
    int signal;
    ITypedValue retval;
    byte[] output;

    public DebuggerEventData(DebuggerEventType debuggerEventType, long l2, String string) {
        if (debuggerEventType == null) {
            throw new NullPointerException("Debugger event type cannot be null");
        }
        this.type = debuggerEventType;
        this.threadId = l2;
        this.address = string;
    }

    @Override
    public DebuggerEventType getType() {
        return this.type;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public UnitAddress<ICodeUnit> getUnitAddress() {
        return this.ua;
    }

    public void setUnitAddress(UnitAddress<ICodeUnit> unitAddress) {
        this.ua = unitAddress;
    }

    public int getSignalNumber() {
        return this.signal;
    }

    public void setSignalNumber(int n) {
        this.signal = n;
    }

    @Override
    public ITypedValue getReturnValue() {
        return this.retval;
    }

    public void setReturnValue(ITypedValue iTypedValue) {
        this.retval = iTypedValue;
    }

    @Override
    public byte[] getOutput() {
        return this.output;
    }

    public void setOutput(byte[] byArray) {
        this.output = byArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("type:%s", new Object[]{this.getType()}));
        if (this.getThreadId() != 0L) {
            stringBuilder.append(String.format(",tid:%d", this.getThreadId()));
        }
        if (this.getAddress() != null) {
            stringBuilder.append(String.format("@%s", this.getAddress()));
        }
        if (this.getSignalNumber() != 0) {
            stringBuilder.append(String.format(",sig=%d", this.getSignalNumber()));
        }
        if (this.getReturnValue() != null) {
            stringBuilder.append(String.format(",retval=%s", this.getReturnValue()));
        }
        if (this.getOutput() != null) {
            stringBuilder.append(String.format(",output='%s'", Formatter.escapeBytes(this.getOutput())));
        }
        return stringBuilder.toString();
    }
}

