/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.render;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.AutoLabelPolicy;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandList;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandSized;
import com.pnfsoftware.jeb.core.units.code.asm.render.AddressFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.Nn;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.rG;

@Ser
public class GenericCodeFormatter<InsnType extends IInstruction> {
    public static final int MNEMONIC_RIGHT_PADDING_LENGTH_DEFAULT = 10;
    @SerId(value=1)
    Yo<InsnType> pbcu;
    @SerId(value=2)
    IVirtualMemory mem;
    @SerId(value=3)
    Endianness endianness;
    @SerId(value=4)
    NumberFormatter defaultNumberFormatter = new NumberFormatter();
    @SerId(value=5)
    int mnemonicRightPaddingLength = 10;
    @SerId(value=6)
    WeakIdentityHashMap<IInstructionOperand, NumberFormatter> operandNumberFormatterMap = new WeakIdentityHashMap();
    @SerId(value=7)
    AddressFormatter defaultAddressFormatter = new AddressFormatter();
    @SerId(value=8)
    boolean doNotResolveImmAsAddr;

    public GenericCodeFormatter() {
    }

    public GenericCodeFormatter(IVirtualMemory iVirtualMemory) {
        this.mem = iVirtualMemory;
        this.endianness = iVirtualMemory.getStandardEndianess();
    }

    public void setCodeUnit(INativeCodeUnit<InsnType> iNativeCodeUnit) {
        this.pbcu = (Yo)iNativeCodeUnit;
        this.mem = iNativeCodeUnit.getMemory();
        this.endianness = iNativeCodeUnit.getEndianness();
    }

    public INativeCodeUnit<InsnType> getCodeUnit() {
        return this.pbcu;
    }

    public IVirtualMemory getMemory() {
        return this.mem;
    }

    public Endianness getEndianness() {
        return this.endianness;
    }

    public String getRawDataDeclarator(int n) {
        switch (n) {
            case 8: {
                return "db";
            }
            case 16: {
                return "dw";
            }
            case 32: {
                return "dd";
            }
            case 64: {
                return "dq";
            }
        }
        Assert.a(n > 0);
        return "d" + n;
    }

    public String getDataSeparator() {
        return ",";
    }

    public int getArrayElementPerLine() {
        return 10;
    }

    public void formatDataDeclarator(int n, CodeDocumentPart codeDocumentPart) {
        String string = this.getRawDataDeclarator(n * 8);
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.KEYWORD);
        codeDocumentPart.space();
    }

    public String getProcedureDefinitionStart() {
        return "proc";
    }

    public String getProcedureDefinitionEnd() {
        return "endp";
    }

    public String getLabelPrefix() {
        return "";
    }

    public String getLabelSuffix() {
        return ":";
    }

    public String getOperandSeparator() {
        return ",";
    }

    public String getMemoryAccessSizeInfo(IInstruction iInstruction, IInstructionOperandSized iInstructionOperandSized) {
        return String.format("ptr%d", iInstructionOperandSized.getOperandBitsize());
    }

    public String getMemoryAccessPrefix() {
        return "[";
    }

    public String getMemoryAccessSuffix() {
        return "]";
    }

    public String getMemoryAccessSegmentInfo(IInstruction iInstruction, IInstructionOperand iInstructionOperand) {
        return "";
    }

    public String getInlineCommentString() {
        return ";";
    }

    public String getMultiLineCommentBegin() {
        return "/*";
    }

    public String getMultiLineCommentEnd() {
        return "*/";
    }

    public String getRegisterName(long l2) {
        return "r" + l2;
    }

    public String generateExtraMethodComment(long l2) {
        return null;
    }

    public void formatInstruction(long l2, IInstruction iInstruction, CodeDocumentPart codeDocumentPart) {
        this.formatMnemonic(l2, iInstruction, true, codeDocumentPart);
        this.formatOperands(l2, iInstruction, codeDocumentPart);
    }

    protected int formatPrefix(long l2, IInstruction iInstruction, CodeDocumentPart codeDocumentPart) {
        String string = iInstruction.getPrefix();
        if (string == null) {
            return 0;
        }
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.MNEMONIC_PREFIX);
        codeDocumentPart.space();
        return string.length() + 1;
    }

    protected void formatMnemonic(long l2, IInstruction iInstruction, boolean bl2, CodeDocumentPart codeDocumentPart) {
        int n = 0;
        if (bl2) {
            n = this.formatPrefix(l2, iInstruction, codeDocumentPart);
        }
        String string = iInstruction.getMnemonic();
        codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.MNEMONIC, this.pbcu.eO(iInstruction));
        n += string.length();
        if (iInstruction.getOperands() != null && iInstruction.getOperands().length != 0) {
            int n2 = Math.max(1, this.mnemonicRightPaddingLength - n);
            codeDocumentPart.space(n2);
        }
    }

    public final void setMnemonicRightPaddingLength(int n) {
        this.mnemonicRightPaddingLength = n;
    }

    public final int getMnemonicRightPaddingLength() {
        return this.mnemonicRightPaddingLength;
    }

    protected void formatOperands(long l2, IInstruction iInstruction, CodeDocumentPart codeDocumentPart) {
        int n = 0;
        for (IInstructionOperand iInstructionOperand : iInstruction.getOperands()) {
            if (n >= 1) {
                codeDocumentPart.append(this.getOperandSeparator());
                codeDocumentPart.space();
            }
            this.formatOperand(l2, iInstruction, iInstructionOperand, n, 0, codeDocumentPart);
            ++n;
        }
    }

    public void formatOperand(long l2, IInstruction iInstruction, IInstructionOperand iInstructionOperand, int n, int n2, CodeDocumentPart codeDocumentPart) {
        Object object;
        boolean bl2 = false;
        if (iInstructionOperand instanceof IInstructionOperandGeneric) {
            object = (IInstructionOperandGeneric)iInstructionOperand;
            bl2 = this.formatOperandGeneric(l2, iInstruction, (IInstructionOperandGeneric)object, n, n2, codeDocumentPart);
        }
        if (!bl2) {
            object = iInstructionOperand.format(iInstruction, l2);
            codeDocumentPart.append((String)object);
        }
    }

    protected final void addPrefix(IInstruction iInstruction, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        String string = iInstructionOperandGeneric.getPrefix(iInstruction);
        if (string != null) {
            codeDocumentPart.append(string);
        }
    }

    protected final void addSuffix(IInstruction iInstruction, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        String string = iInstructionOperandGeneric.getSuffix(iInstruction);
        if (string != null) {
            codeDocumentPart.append(string);
        }
    }

    private boolean formatOperandGeneric(long l2, IInstruction iInstruction, IInstructionOperandGeneric iInstructionOperandGeneric, int n, int n2, CodeDocumentPart codeDocumentPart) {
        int n3 = iInstructionOperandGeneric.getOperandType();
        long l3 = iInstructionOperandGeneric.getOperandValue(l2);
        switch (n3) {
            case 0: {
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                this.formatRegister(l3, codeDocumentPart);
                break;
            }
            case 1: {
                String string;
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                NumberFormatter numberFormatter = this.getNumberFormatter(iInstructionOperandGeneric, false);
                if (numberFormatter == null) {
                    if (!this.isDoNotAttemptImmediateToAddressResolution() && (string = this.pbcu.eO(l3, AutoLabelPolicy.ITEM)) != null) {
                        codeDocumentPart.append("offset ");
                        this.formatAddress(l3, codeDocumentPart);
                        break;
                    }
                    numberFormatter = this.getDefaultNumberFormatter();
                }
                string = numberFormatter.format(iInstructionOperandGeneric.getOperandBitsize(), l3);
                codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.IMMEDIATE, this.pbcu.Le(l2, n));
                break;
            }
            case 2: {
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                this.formatAddress(l3, codeDocumentPart);
                break;
            }
            case 3: {
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                this.formatRelativeAddress(iInstructionOperandGeneric, l3, codeDocumentPart);
                break;
            }
            case 4: 
            case 5: {
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                codeDocumentPart.append(this.getMemoryAccessSizeInfo(iInstruction, iInstructionOperandGeneric));
                codeDocumentPart.append(this.getMemoryAccessSegmentInfo(iInstruction, iInstructionOperandGeneric));
                codeDocumentPart.append(this.getMemoryAccessPrefix());
                if (n3 == 4) {
                    this.formatRegister(l3, codeDocumentPart);
                } else {
                    this.formatAddress(l3, codeDocumentPart);
                }
                codeDocumentPart.append(this.getMemoryAccessSuffix());
                break;
            }
            case 6: {
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                codeDocumentPart.appendAndRecord(iInstructionOperandGeneric.getAlias(l3), ItemClassIdentifiers.KEYWORD);
                break;
            }
            case 7: {
                IInstructionOperandList iInstructionOperandList = (IInstructionOperandList)iInstructionOperandGeneric;
                IInstructionOperandGeneric iInstructionOperandGeneric2 = iInstructionOperandList.merge(l2);
                if (iInstructionOperandGeneric2 != null) {
                    this.formatOperand(l2, iInstruction, iInstructionOperandGeneric2, n, n2, codeDocumentPart);
                    return true;
                }
                this.addPrefix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
                int n4 = n2 + 1;
                for (int j = 0; j < iInstructionOperandList.getOperands().length; ++j) {
                    if (j != 0) {
                        codeDocumentPart.append(iInstructionOperandList.getSeparator());
                    }
                    int n5 = n | j << 4 * n4;
                    this.formatOperand(l2, iInstruction, iInstructionOperandList.getOperands()[j], n5, n4, codeDocumentPart);
                }
                break;
            }
            default: {
                return false;
            }
        }
        this.addSuffix(iInstruction, iInstructionOperandGeneric, codeDocumentPart);
        return true;
    }

    public final void formatAddress(long l2, CodeDocumentPart codeDocumentPart) {
        this.formatAddress(l2, null, codeDocumentPart);
    }

    public final void formatRelativeAddress(IInstructionOperandGeneric iInstructionOperandGeneric, long l2, CodeDocumentPart codeDocumentPart) {
        this.formatAddress(l2, iInstructionOperandGeneric, codeDocumentPart);
    }

    public void formatAddress(long l2, IInstructionOperandGeneric iInstructionOperandGeneric, CodeDocumentPart codeDocumentPart) {
        long l3;
        String string;
        INativeContinuousItem iNativeContinuousItem = this.pbcu.getNativeItemOver(l2);
        if (iInstructionOperandGeneric == null && iNativeContinuousItem != null && iNativeContinuousItem.getMemoryAddress() != l2) {
            long l4 = l2 - iNativeContinuousItem.getMemoryAddress();
            this.formatAddress(iNativeContinuousItem.getMemoryAddress(), iInstructionOperandGeneric, codeDocumentPart);
            codeDocumentPart.append("+");
            String string2 = this.getDefaultNumberFormatter().format(32, l4, NumberFormatter.NumberBase.HEXADECIMAL, false);
            codeDocumentPart.appendAndRecord(string2, ItemClassIdentifiers.NUMBER);
            return;
        }
        if (this.pbcu.Qx(l2)) {
            string = this.getDefaultAddressFormatter().format(this.pbcu, this.mem.getSpaceBits(), l2, iInstructionOperandGeneric);
            l3 = this.pbcu.TI(l2);
        } else {
            string = this.getDefaultAddressFormatter().format(this.mem.getSpaceBits(), l2, iInstructionOperandGeneric);
            l3 = 0L;
        }
        ItemClassIdentifiers itemClassIdentifiers = this.getBestClassIdForAddress(l2);
        codeDocumentPart.appendAndRecord(string, itemClassIdentifiers, l3);
    }

    protected void formatRegister(long l2, CodeDocumentPart codeDocumentPart) {
        codeDocumentPart.appendAndRecord(this.getRegisterName(l2), ItemClassIdentifiers.REGISTER, this.pbcu.vT(l2));
    }

    public NumberFormatter getDefaultNumberFormatter() {
        return this.defaultNumberFormatter;
    }

    public NumberFormatter getNumberFormatter(INativeDataItem iNativeDataItem) {
        NumberFormatter numberFormatter = ((Nn)iNativeDataItem).eO(false);
        if (numberFormatter == null) {
            numberFormatter = this.defaultNumberFormatter;
        }
        return numberFormatter;
    }

    public NumberFormatter getNumberFormatter(IInstructionOperand iInstructionOperand, boolean bl2) {
        NumberFormatter numberFormatter = this.operandNumberFormatterMap.get(iInstructionOperand);
        if (numberFormatter == null && bl2) {
            numberFormatter = new NumberFormatter(this.defaultNumberFormatter);
            this.operandNumberFormatterMap.put(iInstructionOperand, numberFormatter);
        }
        return numberFormatter;
    }

    public AddressFormatter getDefaultAddressFormatter() {
        return this.defaultAddressFormatter;
    }

    public ItemClassIdentifiers getBestClassIdForAddress(long l2) {
        INativeContinuousItem iNativeContinuousItem = this.pbcu.getNativeItemAt(l2);
        ItemClassIdentifiers itemClassIdentifiers = this.pbcu.Qx(l2) ? (iNativeContinuousItem instanceof rG ? ItemClassIdentifiers.EXTERNAL_METHOD_NAME : (iNativeContinuousItem instanceof Nn ? ItemClassIdentifiers.FIELD_NAME : (this.pbcu.eO(l2) != null ? ItemClassIdentifiers.METHOD_NAME : ItemClassIdentifiers.LABEL))) : ItemClassIdentifiers.LABEL;
        return itemClassIdentifiers;
    }

    public final long createItemIdForAddress(long l2) {
        return this.pbcu.TI(l2);
    }

    public final long createItemIdForImmediate(long l2, int n) {
        return this.pbcu.Le(l2, n);
    }

    public final long createItemIdForRegister(long l2) {
        return this.pbcu.vT(l2);
    }

    public void setDoNotAttemptImmediateToAddressResolution(boolean bl2) {
        this.doNotResolveImmAsAddr = bl2;
    }

    public boolean isDoNotAttemptImmediateToAddressResolution() {
        return this.doNotResolveImmAsAddr;
    }
}

