/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.memory;

import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.AbstractEncodedMemoryArea;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaList;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.EncodedMemoryAreaUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.VirtualEncodedMemoryArea;
import java.util.WeakHashMap;

public class DirectEncodedMemoryArea
extends AbstractEncodedMemoryArea {
    private static WeakHashMap<Integer, DirectEncodedMemoryArea> cache = new WeakHashMap();
    private int index;
    private int length;

    protected DirectEncodedMemoryArea(int n, int n2) {
        this.index = n;
        this.length = n2;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public static DirectEncodedMemoryArea get(int n, int n2) {
        int n3 = n + (n2 << 6);
        DirectEncodedMemoryArea directEncodedMemoryArea = cache.get(n3);
        if (directEncodedMemoryArea == null) {
            directEncodedMemoryArea = new DirectEncodedMemoryArea(n, n2);
            cache.put(n3, directEncodedMemoryArea);
        }
        return directEncodedMemoryArea;
    }

    public static DirectEncodedMemoryArea getThumb2(int n, int n2, int n3) {
        return DirectEncodedMemoryArea.get(n + n2 * 16, n3);
    }

    @Override
    public long decode(byte[] byArray) {
        return EncodedMemoryAreaUtil.zeroExtend(byArray, this.index, this.length);
    }

    public EncodedMemoryAreaList shift(int n) {
        return new EncodedMemoryAreaList(this, VirtualEncodedMemoryArea.get(0, n));
    }
}

