/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBankLayout;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.util.base.Assert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class RegisterLayoutBridge {
    private IRegisterBankLayout srcLayout;
    private IRegisterBankLayout dstLayout;
    private Map<Integer, Integer> srcToDst = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> dstToSrc = new HashMap<Integer, Integer>();

    public RegisterLayoutBridge(IRegisterBankLayout iRegisterBankLayout, IRegisterBankLayout iRegisterBankLayout2) {
        this.srcLayout = iRegisterBankLayout;
        this.dstLayout = iRegisterBankLayout2;
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBankLayout.getDescriptionEntries()) {
            RegisterDescriptionEntry registerDescriptionEntry2 = RegisterLayoutBridge.getDescriptionEntryByName(iRegisterBankLayout2, registerDescriptionEntry.getNames());
            if (registerDescriptionEntry2 == null) continue;
            this.srcToDst.put(registerDescriptionEntry.getNumber(), registerDescriptionEntry2.getNumber());
            this.dstToSrc.put(registerDescriptionEntry2.getNumber(), registerDescriptionEntry.getNumber());
        }
    }

    public Integer convertSource(int n) {
        return this.srcToDst.get(n);
    }

    public Integer convertDestination(int n) {
        return this.dstToSrc.get(n);
    }

    public byte[] convertSourceValue(int n, int n2, byte[] byArray) {
        int n3 = this.srcLayout.getDescriptionEntry(n).getSize();
        Assert.a(n3 == byArray.length);
        int n4 = this.dstLayout.getDescriptionEntry(n2).getSize();
        if (n3 == n4) {
            return byArray;
        }
        if (n3 < n4) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return Arrays.copyOf(byArray, n4);
    }

    public byte[] convertDestinationValue(int n, int n2, byte[] byArray) {
        int n3 = this.dstLayout.getDescriptionEntry(n).getSize();
        Assert.a(n3 == byArray.length);
        int n4 = this.srcLayout.getDescriptionEntry(n2).getSize();
        if (n3 == n4) {
            return byArray;
        }
        if (n3 < n4) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return Arrays.copyOf(byArray, n4);
    }

    static RegisterDescriptionEntry getDescriptionEntryByName(IRegisterBankLayout iRegisterBankLayout, String string) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBankLayout.getDescriptionEntries()) {
            if (!registerDescriptionEntry.getNames().contains(string)) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    static RegisterDescriptionEntry getDescriptionEntryByName(IRegisterBankLayout iRegisterBankLayout, List<String> list) {
        for (RegisterDescriptionEntry registerDescriptionEntry : iRegisterBankLayout.getDescriptionEntries()) {
            if (!CollectionUtils.containsAny(registerDescriptionEntry.getNames(), list)) continue;
            return registerDescriptionEntry;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.srcToDst.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(String.format("%d>%d", n, this.srcToDst.get(n)));
        }
        return stringBuilder.toString();
    }
}

