/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.FS;

public class VirtualMemoryUtil {
    private static final ILogger logger = GlobalLog.getLogger(VirtualMemoryUtil.class);

    public static IVirtualMemory createMemory(int n, int n2, Endianness endianness) {
        return new FS(n, n2, endianness);
    }

    public static boolean isPageAllocated(IVirtualMemory iVirtualMemory, long l2) {
        return iVirtualMemory.check(l2, 1, 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findAvailableRange(IVirtualMemory iVirtualMemory, long l2, int n) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = iVirtualMemory.getPageSize();
            long l4 = (long)n & 0xFFFFFFFFL;
            long l5 = l2 = iVirtualMemory.roundToPage(l2);
            while (l5 != 0L) {
                long l6 = l5 + l3;
                if (!VirtualMemoryUtil.isPageAllocated(iVirtualMemory, l5)) {
                    l5 = l6;
                    if (l5 - l2 < l4) continue;
                    return l2;
                }
                l2 = l6;
                l5 = l6;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long allocate(IVirtualMemory iVirtualMemory, long l2, int n, int n2) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = VirtualMemoryUtil.findAvailableRange(iVirtualMemory, l2, n);
            if (l3 != 0L) {
                try {
                    iVirtualMemory.allocate(l3, n, n2);
                }
                catch (MemoryException memoryException) {
                    logger.i("Should be able to allocate %Xh bytes at address %Xh...", n, l3);
                }
            }
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int allocateFillGaps(IVirtualMemory iVirtualMemory, long l2, int n, int n2) {
        IVirtualMemory iVirtualMemory2 = iVirtualMemory;
        synchronized (iVirtualMemory2) {
            long l3 = iVirtualMemory.roundToSize(l2 + ((long)n & 0xFFFFFFFFL));
            long l4 = iVirtualMemory.getPageSize();
            int n3 = 0;
            for (long j = iVirtualMemory.roundToPage(l2); j != l3; j += l4) {
                if (iVirtualMemory.check(j, 1, 0) != 0) continue;
                try {
                    iVirtualMemory.allocate(j, 1, n2);
                }
                catch (MemoryException memoryException) {
                    throw new RuntimeException(memoryException);
                }
                ++n3;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readBytesSafe(IVirtualMemory iVirtualMemory, long l2, int n, byte[] byArray, int n2, int n3) {
        if ((n3 & 1) == 0) {
            throw new IllegalArgumentException("Expected at least READ access");
        }
        try {
            IVirtualMemory iVirtualMemory2 = iVirtualMemory;
            synchronized (iVirtualMemory2) {
                int n4 = iVirtualMemory.check(l2, n, n3);
                iVirtualMemory.read(l2, n4, byArray, n2);
                return n4;
            }
        }
        catch (MemoryException memoryException) {
            return -1;
        }
    }

    public static int convertSegmentFlagsToVMFlags(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 1;
        }
        if ((n & 1) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        return n2;
    }

    public static int read(IVirtualMemory iVirtualMemory, long l2) {
        try {
            return iVirtualMemory.readByte(l2) & 0xFF;
        }
        catch (MemoryException memoryException) {
            return -1;
        }
    }

    public static boolean readSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            iVirtualMemory.read(l2, byArray.length, byArray, 0);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readByteSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            byArray[0] = iVirtualMemory.readByte(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLEShortSafe(IVirtualMemory iVirtualMemory, long l2, short[] sArray) {
        try {
            sArray[0] = iVirtualMemory.readLEShort(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLEIntSafe(IVirtualMemory iVirtualMemory, long l2, int[] nArray) {
        try {
            nArray[0] = iVirtualMemory.readLEInt(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLELongSafe(IVirtualMemory iVirtualMemory, long l2, long[] lArray) {
        try {
            lArray[0] = iVirtualMemory.readLELong(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeSafe(IVirtualMemory iVirtualMemory, long l2, byte[] byArray) {
        try {
            iVirtualMemory.write(l2, byArray.length, byArray, 0);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeByteSafe(IVirtualMemory iVirtualMemory, long l2, byte by2) {
        try {
            iVirtualMemory.writeByte(l2, by2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLEShortSafe(IVirtualMemory iVirtualMemory, long l2, short s2) {
        try {
            iVirtualMemory.writeLEShort(l2, s2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLEIntSafe(IVirtualMemory iVirtualMemory, long l2, int n) {
        try {
            iVirtualMemory.writeLEInt(l2, n);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLELongSafe(IVirtualMemory iVirtualMemory, long l2, long l3) {
        try {
            iVirtualMemory.writeLELong(l2, l3);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readShortSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, short[] sArray) {
        try {
            sArray[0] = endianness.isLittle() ? iVirtualMemory.readLEShort(l2) : iVirtualMemory.readBEShort(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readIntSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, int[] nArray) {
        try {
            nArray[0] = endianness.isLittle() ? iVirtualMemory.readLEInt(l2) : iVirtualMemory.readBEInt(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean readLongSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, long[] lArray) {
        try {
            lArray[0] = endianness.isLittle() ? iVirtualMemory.readLELong(l2) : iVirtualMemory.readBELong(l2);
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeShortSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, short s2) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLEShort(l2, s2);
            } else {
                iVirtualMemory.writeBEShort(l2, s2);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeIntSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, int n) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLEInt(l2, n);
            } else {
                iVirtualMemory.writeBEInt(l2, n);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }

    public static boolean writeLongSafe(Endianness endianness, IVirtualMemory iVirtualMemory, long l2, long l3) {
        try {
            if (endianness.isLittle()) {
                iVirtualMemory.writeLELong(l2, l3);
            } else {
                iVirtualMemory.writeBELong(l2, l3);
            }
            return true;
        }
        catch (MemoryException memoryException) {
            return false;
        }
    }
}

