/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt;

import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.DecompilerException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.AbstractEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.EExpressionGenerator;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.EExpressionMatcher;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.SubstitutionDefinition;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.kz;

public abstract class AbstractEExpressionOptimizer
extends AbstractEOptimizer {
    private static final ILogger logger = GlobalLog.getLogger(AbstractEExpressionOptimizer.class);
    protected boolean skipStatementProcessing = true;
    protected boolean skipLeftSideOfAssignment = false;

    public AbstractEExpressionOptimizer() {
        this(DataChainsUpdatePolicy.UPDATE_NOT_NECESSARY);
    }

    public AbstractEExpressionOptimizer(DataChainsUpdatePolicy dataChainsUpdatePolicy) {
        this(null, dataChainsUpdatePolicy);
    }

    public AbstractEExpressionOptimizer(IERoutineContext iERoutineContext, DataChainsUpdatePolicy dataChainsUpdatePolicy) {
        super(iERoutineContext, dataChainsUpdatePolicy);
    }

    @Override
    public int perform(boolean bl2) {
        boolean[] blArray = new boolean[]{false};
        int n = 0;
        for (BasicBlock<IEStatement> basicBlock : this.cfg.getBlocks()) {
            for (int j = 0; j < basicBlock.size(); ++j) {
                int n2;
                IEStatement iEStatement = (IEStatement)basicBlock.get(j);
                do {
                    Object object;
                    Object object2;
                    n2 = 0;
                    if (!this.skipStatementProcessing && (object2 = this.optimizeExpression(iEStatement)) != null) {
                        ((EOR)object2).safeCopyType(iEStatement);
                        object = ((EOR)object2).getExpression();
                        if (!(object instanceof IEStatement)) {
                            throw new DecompilerException("Expected a statement IRE");
                        }
                        iEStatement = (IEStatement)((EOR)object2).getExpression();
                        basicBlock.set(j, iEStatement);
                        if (((EOR)object2).getUpdateDFA()) {
                            blArray[0] = true;
                        }
                        ++n2;
                    }
                    if (n2 == 0) {
                        if (this.skipLeftSideOfAssignment && iEStatement instanceof IEAssign) {
                            n2 += this.optimize(iEStatement, ((IEAssign)iEStatement).getSrcOperand(), blArray);
                            if (((IEAssign)iEStatement).getDstOperand() instanceof IEMem) {
                                object2 = (IEMem)((IEAssign)iEStatement).getDstOperand();
                                n2 += this.optimize(((IEAssign)iEStatement).getDstOperand(), object2.getReference(), blArray);
                            }
                        } else {
                            object2 = EUtil.getSubExpressions(iEStatement);
                            object = object2.iterator();
                            while (object.hasNext()) {
                                IEGeneric iEGeneric = (IEGeneric)object.next();
                                n2 += this.optimize(iEStatement, iEGeneric, blArray);
                            }
                        }
                    }
                    n += n2;
                } while (n2 > 0);
            }
        }
        return this.postPerform(bl2, n, blArray[0]);
    }

    private int optimize(IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean[] blArray) {
        EOR eOR = this.optimizeExpression(iEGeneric2);
        if (eOR != null) {
            eOR.safeCopyType(iEGeneric2);
            if (!iEGeneric.replaceSubExpression(iEGeneric2, eOR.getExpression())) {
                return 0;
            }
            if (eOR.getUpdateDFA()) {
                blArray[0] = true;
            }
            return 1;
        }
        int n = 0;
        for (IEGeneric iEGeneric3 : EUtil.getSubExpressions(iEGeneric2)) {
            n += this.optimize(iEGeneric2, iEGeneric3, blArray);
        }
        return n;
    }

    protected abstract EOR optimizeExpression(IEGeneric var1);

    protected IEGeneric doSubstitution(IEGeneric iEGeneric, SubstitutionDefinition ... substitutionDefinitionArray) {
        for (SubstitutionDefinition substitutionDefinition : substitutionDefinitionArray) {
            EExpressionMatcher eExpressionMatcher = new EExpressionMatcher(substitutionDefinition.pattern);
            if (!eExpressionMatcher.isMatch(iEGeneric)) continue;
            IEGeneric iEGeneric2 = new EExpressionGenerator(this.ectx, substitutionDefinition.replacement).generate(eExpressionMatcher.getMatchMap());
            return iEGeneric2;
        }
        return null;
    }

    public static class EOR {
        private IEGeneric e;
        private boolean updateDFA;

        public static EOR create(IEGeneric iEGeneric, boolean bl2) {
            if (iEGeneric == null) {
                return null;
            }
            return new EOR(iEGeneric, bl2);
        }

        public static EOR create(IEGeneric iEGeneric) {
            return EOR.create(iEGeneric, false);
        }

        private EOR(IEGeneric iEGeneric, boolean bl2) {
            if (iEGeneric == null) {
                throw new NullPointerException("An expression was expected");
            }
            this.e = iEGeneric;
            this.updateDFA = bl2;
        }

        public IEGeneric getExpression() {
            return this.e;
        }

        public boolean getUpdateDFA() {
            return this.updateDFA;
        }

        public void safeCopyType(IEGeneric iEGeneric) {
            if (((kz)iEGeneric).OP() != null && ((kz)this.e).OP() == null) {
                ((kz)this.e).eO(((kz)iEGeneric).OP(), null);
            }
        }
    }
}

