/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableInformationProvider;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Ser
public class Tracker<InsnType extends IInstruction> {
    @SerId(value=1)
    BasicBlock<InsnType> bb;
    @SerId(value=2)
    Map<Integer, Set<Long>> inlist;
    @SerId(value=3)
    Map<Integer, Set<Long>> outlist;

    Tracker(BasicBlock<InsnType> basicBlock, boolean bl2, boolean bl3) {
        this.bb = basicBlock;
        this.inlist = bl2 ? new HashMap() : null;
        this.outlist = bl3 ? new HashMap() : null;
    }

    public Map<Integer, Set<Long>> getInputs() {
        return this.inlist;
    }

    public Set<Long> getInput(int n) {
        return this.inlist.get(n);
    }

    public Map<Integer, Set<Long>> getOutputs() {
        return this.outlist;
    }

    public Set<Long> getOutput(int n) {
        return this.outlist.get(n);
    }

    void initInlist() {
        if (this.inlist == null) {
            this.inlist = new HashMap<Integer, Set<Long>>();
        }
    }

    void initOutlist() {
        if (this.outlist == null) {
            this.outlist = new HashMap<Integer, Set<Long>>();
        }
    }

    void prepareLists() {
        if (this.inlist == null) {
            this.inlist = new HashMap<Integer, Set<Long>>();
        }
        if (this.outlist == null) {
            this.outlist = new HashMap<Integer, Set<Long>>();
        }
    }

    static Map<Integer, Set<Long>> copyList(Map<Integer, Set<Long>> map) {
        HashMap<Integer, Set<Long>> hashMap = new HashMap<Integer, Set<Long>>();
        for (int n : map.keySet()) {
            hashMap.put(n, new HashSet(map.get(n)));
        }
        return hashMap;
    }

    static void addToList(Map<Integer, Set<Long>> map, Map<Integer, Set<Long>> map2) {
        for (int n : map2.keySet()) {
            Set<Long> set = map.get(n);
            if (set == null) {
                set = new HashSet<Long>();
                map.put(n, set);
            }
            set.addAll((Collection<Long>)map2.get(n));
        }
    }

    static void addCommonsToList(Map<Integer, Set<Long>> map, Map<Integer, Set<Long>> map2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : map2.keySet()) {
            Set<Long> set = map.get(n);
            if (set == null) {
                arrayList.add(n);
                continue;
            }
            Set<Long> set2 = map2.get(n);
            for (long l2 : set2) {
                if (set.contains(l2)) continue;
                set.clear();
            }
            if (!set.isEmpty()) continue;
            arrayList.add(n);
        }
        for (int n : arrayList) {
            map.remove(n);
        }
    }

    static boolean compareLists(Map<Integer, Set<Long>> map, Map<Integer, Set<Long>> map2) {
        for (int n : map.keySet()) {
            Set<Long> set = map2.get(n);
            if (set == null) {
                return false;
            }
            if (set.equals(map.get(n))) continue;
            return false;
        }
        return true;
    }

    void applyTransferFunctionLiveRegisters() {
        this.inlist = Tracker.copyList(this.outlist);
        for (int j = this.bb.size() - 1; j >= 0; --j) {
            for (int n : this.bb.insn_def.get(j)) {
                this.inlist.remove(n);
            }
            for (int n : this.bb.insn_use.get(j)) {
                Set<Long> set = this.inlist.get(n);
                if (set == null) {
                    set = new HashSet<Long>();
                    this.inlist.put(n, set);
                }
                set.add(this.bb.getAddressOfInstruction(j));
            }
        }
    }

    void applyTransferFunctionReachingRegisters(IVariableInformationProvider iVariableInformationProvider) {
        this.outlist = Tracker.copyList(this.inlist);
        for (int j = 0; j < this.bb.size(); ++j) {
            for (int n : this.bb.insn_def.get(j)) {
                Set<Number> set;
                if (iVariableInformationProvider != null) {
                    set = iVariableInformationProvider.getSame(n);
                    for (Integer n2 : set) {
                        this.outlist.remove(n2);
                    }
                }
                if ((set = this.outlist.get(n)) == null) {
                    set = new HashSet();
                    this.outlist.put(n, set);
                } else {
                    set.clear();
                }
                set.add(this.bb.getAddressOfInstruction(j));
            }
        }
    }

    void applyTransferFunctionAvailableRegisters() {
        this.outlist = Tracker.copyList(this.inlist);
        for (int j = 0; j < this.bb.size(); ++j) {
            for (int n : this.bb.insn_def.get(j)) {
                Set<Long> set = this.outlist.get(n);
                if (set == null) {
                    set = new HashSet<Long>();
                    this.outlist.put(n, set);
                } else {
                    set.clear();
                }
                set.add(this.bb.getAddressOfInstruction(j));
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("in=%s|out=%s", this.formatListSimple(this.inlist), this.formatListSimple(this.outlist)));
        return stringBuilder.toString();
    }

    private String formatListSimple(Map<Integer, Set<Long>> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : map.keySet()) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(n2));
            ++n;
        }
        return stringBuilder.toString();
    }

    private String formatList(Map<Integer, Set<Long>> map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int n : map.keySet()) {
            stringBuilder.append(String.format("%d={", n));
            Set<Long> set = map.get(n);
            int n2 = 0;
            for (long l2 : set) {
                if (n2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(String.format("%X", l2));
                ++n2;
            }
            stringBuilder.append("} ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

