/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchResolution;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IInstructionAugmenter;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.DFA;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableInformationProvider;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IrregularFlowData;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class CFG<InsnType extends IInstruction>
implements IControlFlowGraph<InsnType>,
Iterable<BasicBlock<InsnType>> {
    private static final ILogger logger = GlobalLog.getLogger(CFG.class);
    public static final int FLAG_SUBROUTINE_CALL_NOT_BREAKING = 1;
    public static final int FLAG_ALLOW_ARTIFICIAL_BLOCK_END = 2;
    @SerId(value=1)
    List<BasicBlock<InsnType>> bblist;
    @SerId(value=2)
    long entry;
    @SerId(value=3)
    int flags;
    @SerId(value=4)
    WeakReference<IVariableInformationProvider> varInfoProvider;
    @SerTransient
    DFA<InsnType> dfa;

    private CFG(long l2, int n) {
        this.entry = l2;
        this.flags = n;
    }

    public CFG(long l2, List<BasicBlock<InsnType>> list) {
        this.entry = l2;
        this.flags = 0;
        this.bblist = list;
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : list) {
            long l3 = basicBlock.base;
            for (IInstruction iInstruction : basicBlock) {
                hashMap.put(l3, basicBlock);
                l3 += (long)iInstruction.getSize();
            }
        }
        this.buildGraphSecondPass(hashMap);
    }

    public CFG<InsnType> shallowCopy(boolean bl2) {
        CFG<InsnType> cFG = new CFG<InsnType>(this.entry, this.flags);
        cFG.bblist = new ArrayList<BasicBlock<InsnType>>(this.bblist.size());
        if (bl2) {
            cFG.bblist.addAll(this.bblist);
        }
        return cFG;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public BasicBlock<InsnType> get(int n) {
        return this.bblist.get(n);
    }

    @Override
    public int size() {
        return this.bblist.size();
    }

    public long getEntryAddress() {
        return this.entry;
    }

    public long getFirstAddress() {
        return this.bblist.get(0).getFirstAddress();
    }

    public long getLastAddress() {
        return this.bblist.get(this.bblist.size() - 1).getLastAddress();
    }

    public long getEndAddress() {
        return this.bblist.get(this.bblist.size() - 1).getEndAddress();
    }

    public int getEffectiveSize() {
        int n = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n += (int)(basicBlock.getEndAddress() - basicBlock.getFirstAddress());
        }
        return n;
    }

    public List<Couple<Long, Long>> getGaps() {
        ArrayList<Couple<Long, Long>> arrayList = new ArrayList<Couple<Long, Long>>();
        long l2 = this.bblist.get(0).getEndAddress();
        for (int j = 1; j < this.bblist.size(); ++j) {
            BasicBlock<InsnType> basicBlock = this.bblist.get(j);
            long l3 = basicBlock.getFirstAddress() - l2;
            if (l3 > 0L) {
                arrayList.add(new Couple<Long, Long>(l2, l2 + l3));
            }
            l2 = basicBlock.getEndAddress();
        }
        return arrayList;
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.bblist);
    }

    @Override
    public BasicBlock<InsnType> getBlockAt(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.base > l2) {
                return null;
            }
            if (basicBlock.base != l2) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getBlockContaining(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.getFirstAddress() > l2) {
                return null;
            }
            if (basicBlock.getEndAddress() <= l2) continue;
            return basicBlock;
        }
        return null;
    }

    public BasicBlock<InsnType> getEntryBlock() {
        IBasicBlock iBasicBlock = this.getBlockAt(this.entry);
        if (iBasicBlock == null) {
            throw new RuntimeException("Cannot find the entry block");
        }
        return iBasicBlock;
    }

    public List<BasicBlock<InsnType>> getExitBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            arrayList.add(basicBlock);
        }
        return arrayList;
    }

    public boolean hasExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<Long, BasicBlock<InsnType>> getAddressBlockMap() {
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            hashMap.put(basicBlock.base, basicBlock);
        }
        return hashMap;
    }

    @Override
    public List<InsnType> getInstructions() {
        ArrayList arrayList = new ArrayList();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            arrayList.addAll(basicBlock.insns);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public Map<Long, InsnType> getInstructionsMap() {
        HashMap<Long, InsnType> hashMap = new HashMap<Long, InsnType>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (AddressableInstruction<InsnType> addressableInstruction : basicBlock.addressableInstructions()) {
                hashMap.put(addressableInstruction.getOffset(), addressableInstruction.getInstruction());
            }
        }
        return hashMap;
    }

    @Override
    public int getInstructionCount() {
        int n = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n += basicBlock.size();
        }
        return n;
    }

    @Override
    public InsnType getInstruction(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.base > l2) {
                return null;
            }
            InsnType InsnType = basicBlock.getInstruction(l2);
            if (InsnType == null) continue;
            return InsnType;
        }
        return null;
    }

    @Override
    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (l2 < basicBlock.getFirstAddress() || l2 >= basicBlock.getEndAddress()) continue;
            int n = basicBlock.getIndexOfInstruction(l2);
            return new Couple<BasicBlock<InsnType>, Integer>(basicBlock, n);
        }
        return null;
    }

    @Override
    public void getGraphRepresentation(List<int[]> list, List<int[]> list2) {
        HashMap<BasicBlock<InsnType>, Integer> hashMap = new HashMap<BasicBlock<InsnType>, Integer>();
        int n = 1;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            hashMap.put(basicBlock, n);
            ++n;
        }
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            IBasicBlock iBasicBlock;
            int n2;
            for (n2 = basicBlock.outsize() - 1; n2 >= 0; --n2) {
                iBasicBlock = basicBlock.getOutputBlock(n2);
                list.add(new int[]{(Integer)hashMap.get(basicBlock), (Integer)hashMap.get(iBasicBlock)});
            }
            for (n2 = basicBlock.irroutsize() - 1; n2 >= 0; --n2) {
                iBasicBlock = basicBlock.getIrregularOutputBlock(n2);
                list2.add(new int[]{(Integer)hashMap.get(basicBlock), (Integer)hashMap.get(iBasicBlock)});
            }
        }
    }

    public CFG(List<? extends InsnType> list, List<IrregularFlowData> list2) {
        this(list, list2, null, 0L, 0L, 0);
    }

    public CFG(List<? extends InsnType> list, List<IrregularFlowData> list2, IInstructionAugmenter iInstructionAugmenter, long l2, long l3, int n) {
        if (l3 < l2) {
            throw new NullPointerException(String.format("Illegal entry-point (%Xh), cannot be less than base (%Xh)", l3, l2));
        }
        HashMap<Long, IInstruction> hashMap = new HashMap<Long, IInstruction>();
        long l4 = l2;
        for (IInstruction iInstruction : list) {
            hashMap.put(l4, iInstruction);
            l4 += (long)iInstruction.getSize();
        }
        this.buildCFG(hashMap, list2, iInstructionAugmenter, l3, n);
    }

    public CFG(Map<Long, InsnType> map, List<IrregularFlowData> list, IInstructionAugmenter iInstructionAugmenter, long l2, int n) {
        this.buildCFG(map, list, iInstructionAugmenter, l2, n);
    }

    private void buildCFG(Map<Long, InsnType> map, List<IrregularFlowData> list, IInstructionAugmenter iInstructionAugmenter, long l2, int n) {
        if (map == null) {
            throw new NullPointerException("No instructions were provided");
        }
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        this.flags = n;
        this.entry = l2;
        if (!map.containsKey(l2)) {
            throw new RuntimeException(String.format("The entry-point instruction (%Xh) is not present!", l2));
        }
        long l3 = 0L;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            long l4 = object.next();
            if (l4 <= l3) continue;
            l3 = l4;
        }
        this.bblist = new ArrayList<BasicBlock<InsnType>>();
        object = new HashMap();
        ArrayDeque<Long> arrayDeque = new ArrayDeque<Long>();
        arrayDeque.push(l2);
        ArrayDeque<Long> arrayDeque2 = arrayDeque;
        int n2 = 0;
        block1: while (true) {
            Object object2;
            if (!arrayDeque.isEmpty()) {
                Object object3;
                long l5 = (Long)arrayDeque.pop();
                object2 = (BasicBlock)((HashMap)object).get(l5);
                if (object2 != null) {
                    int n3;
                    if (((BasicBlock)object2).getFirstAddress() == l5) continue;
                    int n4 = this.getSplitIndex((BasicBlock<InsnType>)object2, l5);
                    if (n4 < 0) {
                        throw new RuntimeException();
                    }
                    object3 = new BasicBlock(l5);
                    this.bblist.add((BasicBlock<InsnType>)object3);
                    long l6 = l5;
                    for (n3 = n4; n3 < ((BasicBlock)object2).insns.size(); ++n3) {
                        IInstruction iInstruction = (IInstruction)((BasicBlock)object2).insns.get(n3);
                        ((BasicBlock)object3).insns.add(iInstruction);
                        ((HashMap)object).put(l6, object3);
                        l6 += (long)iInstruction.getSize();
                    }
                    ((BasicBlock)object3).dst_offsets = new ArrayList<Long>(((BasicBlock)object2).dst_offsets);
                    n3 = ((BasicBlock)object2).insns.size() - n4;
                    for (int j = 0; j < n3; ++j) {
                        ((BasicBlock)object2).insns.remove(n4);
                    }
                    ((BasicBlock)object2).dst_offsets.clear();
                    ((BasicBlock)object2).dst_offsets.add(l5);
                    continue;
                }
                object2 = new BasicBlock(l5);
                this.bblist.add((BasicBlock<InsnType>)object2);
                while (true) {
                    BasicBlock basicBlock;
                    if ((basicBlock = (BasicBlock)((HashMap)object).get(l5)) != null) {
                        if (((BasicBlock)object2).isEmpty()) {
                            throw new RuntimeException("Unexpected empty basic block");
                        }
                        ((BasicBlock)object2).dst_offsets.add(basicBlock.getFirstAddress());
                        continue block1;
                    }
                    object3 = (IInstruction)map.get(l5);
                    if (object3 == null) {
                        if (!bl3) {
                            throw new RuntimeException(String.format("No instruction at offset %Xh", l5));
                        }
                        if (!((BasicBlock)object2).isEmpty()) continue block1;
                        this.bblist.remove(object2);
                        continue block1;
                    }
                    ((BasicBlock)object2).insns.add(object3);
                    ((HashMap)object).put(l5, object2);
                    if (iInstructionAugmenter != null && iInstructionAugmenter.isArtificialEndOfBlock(l5)) continue block1;
                    IFlowInformation iFlowInformation = object3.getBreakingFlow(l5);
                    if (iFlowInformation.isBroken()) {
                        Assert.a(iFlowInformation.getDelaySlotCount() == 0, "Instructions with delay-slot are not supported by this CFG constructor");
                        if (iFlowInformation.mustComputeFallThrough()) {
                            long l7 = l5 + (long)object3.getSize();
                            ((BasicBlock)object2).dst_offsets.add(l7);
                            arrayDeque2.push(l7);
                        }
                        Iterator<IEntryPointDescription> iterator = iFlowInformation.getTargets().iterator();
                        while (true) {
                            long l8;
                            if (!iterator.hasNext()) continue block1;
                            IEntryPointDescription iEntryPointDescription = iterator.next();
                            if (iEntryPointDescription.isUnknownAddress()) {
                                IBranchResolution iBranchResolution;
                                l8 = -1L;
                                if (iInstructionAugmenter != null && (iBranchResolution = iInstructionAugmenter.getDynamicBranchResolution(l5)) != null) {
                                    for (BranchTarget branchTarget : iBranchResolution.getTargets()) {
                                        if (!branchTarget.isInternal()) continue;
                                        l8 = branchTarget.getInternalAddress().getAddress();
                                        ((BasicBlock)object2).dst_offsets.add(l8);
                                        arrayDeque2.push(l8);
                                    }
                                }
                                ((BasicBlock)object2).unknownDst = true;
                                continue;
                            }
                            l8 = iEntryPointDescription.getAddress();
                            ((BasicBlock)object2).dst_offsets.add(l8);
                            arrayDeque2.push(l8);
                        }
                    }
                    iFlowInformation = object3.getRoutineCall(l5);
                    if (iFlowInformation.isBroken()) {
                        Assert.a(iFlowInformation.getDelaySlotCount() == 0, "Instructions with delay-slot are not supported by this CFG constructor");
                        if (iInstructionAugmenter != null && iInstructionAugmenter.isCallNotReturning(l5)) continue block1;
                        if (!bl2) {
                            long l9 = l5 + (long)object3.getSize();
                            ((BasicBlock)object2).dst_offsets.add(l9);
                            arrayDeque2.push(l9);
                            continue block1;
                        }
                    }
                    l5 += (long)object3.getSize();
                }
            }
            if (list == null || n2 > 0) break;
            for (IrregularFlowData irregularFlowData : list) {
                arrayDeque2.push(irregularFlowData.target);
                arrayDeque2.push(irregularFlowData.first);
                object2 = (IInstruction)map.get(irregularFlowData.last);
                long l10 = irregularFlowData.last + (long)object2.getSize();
                if (l10 >= l3) continue;
                arrayDeque2.push(l10);
            }
            ++n2;
        }
        if (list != null) {
            for (IrregularFlowData irregularFlowData : list) {
                for (BasicBlock basicBlock : this.bblist) {
                    long l11 = basicBlock.getFirstAddress();
                    if (l11 < irregularFlowData.first || l11 > irregularFlowData.last || basicBlock.irrdst_offsets.contains(irregularFlowData.target)) continue;
                    basicBlock.irrdst_offsets.add(irregularFlowData.target);
                }
            }
        }
        this.buildGraphSecondPass((Map<Long, BasicBlock<InsnType>>)object);
    }

    private int getSplitIndex(BasicBlock<InsnType> basicBlock, long l2) {
        long l3 = basicBlock.getFirstAddress();
        int n = 0;
        for (IInstruction iInstruction : basicBlock) {
            if (l3 == l2) {
                return n;
            }
            l3 += (long)iInstruction.getSize();
            ++n;
        }
        return -1;
    }

    private void buildGraphSecondPass(Map<Long, BasicBlock<InsnType>> map) {
        boolean bl2 = (this.flags & 2) != 0;
        BasicBlock<InsnType> basicBlock = null;
        for (BasicBlock<InsnType> basicBlock2 : this.bblist) {
            BasicBlock<InsnType> basicBlock3;
            if (basicBlock2.isEmpty()) {
                throw new RuntimeException(String.format("Illegal graph: the block at address %Xh is empty!", basicBlock2.base));
            }
            for (long l2 : basicBlock2.dst_offsets) {
                basicBlock3 = map.get(l2);
                if (basicBlock3 == null) {
                    if (bl2) continue;
                    throw new RuntimeException(String.format("block@%X was not found", l2));
                }
                basicBlock2.dst.add(basicBlock3);
                basicBlock3.src.add(basicBlock2);
            }
            for (long l2 : basicBlock2.irrdst_offsets) {
                basicBlock3 = map.get(l2);
                basicBlock2.irrdst.add(basicBlock3);
                basicBlock3.irrsrc.add(basicBlock2);
            }
            basicBlock2.dst_offsets = null;
            basicBlock2.irrdst_offsets = null;
            if (basicBlock != null || basicBlock2.base != this.entry) continue;
            basicBlock = basicBlock2;
        }
        if (basicBlock == null) {
            throw new RuntimeException(String.format("Invalid entry address %Xh (does not match any block)", this.entry));
        }
        Collections.sort(this.bblist, new Comparator<BasicBlock<InsnType>>(){

            @Override
            public int compare(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
                return Long.compare(basicBlock.base, basicBlock2.base);
            }
        });
    }

    public int simplify(boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bblist.size()) {
            boolean bl5;
            BasicBlock<InsnType> basicBlock = this.bblist.get(n2);
            boolean bl6 = bl5 = !basicBlock.hasUnknownDst() && (basicBlock.outsize() == 1 || basicBlock.outsize() == 2 && basicBlock.getOutputBlock(0) == basicBlock.getOutputBlock(1));
            if (bl5 && basicBlock.irroutsize() == 0 && basicBlock.size() >= 1 && (bl3 || basicBlock.getBranchingInstruction2(true, false) == null) && (bl2 || basicBlock.getBranchingInstruction2(false, true) == null)) {
                boolean bl7;
                IBasicBlock iBasicBlock = basicBlock.getOutputBlock(0);
                boolean bl8 = bl7 = ((BasicBlock)iBasicBlock).insize() == 1 || ((BasicBlock)iBasicBlock).insize() == 2 && ((BasicBlock)iBasicBlock).getInputBlock(0) == ((BasicBlock)iBasicBlock).getInputBlock(1);
                if (bl7 && ((BasicBlock)iBasicBlock).irrinsize() == 0 && ((BasicBlock)iBasicBlock).irroutsize() == 0) {
                    boolean bl9;
                    boolean bl10 = bl9 = ((BasicBlock)iBasicBlock).base == basicBlock.getEndAddress();
                    if (!bl9 && bl4 && ((BasicBlock)iBasicBlock).outsize() == 0 && basicBlock.base < ((BasicBlock)iBasicBlock).base) {
                        boolean bl11 = false;
                        for (BasicBlock basicBlock2 : this.bblist) {
                            if (basicBlock2 == basicBlock || basicBlock2 == iBasicBlock || basicBlock2.base <= basicBlock.base || basicBlock2.base >= ((BasicBlock)iBasicBlock).base) continue;
                            bl11 = true;
                        }
                        if (!bl11) {
                            bl9 = true;
                        }
                    }
                    if (bl9) {
                        if (((BasicBlock)iBasicBlock).insize() == 2 && ((BasicBlock)iBasicBlock).getInputBlock(0) == ((BasicBlock)iBasicBlock).getInputBlock(1) && !this.deleteDuplicateEdge(basicBlock, (BasicBlock<InsnType>)iBasicBlock, true)) {
                            logger.i("=> Duplicate edge removal failed", new Object[0]);
                            throw new RuntimeException();
                        }
                        Iterator iterator = ((BasicBlock)iBasicBlock).iterator();
                        while (iterator.hasNext()) {
                            IInstruction iInstruction = (IInstruction)iterator.next();
                            basicBlock.insns.add(iInstruction);
                        }
                        this.removeBlock((BasicBlock<InsnType>)iBasicBlock, false);
                        ++n;
                        continue;
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public void removeBlock(BasicBlock<InsnType> basicBlock, boolean bl2) {
        Object object;
        if (basicBlock.irrinsize() != 0) {
            logger.i("Irregular flow reach this block (exception handler), it cannot be removed", new Object[0]);
            throw new RuntimeException();
        }
        if (basicBlock.outsize() == 1) {
            object = basicBlock.getOutputBlock(0);
            if (object == basicBlock) {
                logger.i("The empty block makes an infinite loop", new Object[0]);
                throw new RuntimeException();
            }
            int n = 0;
            while (n < ((BasicBlock)object).insize()) {
                if (((BasicBlock)object).getInputBlock(n) == basicBlock) {
                    ((BasicBlock)object).src.remove(n);
                    continue;
                }
                ++n;
            }
            for (BasicBlock<InsnType> basicBlock2 : basicBlock.getInputBlocks()) {
                for (n = 0; n < basicBlock2.outsize(); ++n) {
                    if (basicBlock2.getOutputBlock(n) != basicBlock) continue;
                    basicBlock2.dst.set(n, object);
                    ((BasicBlock)object).src.add(basicBlock2);
                }
            }
        } else if (basicBlock.insize() == 1) {
            object = basicBlock.getInputBlock(0);
            if (object == basicBlock) {
                logger.i("The empty block makes an infinite loop", new Object[0]);
                throw new RuntimeException();
            }
            int n = 0;
            while (n < ((BasicBlock)object).outsize()) {
                if (((BasicBlock)object).getOutputBlock(n) == basicBlock) {
                    ((BasicBlock)object).dst.remove(n);
                    continue;
                }
                ++n;
            }
            for (BasicBlock<InsnType> basicBlock2 : basicBlock.getOutputBlocks()) {
                for (n = 0; n < basicBlock2.insize(); ++n) {
                    if (basicBlock2.getInputBlock(n) != basicBlock) continue;
                    basicBlock2.src.set(n, object);
                    ((BasicBlock)object).dst.add(basicBlock2);
                }
            }
        } else if (basicBlock.insize() == 0) {
            for (BasicBlock<InsnType> basicBlock3 : basicBlock.getOutputBlocks()) {
                int n = 0;
                while (n < basicBlock3.insize()) {
                    if (basicBlock3.getInputBlock(n) == basicBlock) {
                        basicBlock3.src.remove(n);
                        continue;
                    }
                    ++n;
                }
            }
        }
        for (BasicBlock<InsnType> basicBlock4 : basicBlock.getIrregularOutputBlocks()) {
            int n = 0;
            while (n < basicBlock4.irrinsize()) {
                if (basicBlock4.getIrregularInputBlock(n) == basicBlock) {
                    basicBlock4.irrsrc.remove(n);
                    continue;
                }
                ++n;
            }
        }
        this.bblist.remove(basicBlock);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3, boolean bl2) {
        int n = -1;
        for (int j = 0; j < basicBlock.outsize(); ++j) {
            IBasicBlock iBasicBlock = basicBlock.getOutputBlock(j);
            if (iBasicBlock == basicBlock2) {
                if (n != -1) {
                    throw new RuntimeException();
                }
                n = j;
                continue;
            }
            if (iBasicBlock != basicBlock3) continue;
            return -1;
        }
        if (n < 0) {
            return 0;
        }
        basicBlock.dst.set(n, basicBlock3);
        basicBlock2.src.remove(basicBlock);
        basicBlock3.src.add(basicBlock);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
        return 1;
    }

    public boolean addEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, boolean bl2) {
        boolean bl3;
        for (BasicBlock<InsnType> basicBlock3 : basicBlock.getOutputBlocks()) {
            if (basicBlock3 != basicBlock2) continue;
            return false;
        }
        boolean bl4 = bl3 = basicBlock.getEndAddress() == basicBlock2.getFirstAddress();
        if (bl3) {
            basicBlock.dst.add(0, basicBlock2);
        } else {
            basicBlock.dst.add(basicBlock2);
        }
        basicBlock2.src.add(basicBlock);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
        return true;
    }

    public boolean deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, boolean bl2) {
        int n = -1;
        for (int j = 0; j < basicBlock.outsize(); ++j) {
            IBasicBlock iBasicBlock = basicBlock.getOutputBlock(j);
            if (iBasicBlock != basicBlock2) continue;
            if (n != -1) {
                throw new RuntimeException();
            }
            n = j;
        }
        if (n < 0) {
            return false;
        }
        basicBlock.dst.remove(n);
        basicBlock2.src.remove(basicBlock);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
        return true;
    }

    public boolean deleteDuplicateEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, boolean bl2) {
        int n = -1;
        boolean bl3 = false;
        for (int j = 0; j < basicBlock.outsize(); ++j) {
            IBasicBlock iBasicBlock = basicBlock.getOutputBlock(j);
            if (iBasicBlock != basicBlock2) continue;
            if (n != -1) {
                bl3 = true;
                break;
            }
            n = j;
        }
        if (!bl3) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        basicBlock.dst.remove(n);
        basicBlock2.src.remove(basicBlock);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
        return true;
    }

    public void deleteAllEdges() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            basicBlock.src.clear();
            basicBlock.dst.clear();
        }
    }

    public int pruneOrphans() {
        int n;
        int n2 = 0;
        do {
            n = 0;
            for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
                if (basicBlock.insize() != 0 || basicBlock == this.getEntryBlock()) continue;
                this.removeBlock(basicBlock, false);
                ++n;
            }
            n2 += n;
        } while (n > 0);
        return n2;
    }

    public InsnType replaceInstruction(long l2, InsnType InsnType) {
        return this.replaceInstruction(l2, InsnType, false);
    }

    public InsnType replaceInstruction(long l2, InsnType InsnType, boolean bl2) {
        IBasicBlock iBasicBlock = this.getBlockContaining(l2);
        if (iBasicBlock == null) {
            return null;
        }
        int n = ((BasicBlock)iBasicBlock).getIndexOfInstruction(l2);
        if (n < 0) {
            return null;
        }
        InsnType InsnType2 = ((BasicBlock)iBasicBlock).set(n, InsnType);
        if (!bl2) {
            this.invalidateDataFlowAnalysis();
        }
        return InsnType2;
    }

    public IVariableInformationProvider setVariableInformationProvider(IVariableInformationProvider iVariableInformationProvider) {
        IVariableInformationProvider iVariableInformationProvider2 = this.getVariableInformationProvider();
        this.varInfoProvider = new WeakReference<IVariableInformationProvider>(iVariableInformationProvider);
        return iVariableInformationProvider2;
    }

    public IVariableInformationProvider getVariableInformationProvider() {
        return this.varInfoProvider == null ? null : (IVariableInformationProvider)this.varInfoProvider.get();
    }

    public void doDataFlowAnalysis() {
        this.doDataFlowAnalysis(false);
    }

    public void doDataFlowAnalysis(boolean bl2) {
        this.doDataFlowAnalysis(bl2, true);
    }

    public void doDataFlowAnalysis(boolean bl2, boolean bl3) {
        if (this.dfa == null) {
            this.dfa = new DFA(this);
        }
        this.dfa.perform(bl2, bl3, this.getVariableInformationProvider());
    }

    public void invalidateDataFlowAnalysis() {
        if (this.dfa != null) {
            this.dfa.invalidate();
        }
    }

    public Map<Integer, Set<Long>> getInputMap() {
        if (this.dfa == null || !this.dfa.done) {
            throw new IllegalStateException();
        }
        return this.getEntryBlock().getTrackerLiveRegisters().getInputs();
    }

    public Map<Integer, Set<Long>> getOuputMap() {
        if (this.dfa == null || !this.dfa.done) {
            throw new IllegalStateException();
        }
        HashMap<Integer, Set<Long>> hashMap = new HashMap<Integer, Set<Long>>();
        for (BasicBlock<InsnType> basicBlock : this.getExitBlocks()) {
            Map<Integer, Set<Long>> map = basicBlock.getTrackerReachingRegisters().getOutputs();
            for (Integer n : map.keySet()) {
                HashSet hashSet = (HashSet)hashMap.get(n);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(n, hashSet);
                }
                hashSet.addAll(map.get(n));
            }
        }
        return hashMap;
    }

    public String formatSimple() {
        return this.format(true, 0, false);
    }

    public String format() {
        return this.format(true, 1, true);
    }

    public String format(boolean bl2, int n, boolean bl3) {
        return this.format(bl2, n, bl3, null);
    }

    public String format(boolean bl2, int n, boolean bl3, IFormattingContextFactory<InsnType> iFormattingContextFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            Iterator<BasicBlock<InsnType>> iterator = this.getEntryBlock();
            BasicBlock<InsnType> basicBlock = this.formatChain(((BasicBlock)((Object)iterator)).getTrackerLiveRegisters().getInputs());
            stringBuilder.append(String.format(">> IN(@%X): %s\n", this.entry, basicBlock));
        }
        for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
            int n2 = 0;
            for (IInstruction iInstruction : basicBlock) {
                String string;
                String string2;
                long l2 = basicBlock.getAddressOfInstruction(n2);
                if (bl2) {
                    char c = n2 >= 1 ? (char)':' : (basicBlock.getFirstAddress() == this.entry ? (char)'>' : (basicBlock.irrinsize() == 0 ? (char)'+' : '*'));
                    stringBuilder.append(String.format("%04X/%X%c  ", l2, iInstruction.getSize(), Character.valueOf(c)));
                }
                Object object = iFormattingContextFactory == null ? Long.valueOf(l2) : iFormattingContextFactory.createFormattingContext(iInstruction);
                stringBuilder.append(String.format("%-100s  ", iInstruction.format(object)));
                if (n == 1) {
                    string2 = this.formatChain(basicBlock.listDuChains.get(n2));
                    string = this.formatChain(basicBlock.listUdChains.get(n2));
                    stringBuilder.append(String.format("du: %s| ud: %s", string2, string));
                } else if (n == 2) {
                    string2 = this.formatChain(basicBlock.listFullDuChains.get(n2));
                    string = this.formatChain(basicBlock.listFullUdChains.get(n2));
                    stringBuilder.append(String.format("DU:%s| UD: %s", string2, string));
                }
                stringBuilder.append('\n');
                ++n2;
            }
        }
        if (bl3) {
            for (BasicBlock<InsnType> basicBlock : this.getExitBlocks()) {
                String string = this.formatChain(basicBlock.getTrackerReachingRegisters().getOutputs());
                stringBuilder.append(String.format("<< OUT(@%X): %s\n", basicBlock.getEndAddress(), string));
            }
        }
        return stringBuilder.toString();
    }

    private <T extends Number> String formatChain(Map<Integer, Set<T>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        IVariableInformationProvider iVariableInformationProvider = this.getVariableInformationProvider();
        TreeMap<Integer, Set<T>> treeMap = new TreeMap<Integer, Set<T>>(map);
        for (int n : treeMap.keySet()) {
            stringBuilder.append("(");
            if (iVariableInformationProvider != null) {
                stringBuilder.append(iVariableInformationProvider.getName(n));
            } else {
                stringBuilder.append(n >= 0 ? Integer.toHexString(n) : "-" + Integer.toHexString(-n));
            }
            stringBuilder.append(")={");
            ArrayList arrayList = new ArrayList(treeMap.get(n));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n2 = 0;
            for (Number number : arrayList) {
                String string;
                if (n2 >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    string = number.intValue() == -1 ? "other_block" : Integer.toHexString(number.intValue()).toUpperCase();
                    stringBuilder.append(string);
                } else if (number instanceof Long) {
                    string = number.longValue() == -1L ? "init" : Long.toHexString(number.longValue()).toUpperCase();
                    stringBuilder.append("@").append(string);
                }
                ++n2;
            }
            stringBuilder.append("} ");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.format("CFG(%d): ", this.bblist.size()));
        int n = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(basicBlock);
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<BasicBlock<InsnType>> iterator() {
        return this.bblist.iterator();
    }

    public Iterable<InsnType> instructions() {
        return new Iterable<InsnType>(){

            @Override
            public Iterator<InsnType> iterator() {
                return new InstructionsIterator();
            }
        };
    }

    public Iterable<AddressableInstruction<InsnType>> addressableInstructions() {
        return new Iterable<AddressableInstruction<InsnType>>(){

            @Override
            public Iterator<AddressableInstruction<InsnType>> iterator() {
                return new AddressableInstructionsIterator();
            }
        };
    }

    private class AddressableInstructionsIterator
    implements Iterator<AddressableInstruction<InsnType>> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;
        private long address;

        private AddressableInstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
                this.address = this.blk.base;
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public AddressableInstruction<InsnType> next() {
            if (this.blk == null) {
                throw new NoSuchElementException();
            }
            Object InsnType = this.blk.get(this.insnIndex);
            AddressableInstruction addressableInstruction = new AddressableInstruction(this.address, InsnType);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                if (this.blkIndex >= CFG.this.bblist.size()) {
                    this.blk = null;
                } else {
                    this.blk = CFG.this.bblist.get(this.blkIndex);
                    this.address = this.blk.base;
                }
            } else {
                this.address += (long)InsnType.getSize();
            }
            return addressableInstruction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class InstructionsIterator
    implements Iterator<InsnType> {
        private int blkIndex;
        private int insnIndex;
        private BasicBlock<InsnType> blk;

        private InstructionsIterator() {
            if (CFG.this.bblist.size() > 0) {
                this.blk = CFG.this.bblist.get(0);
            }
        }

        @Override
        public boolean hasNext() {
            return this.blk != null;
        }

        @Override
        public InsnType next() {
            if (this.blk == null) {
                throw new NoSuchElementException();
            }
            Object InsnType = this.blk.get(this.insnIndex);
            ++this.insnIndex;
            if (this.insnIndex >= this.blk.size()) {
                this.insnIndex = 0;
                ++this.blkIndex;
                this.blk = this.blkIndex >= CFG.this.bblist.size() ? null : CFG.this.bblist.get(this.blkIndex);
            }
            return InsnType;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

