/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBinaryPattern;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Ser
public class BinaryPatternVerifier {
    @SerId(value=1)
    private List<IBinaryPattern> patterns = new ArrayList<IBinaryPattern>();
    @SerId(value=2)
    private int longestSize;

    public void addPatterns(Collection<IBinaryPattern> collection) {
        for (IBinaryPattern iBinaryPattern : collection) {
            this.addPattern(iBinaryPattern);
        }
    }

    public void addPatterns(IBinaryPattern ... iBinaryPatternArray) {
        for (IBinaryPattern iBinaryPattern : iBinaryPatternArray) {
            this.addPattern(iBinaryPattern);
        }
    }

    public void addPattern(IBinaryPattern iBinaryPattern) {
        if (iBinaryPattern == null) {
            throw new NullPointerException();
        }
        this.patterns.add(iBinaryPattern);
        int n = iBinaryPattern.getBinary().length + iBinaryPattern.getRealStartOffset();
        if (n > this.longestSize) {
            this.longestSize = n;
        }
    }

    public Collection<IBinaryPattern> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public void clear() {
        this.patterns.clear();
        this.longestSize = 0;
    }

    public int getLongestSize() {
        return this.longestSize;
    }

    public IBinaryPattern verify(INativeCodeAnalyzer<?> iNativeCodeAnalyzer, long l2, byte[] byArray, int n, int n2) {
        return this.verify(iNativeCodeAnalyzer, l2, byArray, n, n2, 0);
    }

    public IBinaryPattern verify(INativeCodeAnalyzer<?> iNativeCodeAnalyzer, long l2, byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException();
        }
        for (IBinaryPattern iBinaryPattern : this.patterns) {
            if (n3 != 0 && iBinaryPattern.getBinary() != null && iBinaryPattern.getBinary().length != n3 || !this.check(iNativeCodeAnalyzer, l2, iBinaryPattern, byArray, n, n2)) continue;
            return iBinaryPattern;
        }
        return null;
    }

    private boolean check(INativeCodeAnalyzer<?> iNativeCodeAnalyzer, long l2, IBinaryPattern iBinaryPattern, byte[] byArray, int n, int n2) {
        byte[] byArray2 = iBinaryPattern.getBinary();
        int n3 = n + iBinaryPattern.getRealStartOffset();
        int n4 = n3 + byArray2.length;
        if (n4 > n2) {
            return false;
        }
        byte[] byArray3 = iBinaryPattern.getMask();
        if (byArray3 == null) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[n3 + j] == byArray2[j]) continue;
                return false;
            }
        } else {
            for (int j = 0; j < byArray2.length; ++j) {
                if ((byArray[n3 + j] & byArray3[j]) == byArray2[j]) continue;
                return false;
            }
        }
        return iBinaryPattern.validate(iNativeCodeAnalyzer, l2, byArray, n, n2);
    }
}

