/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlockBuilder;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.ChainType;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.IVariableInformationProvider;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.IrregularFlowData;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.Tracker;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.IntegerList;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class CFG<InsnType extends ILocatedInstruction>
implements IControlFlowGraph<InsnType> {
    private static final ILogger logger = GlobalLog.getLogger(CFG.class);
    private static final long entry = 0L;
    @SerId(value=1)
    private List<BasicBlock<InsnType>> bblist = null;
    @SerTransient
    IVariableInformationProvider varInfoProvider;
    @SerTransient
    private boolean dfa_done = false;
    @SerTransient
    Map<InsnType, List<Integer>> insn_def = null;
    @SerTransient
    Map<InsnType, List<Integer>> insn_use = null;
    @SerTransient
    private Map<BasicBlock<InsnType>, Tracker<InsnType>> live_registers = null;
    @SerTransient
    private Map<BasicBlock<InsnType>, Tracker<InsnType>> reaching_registers = null;
    @SerTransient
    private Map<InsnType, Map<Integer, List<Integer>>> dict_du_chains = null;
    @SerTransient
    private Map<InsnType, Map<Integer, List<Integer>>> dict_ud_chains = null;
    @SerTransient
    private Map<InsnType, Map<Integer, List<InsnType>>> dict_full_du_chains = null;
    @SerTransient
    private Map<InsnType, Map<Integer, List<InsnType>>> dict_full_ud_chains = null;

    public CFG(List<BasicBlockBuilder<InsnType>> list) {
        this.bblist = new ArrayList<BasicBlock<InsnType>>(list.size());
        HashMap<Long, BasicBlock<InsnType>> hashMap = new HashMap<Long, BasicBlock<InsnType>>();
        for (BasicBlockBuilder<InsnType> basicBlockBuilder : list) {
            BasicBlock basicBlock = new BasicBlock();
            basicBlock.insns = basicBlockBuilder.insns;
            basicBlock.dst_offsets = basicBlockBuilder.dst_offsets;
            basicBlock.irrdst_offsets = basicBlockBuilder.irrdst_offsets;
            this.bblist.add(basicBlock);
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                hashMap.put(iLocatedInstruction.getOffset(), basicBlock);
            }
        }
        this.buildGraphSecondPass(hashMap);
    }

    public CFG(List<InsnType> list, List<IrregularFlowData> list2) {
        this.buildGraph(list, list2);
    }

    @Override
    public BasicBlock<InsnType> get(int n) {
        return this.bblist.get(n);
    }

    public BasicBlock<InsnType> getLast() {
        return this.bblist.get(this.bblist.size() - 1);
    }

    @Override
    public int size() {
        return this.bblist.size();
    }

    @Override
    public List<BasicBlock<InsnType>> getBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.bblist);
    }

    @Override
    public BasicBlock<InsnType> getBlockAt(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.get(0).getOffset() != l2) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public BasicBlock<InsnType> getBlockContaining(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.getFirstAddress() > l2 || basicBlock.getEndAddress() <= l2) continue;
            return basicBlock;
        }
        return null;
    }

    public BasicBlock<InsnType> getEntryBlock() {
        IBasicBlock iBasicBlock = this.getBlockAt(0L);
        if (iBasicBlock == null) {
            throw new RuntimeException("Cannot find the entry block");
        }
        return iBasicBlock;
    }

    public List<BasicBlock<InsnType>> getExitBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            arrayList.add(basicBlock);
        }
        return arrayList;
    }

    public boolean hasExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoExit() {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.getOutputBlocks().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TreeMap<Long, BasicBlock<InsnType>> getAddressBlockMap() {
        TreeMap<Long, BasicBlock<InsnType>> treeMap = new TreeMap<Long, BasicBlock<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            treeMap.put(basicBlock.get(0).getOffset(), basicBlock);
        }
        return treeMap;
    }

    public BasicBlock<InsnType> getBlockFor(InsnType InsnType) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (!basicBlock.insns.contains(InsnType)) continue;
            return basicBlock;
        }
        return null;
    }

    @Override
    public int getInstructionCount() {
        int n = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            n += basicBlock.size();
        }
        return n;
    }

    public InsnType getInstructionAt(long l2) {
        return (InsnType)this.getInstruction(l2);
    }

    @Override
    public InsnType getInstruction(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                if (iLocatedInstruction.getOffset() != l2) continue;
                return (InsnType)iLocatedInstruction;
            }
        }
        return null;
    }

    @Override
    public Couple<BasicBlock<InsnType>, Integer> getInstructionLocation(long l2) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (l2 < basicBlock.getFirstAddress() || l2 >= basicBlock.getEndAddress()) continue;
            int n = 0;
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                if (iLocatedInstruction.getOffset() == l2) {
                    return new Couple<BasicBlock<InsnType>, Integer>(basicBlock, n);
                }
                ++n;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<InsnType> getInstructions() {
        ArrayList arrayList = new ArrayList();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            arrayList.addAll(basicBlock.insns);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public TreeMap<Long, InsnType> getInstructionSet() {
        TreeMap<Long, ILocatedInstruction> treeMap = new TreeMap<Long, ILocatedInstruction>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                treeMap.put(iLocatedInstruction.getOffset(), iLocatedInstruction);
            }
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.format("CFG(%d): ", this.bblist.size()));
        int n = 0;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(basicBlock);
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public void getGraphRepresentation(List<int[]> list, List<int[]> list2) {
        HashMap<BasicBlock<InsnType>, Integer> hashMap = new HashMap<BasicBlock<InsnType>, Integer>();
        int n = 1;
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            hashMap.put(basicBlock, n);
            ++n;
        }
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            BasicBlock basicBlock2;
            int n2;
            for (n2 = basicBlock.dst.size() - 1; n2 >= 0; --n2) {
                basicBlock2 = basicBlock.dst.get(n2);
                list.add(new int[]{(Integer)hashMap.get(basicBlock), (Integer)hashMap.get(basicBlock2)});
            }
            for (n2 = basicBlock.irrdst.size() - 1; n2 >= 0; --n2) {
                basicBlock2 = basicBlock.irrdst.get(n2);
                list2.add(new int[]{(Integer)hashMap.get(basicBlock), (Integer)hashMap.get(basicBlock2)});
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildGraph(List<InsnType> list, List<IrregularFlowData> list2) {
        if (list.size() == 0 || ((ILocatedInstruction)list.get(0)).getOffset() != 0L) {
            throw new RuntimeException();
        }
        Collections.sort(list, new Comparator<InsnType>(){

            @Override
            public int compare(InsnType InsnType, InsnType InsnType2) {
                return Long.compare(InsnType.getOffset(), InsnType2.getOffset());
            }
        });
        ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)list.get(list.size() - 1);
        long l2 = iLocatedInstruction.getOffset() + (long)iLocatedInstruction.getSize();
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        for (int j = 0; j < list.size(); ++j) {
            hashMap.put(((ILocatedInstruction)list.get(j)).getOffset(), j);
        }
        this.bblist = new ArrayList<BasicBlock<InsnType>>();
        HashMap<Long, BasicBlock<InsnType>> hashMap2 = new HashMap<Long, BasicBlock<InsnType>>();
        ArrayDeque<Long> arrayDeque = new ArrayDeque<Long>();
        arrayDeque.push(0L);
        int n = 0;
        block1: while (true) {
            Object object;
            if (!arrayDeque.isEmpty()) {
                Object object2;
                long l3 = (Long)arrayDeque.pop();
                object = (BasicBlock)hashMap2.get(l3);
                if (object != null) {
                    if (((ILocatedInstruction)((BasicBlock)object).insns.get(0)).getOffset() == l3) continue;
                    int n2 = -1;
                    int n3 = 0;
                    for (ILocatedInstruction iLocatedInstruction2 : ((BasicBlock)object).insns) {
                        if (iLocatedInstruction2.getOffset() == l3) {
                            n2 = n3;
                            break;
                        }
                        ++n3;
                    }
                    if (n2 < 0) {
                        throw new RuntimeException();
                    }
                    object2 = new BasicBlock();
                    this.bblist.add((BasicBlock<InsnType>)object2);
                    for (n3 = n2; n3 < ((BasicBlock)object).insns.size(); ++n3) {
                        ILocatedInstruction iLocatedInstruction2;
                        iLocatedInstruction2 = (ILocatedInstruction)((BasicBlock)object).insns.get(n3);
                        ((BasicBlock)object2).insns.add(iLocatedInstruction2);
                        hashMap2.put(iLocatedInstruction2.getOffset(), (BasicBlock<InsnType>)object2);
                    }
                    ((BasicBlock)object2).dst_offsets = new ArrayList<Long>(((BasicBlock)object).dst_offsets);
                    int n4 = ((BasicBlock)object).insns.size() - n2;
                    for (n3 = 0; n3 < n4; ++n3) {
                        ((BasicBlock)object).insns.remove(n2);
                    }
                    ((BasicBlock)object).dst_offsets.clear();
                    ((BasicBlock)object).dst_offsets.add(l3);
                    continue;
                }
                object = new BasicBlock();
                this.bblist.add((BasicBlock<InsnType>)object);
                while (true) {
                    BasicBlock basicBlock;
                    if ((basicBlock = (BasicBlock)hashMap2.get(l3)) != null) {
                        if (((BasicBlock)object).insns.isEmpty()) {
                            logger.i("Unexpected empty basic block", new Object[0]);
                            throw new RuntimeException();
                        }
                        ((BasicBlock)object).dst_offsets.add(((ILocatedInstruction)basicBlock.insns.get(0)).getOffset());
                        continue block1;
                    }
                    ILocatedInstruction iLocatedInstruction3 = (ILocatedInstruction)list.get((Integer)hashMap.get(l3));
                    ((BasicBlock)object).insns.add(iLocatedInstruction3);
                    hashMap2.put(l3, (BasicBlock<InsnType>)object);
                    object2 = iLocatedInstruction3.getBreakingFlow();
                    if (object2.isBroken()) {
                        Iterator<IEntryPointDescription> iterator = object2.getTargets().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block1;
                            IEntryPointDescription iEntryPointDescription = iterator.next();
                            if (iEntryPointDescription.isUnknownAddress()) {
                                throw new RuntimeException("TBI");
                            }
                            ((BasicBlock)object).dst_offsets.add(iEntryPointDescription.getAddress());
                            arrayDeque.push(iEntryPointDescription.getAddress());
                        }
                    }
                    l3 += (long)iLocatedInstruction3.getSize();
                }
            }
            if (list2 == null || n > 0) break;
            for (IrregularFlowData irregularFlowData : list2) {
                arrayDeque.push(irregularFlowData.target);
                arrayDeque.push(irregularFlowData.first);
                object = (ILocatedInstruction)list.get((Integer)hashMap.get(irregularFlowData.last));
                long l4 = object.getOffset() + (long)object.getSize();
                if (l4 >= l2) continue;
                arrayDeque.push(l4);
            }
            ++n;
        }
        if (list2 != null) {
            for (IrregularFlowData irregularFlowData : list2) {
                for (BasicBlock basicBlock : this.bblist) {
                    long l5 = ((ILocatedInstruction)basicBlock.insns.get(0)).getOffset();
                    if (l5 < irregularFlowData.first || l5 > irregularFlowData.last || basicBlock.irrdst_offsets.contains(irregularFlowData.target)) continue;
                    basicBlock.irrdst_offsets.add(irregularFlowData.target);
                }
            }
        }
        this.buildGraphSecondPass(hashMap2);
    }

    public List<IrregularFlowData> generateIrregularFlowDataObjects() {
        ArrayList<IrregularFlowData> arrayList = new ArrayList<IrregularFlowData>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            if (basicBlock.irrdst == null) continue;
            for (BasicBlock basicBlock2 : basicBlock.irrdst) {
                arrayList.add(new IrregularFlowData(basicBlock.getFirstAddress(), basicBlock.getLastAddress(), basicBlock2.getFirstAddress()));
            }
        }
        return arrayList;
    }

    private void buildGraphSecondPass(Map<Long, BasicBlock<InsnType>> map) {
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            BasicBlock<InsnType> basicBlock2;
            for (long l2 : basicBlock.dst_offsets) {
                basicBlock2 = map.get(l2);
                basicBlock.dst.add(basicBlock2);
                basicBlock2.src.add(basicBlock);
            }
            for (long l2 : basicBlock.irrdst_offsets) {
                basicBlock2 = map.get(l2);
                basicBlock.irrdst.add(basicBlock2);
                basicBlock2.irrsrc.add(basicBlock);
            }
            basicBlock.dst_offsets = null;
            basicBlock.irrdst_offsets = null;
        }
        Collections.sort(this.bblist, new Comparator<BasicBlock<InsnType>>(){

            @Override
            public int compare(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
                return Long.compare(((ILocatedInstruction)basicBlock.insns.get(0)).getOffset(), ((ILocatedInstruction)basicBlock2.insns.get(0)).getOffset());
            }
        });
    }

    public int simplify() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bblist.size()) {
            BasicBlock<InsnType> basicBlock = this.bblist.get(n2);
            if (basicBlock.outsize() == 1 && basicBlock.irroutsize() == 0 && basicBlock.size() >= 1 && !basicBlock.getLast().getBreakingFlow().isBroken()) {
                BasicBlock<InsnType> basicBlock2 = null;
                IInstruction iInstruction = basicBlock.getLast();
                long l2 = iInstruction.getOffset() + (long)iInstruction.getSize();
                for (BasicBlock<InsnType> basicBlock3 : this.bblist) {
                    if (basicBlock3.insize() != 1 || basicBlock3.irrinsize() != 0 || basicBlock3.irroutsize() != 0 || basicBlock3.get(0).getOffset() != l2) continue;
                    basicBlock2 = basicBlock3;
                    break;
                }
                if (basicBlock2 != null) {
                    for (BasicBlock<InsnType> basicBlock3 : basicBlock2.insns) {
                        basicBlock.insns.add(basicBlock3);
                    }
                    this.removeBlock(basicBlock2);
                    ++n;
                    continue;
                }
            }
            ++n2;
        }
        return n;
    }

    public int simplifyIrregularFlows() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bblist.size()) {
            BasicBlock<InsnType> basicBlock = this.bblist.get(n2);
            if (basicBlock.outsize() == 1 && basicBlock.size() >= 1 && !basicBlock.getLast().getBreakingFlow().isBroken()) {
                IInstruction iInstruction = basicBlock.getLast();
                long l2 = iInstruction.getOffset() + (long)iInstruction.getSize();
                IBasicBlock iBasicBlock = basicBlock.getOutputBlock(0);
                if (((BasicBlock)iBasicBlock).get(0).getOffset() == l2 && ((BasicBlock)iBasicBlock).insize() == 1 && ((BasicBlock)iBasicBlock).irrinsize() == 0 && ((BasicBlock)iBasicBlock).irroutsize() == 0) {
                    boolean bl2 = true;
                    for (ILocatedInstruction iLocatedInstruction : ((BasicBlock)iBasicBlock).insns) {
                        if (!iLocatedInstruction.canThrow()) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        for (ILocatedInstruction iLocatedInstruction : ((BasicBlock)iBasicBlock).insns) {
                            basicBlock.insns.add(iLocatedInstruction);
                        }
                        this.removeBlock((BasicBlock<InsnType>)iBasicBlock);
                        ++n;
                        continue;
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void removeBlock(BasicBlock<InsnType> basicBlock) {
        BasicBlock basicBlock2;
        if (basicBlock.irrinsize() != 0) {
            logger.i("Irregular flow reach this block (exception handler), it cannot be removed", new Object[0]);
            throw new RuntimeException();
        }
        if (basicBlock.outsize() == 1) {
            void basicBlock4;
            basicBlock2 = basicBlock.dst.get(0);
            if (basicBlock2 == basicBlock) {
                logger.i("The empty block makes an infinite loop", new Object[0]);
                throw new RuntimeException();
            }
            boolean n = false;
            while (basicBlock4 < basicBlock2.src.size()) {
                if (basicBlock2.src.get((int)basicBlock4) == basicBlock) {
                    basicBlock2.src.remove((int)basicBlock4);
                    continue;
                }
                ++basicBlock4;
            }
            for (BasicBlock basicBlock3 : basicBlock.src) {
                for (int j = 0; j < basicBlock3.dst.size(); ++j) {
                    if (basicBlock3.dst.get(j) != basicBlock) continue;
                    basicBlock3.dst.set(j, basicBlock2);
                    basicBlock2.src.add(basicBlock3);
                }
            }
        } else if (basicBlock.insize() == 1) {
            void var3_7;
            basicBlock2 = basicBlock.src.get(0);
            if (basicBlock2 == basicBlock) {
                logger.i("The empty block makes an infinite loop", new Object[0]);
                throw new RuntimeException();
            }
            boolean bl2 = false;
            while (var3_7 < basicBlock2.dst.size()) {
                if (basicBlock2.dst.get((int)var3_7) == basicBlock) {
                    basicBlock2.dst.remove((int)var3_7);
                    continue;
                }
                ++var3_7;
            }
            for (BasicBlock basicBlock3 : basicBlock.dst) {
                for (int j = 0; j < basicBlock3.src.size(); ++j) {
                    if (basicBlock3.src.get(j) != basicBlock) continue;
                    basicBlock3.src.set(j, basicBlock2);
                    basicBlock2.dst.add(basicBlock3);
                }
            }
        }
        for (BasicBlock basicBlock4 : basicBlock.irrdst) {
            int n = 0;
            while (n < basicBlock4.irrsrc.size()) {
                if (basicBlock4.irrsrc.get(n) == basicBlock) {
                    basicBlock4.irrsrc.remove(n);
                    continue;
                }
                ++n;
            }
        }
        this.bblist.remove(basicBlock);
    }

    public int reconnectEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2, BasicBlock<InsnType> basicBlock3) {
        int n = -1;
        for (int j = 0; j < basicBlock.dst.size(); ++j) {
            BasicBlock basicBlock4 = basicBlock.dst.get(j);
            if (basicBlock4 == basicBlock2) {
                if (n != -1) {
                    throw new RuntimeException();
                }
                n = j;
                continue;
            }
            if (basicBlock4 != basicBlock3) continue;
            return -1;
        }
        if (n < 0) {
            return 0;
        }
        basicBlock.dst.set(n, basicBlock3);
        basicBlock2.src.remove(basicBlock);
        basicBlock3.src.add(basicBlock);
        return 1;
    }

    public boolean deleteEdge(BasicBlock<InsnType> basicBlock, BasicBlock<InsnType> basicBlock2) {
        int n = -1;
        for (int j = 0; j < basicBlock.dst.size(); ++j) {
            BasicBlock basicBlock3 = basicBlock.dst.get(j);
            if (basicBlock3 != basicBlock2) continue;
            if (n != -1) {
                throw new RuntimeException("Duplicate edge found during deletion");
            }
            n = j;
        }
        if (n < 0) {
            return false;
        }
        basicBlock.dst.remove(n);
        basicBlock2.src.remove(basicBlock);
        return true;
    }

    public IVariableInformationProvider setVariableInformationProvider(IVariableInformationProvider iVariableInformationProvider) {
        IVariableInformationProvider iVariableInformationProvider2 = this.getVariableInformationProvider();
        this.varInfoProvider = iVariableInformationProvider;
        return iVariableInformationProvider2;
    }

    public IVariableInformationProvider getVariableInformationProvider() {
        return this.varInfoProvider == null ? null : this.varInfoProvider;
    }

    public void doDataFlowAnalysis() {
        this.doDataFlowAnalysis(false);
    }

    public void doDataFlowAnalysis(boolean bl2) {
        this.doDataFlowAnalysis(bl2, true);
    }

    private void doDataFlowAnalysis(boolean bl2, boolean bl3) {
        if (this.dfa_done && !bl2) {
            return;
        }
        this.resetDFA();
        this.storeRegistersUsage();
        this.calculateLiveRegisters();
        this.calculateDefUseChains();
        this.calculateReachingRegisters();
        this.calculateUseDefChains();
        if (bl3) {
            Map map = this.live_registers.get(this.getEntryBlock()).inlist;
            for (Integer n : map.keySet()) {
                for (ILocatedInstruction iLocatedInstruction : map.get(n)) {
                    this.dict_ud_chains.get(iLocatedInstruction).get(n).add(-1);
                    this.dict_full_ud_chains.get(iLocatedInstruction).get(n).add(null);
                }
            }
        }
        this.dfa_done = true;
    }

    public void resetDFA() {
        this.dfa_done = false;
        this.insn_def = null;
        this.insn_use = null;
        this.live_registers = null;
        this.reaching_registers = null;
        this.dict_du_chains = null;
        this.dict_ud_chains = null;
        this.dict_full_du_chains = null;
        this.dict_full_ud_chains = null;
    }

    public Map<InsnType, Map<Integer, List<Integer>>> getDefUseChains() {
        return this.dict_du_chains;
    }

    public Map<InsnType, Map<Integer, List<InsnType>>> getFullDefUseChains() {
        return this.dict_full_du_chains;
    }

    public Map<InsnType, Map<Integer, List<Integer>>> getUseDefChains() {
        return this.dict_ud_chains;
    }

    public Map<InsnType, Map<Integer, List<InsnType>>> getFullUseDefChains() {
        return this.dict_full_ud_chains;
    }

    private void storeRegistersUsage() {
        this.insn_def = new HashMap<InsnType, List<Integer>>();
        this.insn_use = new HashMap<InsnType, List<Integer>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                iLocatedInstruction.getDefUse(arrayList, arrayList2, null);
                this.insn_def.put(iLocatedInstruction, arrayList);
                this.insn_use.put(iLocatedInstruction, arrayList2);
            }
        }
    }

    private void calculateLiveRegisters() {
        Iterator<Tracker<InsnType>> iterator;
        Object object;
        this.live_registers = new HashMap<BasicBlock<InsnType>, Tracker<InsnType>>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        for (BasicBlock<InsnType> object2 : this.bblist) {
            object = new Tracker<InsnType>(this, object2, true, false);
            if (object2.alloutsize() == 0) {
                ((Tracker)object).initOutlist();
                arrayDeque.push(object);
            }
            this.live_registers.put(object2, (Tracker<InsnType>)object);
        }
        if (arrayDeque.isEmpty()) {
            iterator = this.live_registers.get(this.bblist.get(0));
            ((Tracker)((Object)iterator)).initOutlist();
            arrayDeque.push(iterator);
        }
        while (!arrayDeque.isEmpty()) {
            while (!arrayDeque.isEmpty()) {
                iterator = (Tracker)arrayDeque.pop();
                ((Tracker)((Object)iterator)).applyTransferFunctionLiveRegisters();
            }
            for (Tracker tracker : this.live_registers.values()) {
                object = new HashMap();
                for (BasicBlock basicBlock : tracker.bb.getAllOutputBlocks()) {
                    tracker.addToList(object, this.live_registers.get(basicBlock).inlist);
                }
                if (tracker.outlist != null && tracker.compareLists(object, tracker.outlist)) continue;
                tracker.outlist = object;
                arrayDeque.push(tracker);
            }
        }
        for (BasicBlock basicBlock : this.bblist) {
            object = this.live_registers.get(basicBlock);
            if (((Tracker)object).outlist != null) continue;
            ((Tracker)object).initOutlist();
        }
    }

    private void calculateDefUseChains() {
        this.dict_du_chains = new HashMap<InsnType, Map<Integer, List<Integer>>>();
        this.dict_full_du_chains = new HashMap<InsnType, Map<Integer, List<InsnType>>>();
        for (BasicBlock<InsnType> object2 : this.bblist) {
            for (int j = 0; j < object2.size(); ++j) {
                IInstruction iInstruction = object2.get(j);
                ArrayList arrayList = new ArrayList(this.insn_def.get(iInstruction));
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    hashMap.put(n, new ArrayList());
                    hashMap2.put(n, new ArrayList());
                }
                for (int i2 = j + 1; i2 < object2.size(); ++i2) {
                    IInstruction iInstruction2 = object2.get(i2);
                    for (int n : this.insn_use.get(iInstruction2)) {
                        if (!arrayList.contains(n)) continue;
                        ((List)hashMap.get(n)).add(i2);
                        ((List)hashMap2.get(n)).add(iInstruction2);
                    }
                    for (int n : this.insn_def.get(iInstruction2)) {
                        if (!arrayList.contains(n)) continue;
                        arrayList.remove((Object)n);
                    }
                }
                object = this.live_registers.get(object2);
                for (int n : ((Tracker)object).outlist.keySet()) {
                    if (!arrayList.contains(n)) continue;
                    ((List)hashMap.get(n)).add(-1);
                    ((List)hashMap2.get(n)).addAll(((Tracker)object).outlist.get(n));
                }
                this.dict_du_chains.put(iInstruction, hashMap);
                this.dict_full_du_chains.put(iInstruction, hashMap2);
            }
        }
        HashMap hashMap = new HashMap();
        Tracker<InsnType> tracker = this.live_registers.get(this.bblist.get(0));
        for (Integer n : tracker.inlist.keySet()) {
            hashMap.put(n, new ArrayList());
            ((List)hashMap.get(n)).addAll(tracker.inlist.get(n));
        }
        this.dict_full_du_chains.put(null, hashMap);
    }

    private void calculateReachingRegisters() {
        Object object;
        this.reaching_registers = new HashMap<BasicBlock<InsnType>, Tracker<InsnType>>();
        ArrayDeque arrayDeque = new ArrayDeque();
        int n = 0;
        for (BasicBlock<InsnType> object2 : this.bblist) {
            object = new Tracker<InsnType>(this, object2, false, true);
            if (n++ == 0) {
                ((Tracker)object).initInlist();
                arrayDeque.push(object);
            }
            this.reaching_registers.put(object2, (Tracker<InsnType>)object);
        }
        while (!arrayDeque.isEmpty()) {
            while (!arrayDeque.isEmpty()) {
                Iterator<Tracker<InsnType>> iterator = (Tracker)arrayDeque.pop();
                ((Tracker)((Object)iterator)).applyTransferFunctionReachingRegisters(this.varInfoProvider);
            }
            for (Tracker tracker : this.reaching_registers.values()) {
                object = new HashMap();
                for (BasicBlock basicBlock : tracker.bb.getAllInputBlocks()) {
                    tracker.addToList(object, this.reaching_registers.get(basicBlock).outlist);
                }
                if (tracker.inlist != null && tracker.compareLists(object, tracker.inlist)) continue;
                tracker.inlist = object;
                arrayDeque.push(tracker);
            }
        }
        for (BasicBlock basicBlock : this.bblist) {
            object = this.reaching_registers.get(basicBlock);
            if (((Tracker)object).inlist != null) continue;
            ((Tracker)object).initInlist();
        }
    }

    private void calculateUseDefChains() {
        this.dict_ud_chains = new HashMap<InsnType, Map<Integer, List<Integer>>>();
        this.dict_full_ud_chains = new HashMap<InsnType, Map<Integer, List<InsnType>>>();
        for (BasicBlock<InsnType> basicBlock : this.bblist) {
            for (int j = 0; j < basicBlock.insns.size(); ++j) {
                ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)basicBlock.insns.get(j);
                ArrayList arrayList = new ArrayList(this.insn_use.get(iLocatedInstruction));
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    hashMap.put(n, new ArrayList());
                    hashMap2.put(n, new ArrayList());
                }
                block3: for (int i2 = j - 1; i2 >= 0; --i2) {
                    ILocatedInstruction iLocatedInstruction2 = (ILocatedInstruction)basicBlock.insns.get(i2);
                    for (int n : this.insn_def.get(iLocatedInstruction2)) {
                        if (!arrayList.contains(n)) continue;
                        ((List)hashMap.get(n)).add(i2);
                        ((List)hashMap2.get(n)).add(iLocatedInstruction2);
                        arrayList.remove((Object)n);
                        if (!arrayList.isEmpty()) continue;
                        break block3;
                    }
                }
                object = this.reaching_registers.get(basicBlock);
                for (int n : ((Tracker)object).inlist.keySet()) {
                    if (!arrayList.contains(n)) continue;
                    ((List)hashMap.get(n)).add(-1);
                    ((List)hashMap2.get(n)).addAll(((Tracker)object).inlist.get(n));
                }
                this.dict_ud_chains.put(iLocatedInstruction, hashMap);
                this.dict_full_ud_chains.put(iLocatedInstruction, hashMap2);
            }
        }
    }

    public String format(boolean bl2, int n, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
            int n2 = 0;
            for (ILocatedInstruction iLocatedInstruction : basicBlock.insns) {
                if (bl2) {
                    char c = n2 >= 1 ? (char)':' : (basicBlock.irrinsize() == 0 ? (char)'+' : '*');
                    stringBuilder.append(String.format("%04X/%X%c  ", iLocatedInstruction.getOffset(), iLocatedInstruction.getSize(), Character.valueOf(c)));
                }
                stringBuilder.append(String.format("%-100s  ", iLocatedInstruction.format(object)));
                if (n == 1) {
                    String string = this.formatChains(iLocatedInstruction, ChainType.DU);
                    if (string.length() > 0) {
                        stringBuilder.append(string);
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(this.formatChains(iLocatedInstruction, ChainType.UD));
                    stringBuilder.append(" ");
                } else if (n == 2) {
                    String string = this.formatFullChains(iLocatedInstruction, ChainType.DU);
                    if (string.length() > 0) {
                        stringBuilder.append(string);
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(this.formatFullChains(iLocatedInstruction, ChainType.UD));
                    stringBuilder.append(" ");
                }
                stringBuilder.append('\n');
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    private String regname(int n) {
        if (this.varInfoProvider == null) {
            return "" + n;
        }
        return this.varInfoProvider.getName(n);
    }

    public String formatFullChains(InsnType InsnType, ChainType chainType) {
        Map<Integer, List<InsnType>> map = chainType == ChainType.DU ? this.dict_full_du_chains.get(InsnType) : this.dict_full_ud_chains.get(InsnType);
        TreeMap<Integer, List<InsnType>> treeMap = new TreeMap<Integer, List<InsnType>>(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : treeMap.keySet()) {
            stringBuilder.append(String.format("%s(%s)={%s} ", new Object[]{chainType, this.regname(n), this.formatInstructionOffsets(treeMap.get(n))}));
        }
        return stringBuilder.toString();
    }

    public String formatChains(InsnType InsnType, ChainType chainType) {
        Map<Integer, List<Integer>> map = chainType == ChainType.DU ? this.dict_du_chains.get(InsnType) : this.dict_ud_chains.get(InsnType);
        TreeMap<Integer, List<Integer>> treeMap = new TreeMap<Integer, List<Integer>>(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : treeMap.keySet()) {
            stringBuilder.append(String.format("%s(%s)={%s} ", chainType.toString().toLowerCase(), this.regname(n), IntegerList.format(treeMap.get(n))));
        }
        return stringBuilder.toString();
    }

    private String formatInstructionOffsets(List<InsnType> list) {
        ArrayList<InsnType> arrayList = new ArrayList<InsnType>(list);
        Collections.sort(arrayList, new Comparator<InsnType>(){

            @Override
            public int compare(InsnType InsnType, InsnType InsnType2) {
                long l2 = InsnType == null ? -1L : InsnType.getOffset();
                long l3 = InsnType2 == null ? -1L : InsnType2.getOffset();
                return Long.compare(l2, l3);
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (ILocatedInstruction iLocatedInstruction : arrayList) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            if (iLocatedInstruction == null) {
                stringBuilder.append("-1");
            } else {
                stringBuilder.append(String.format("%X", iLocatedInstruction.getOffset()));
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public String formatInstructions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
            for (ILocatedInstruction iLocatedInstruction : basicBlock.getInstructions()) {
                stringBuilder.append(this.formatInstruction(iLocatedInstruction));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public String formatInstructions(Collection<InsnType> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ILocatedInstruction iLocatedInstruction : collection) {
            stringBuilder.append(this.formatInstruction(iLocatedInstruction));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String formatInstruction(InsnType InsnType) {
        return String.format("%04X/%X:  %-60s %s%s", InsnType.getOffset(), InsnType.getSize(), InsnType, this.formatFullChains(InsnType, ChainType.DU), this.formatFullChains(InsnType, ChainType.UD));
    }

    public String formatBlockInstruction(InsnType InsnType) {
        return String.format("%04X/%X:  %-60s %s%s", InsnType.getOffset(), InsnType.getSize(), InsnType, this.formatChains(InsnType, ChainType.DU), this.formatChains(InsnType, ChainType.UD));
    }

    public String formatBlockInstructions(BasicBlock<InsnType> basicBlock) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ILocatedInstruction iLocatedInstruction : basicBlock.getInstructions()) {
            stringBuilder.append(this.formatBlockInstruction(iLocatedInstruction));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String formatInstructions2() {
        StringBuilder stringBuilder = new StringBuilder();
        for (BasicBlock<InsnType> basicBlock : this.getBlocks()) {
            Tracker<InsnType> tracker = this.reaching_registers.get(basicBlock);
            stringBuilder.append(String.format("<BLOCK> in: %s // out: %s\n", CFG.formatRegisterToInsnCollection(tracker.inlist), CFG.formatRegisterToInsnCollection(tracker.outlist)));
            for (ILocatedInstruction iLocatedInstruction : basicBlock.getInstructions()) {
                stringBuilder.append(this.formatInstruction(iLocatedInstruction));
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static <InsnType extends ILocatedInstruction> String formatRegisterToInsnCollection(Map<Integer, Set<InsnType>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : map.keySet()) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(String.format("%d:{", n2));
            int n3 = 0;
            for (ILocatedInstruction iLocatedInstruction : map.get(n2)) {
                if (n3 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.format("%Xh", iLocatedInstruction.getOffset()));
                ++n3;
            }
            stringBuilder.append('}');
            ++n;
        }
        return stringBuilder.toString();
    }

    public Map<Integer, Set<InsnType>> getReachMap(BasicBlock<InsnType> basicBlock) {
        return this.reaching_registers.get(basicBlock).inlist;
    }

    public Map<Integer, Set<InsnType>> getReachMap(InsnType InsnType) {
        ILocatedInstruction iLocatedInstruction;
        BasicBlock<InsnType> basicBlock = this.getBlockFor(InsnType);
        if (basicBlock == null) {
            return null;
        }
        Tracker tracker = this.reaching_registers.get(basicBlock);
        Map<Integer, Set<InsnType>> map = tracker.copyList(tracker.inlist);
        Iterator iterator = basicBlock.insns.iterator();
        while (iterator.hasNext() && (iLocatedInstruction = (ILocatedInstruction)iterator.next()) != InsnType) {
            List<Integer> list = this.insn_def.get(iLocatedInstruction);
            for (int n : list) {
                Set<InsnType> set = map.get(n);
                if (set == null) {
                    set = new HashSet<InsnType>();
                    map.put(n, set);
                } else {
                    set.clear();
                }
                set.add(iLocatedInstruction);
            }
        }
        return map;
    }

    public Map<Integer, Set<InsnType>> getInputMap() {
        if (!this.dfa_done) {
            throw new IllegalStateException();
        }
        BasicBlock<InsnType> basicBlock = this.getEntryBlock();
        return this.live_registers.get(basicBlock).inlist;
    }

    public Map<Integer, Set<InsnType>> getOuputMap() {
        if (!this.dfa_done) {
            throw new IllegalStateException();
        }
        HashMap<Integer, Set<InsnType>> hashMap = new HashMap<Integer, Set<InsnType>>();
        for (BasicBlock<InsnType> basicBlock : this.getExitBlocks()) {
            Map map = this.reaching_registers.get(basicBlock).outlist;
            for (Integer n : map.keySet()) {
                HashSet hashSet = (HashSet)hashMap.get(n);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(n, hashSet);
                }
                hashSet.addAll(map.get(n));
            }
        }
        return hashMap;
    }
}

