/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.List;

@Ser
public class BasicBlock<InsnType extends ILocatedInstruction>
implements IBasicBlock<InsnType> {
    private static final ILogger logger = GlobalLog.getLogger(BasicBlock.class);
    @SerId(value=1)
    List<InsnType> insns = new ArrayList<InsnType>();
    @SerTransient
    List<Long> dst_offsets = new ArrayList<Long>();
    @SerTransient
    List<Long> irrdst_offsets = new ArrayList<Long>();
    @SerId(value=4)
    List<BasicBlock<InsnType>> src = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=5)
    List<BasicBlock<InsnType>> dst = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=6)
    List<BasicBlock<InsnType>> irrsrc = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=7)
    List<BasicBlock<InsnType>> irrdst = new ArrayList<BasicBlock<InsnType>>();

    @Override
    public int size() {
        return this.insns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.insns.isEmpty();
    }

    @Override
    public InsnType get(int n) {
        return (InsnType)((ILocatedInstruction)this.insns.get(n));
    }

    @Override
    public InsnType getLast() {
        return (InsnType)((ILocatedInstruction)this.insns.get(this.insns.size() - 1));
    }

    @Override
    public InsnType getInstruction(int n) {
        return (InsnType)((ILocatedInstruction)this.insns.get(n));
    }

    @Override
    public List<InsnType> getInstructions() {
        return new ArrayList<InsnType>(this.insns);
    }

    @Override
    public long getFirstAddress() {
        return ((ILocatedInstruction)this.insns.get(0)).getOffset();
    }

    @Override
    public long getLastAddress() {
        return ((ILocatedInstruction)this.insns.get(this.insns.size() - 1)).getOffset();
    }

    @Override
    public long getEndAddress() {
        ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)this.insns.get(this.insns.size() - 1);
        return iLocatedInstruction.getOffset() + (long)iLocatedInstruction.getSize();
    }

    @Override
    public long getAddressOfInstruction(int n) {
        if (n < 0 || n >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l2 = this.getFirstAddress();
        for (int j = 0; j < n; ++j) {
            l2 += (long)((ILocatedInstruction)this.insns.get(j)).getSize();
        }
        return l2;
    }

    @Override
    public int getIndexOfInstruction(long l2) {
        long l3 = this.getFirstAddress();
        for (int j = 0; j < this.insns.size(); ++j) {
            if (l3 == l2) {
                return j;
            }
            l3 += (long)((ILocatedInstruction)this.insns.get(j)).getSize();
        }
        throw new RuntimeException();
    }

    @Override
    public boolean canThrow() {
        for (ILocatedInstruction iLocatedInstruction : this.insns) {
            if (!iLocatedInstruction.canThrow()) continue;
            return true;
        }
        return false;
    }

    public boolean remove(int n) {
        this.insns.remove(n);
        if (!this.insns.isEmpty()) {
            return false;
        }
        if (this.outsize() != 1) {
            logger.i("Removed last block instruction, outdegree must be 1", new Object[0]);
            throw new RuntimeException();
        }
        return true;
    }

    public void add(InsnType InsnType) {
        this.insns.add(InsnType);
    }

    @Override
    public int insize() {
        return this.src.size();
    }

    @Override
    public int irrinsize() {
        return this.irrsrc.size();
    }

    @Override
    public int allinsize() {
        return this.src.size() + this.irrsrc.size();
    }

    @Override
    public BasicBlock<InsnType> getInputBlock(int n) {
        return this.src.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.src);
    }

    @Override
    public BasicBlock<InsnType> getIrregularInputBlock(int n) {
        return this.irrsrc.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrsrc);
    }

    @Override
    public List<BasicBlock<InsnType>> getAllInputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.src);
        arrayList.addAll(this.irrsrc);
        return arrayList;
    }

    @Override
    public int outsize() {
        return this.dst.size();
    }

    @Override
    public int irroutsize() {
        return this.irrdst.size();
    }

    @Override
    public int alloutsize() {
        return this.dst.size() + this.irrdst.size();
    }

    @Override
    public BasicBlock<InsnType> getOutputBlock(int n) {
        return this.dst.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.dst);
    }

    @Override
    public BasicBlock<InsnType> getIrregularOutputBlock(int n) {
        return this.irrdst.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrdst);
    }

    @Override
    public List<BasicBlock<InsnType>> getAllOutputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.dst);
        arrayList.addAll(this.irrdst);
        return arrayList;
    }

    public boolean isSelfReferencing() {
        if (this.dst.size() > 0 && this.src.size() > 0) {
            for (BasicBlock<InsnType> basicBlock : this.dst) {
                if (!this.src.contains(basicBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInfiniteLoop() {
        return this.dst.size() == 1 && this.isSelfReferencing();
    }

    public String toString() {
        if (this.insns.size() == 0) {
            return "(Empty block)";
        }
        long l2 = ((ILocatedInstruction)this.insns.get(0)).getOffset();
        long l3 = ((ILocatedInstruction)this.insns.get(this.insns.size() - 1)).getOffset();
        return String.format("(%X-%X,%d)", l2, l3, this.insns.size());
    }
}

