/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.PointerDescription;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeModel;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class EntryPointDescription
extends PointerDescription
implements IEntryPointDescription {
    @SerId(value=1)
    int processorMode;

    public EntryPointDescription(long l2, int n) {
        super(l2, 0, 1);
        this.processorMode = n;
    }

    public EntryPointDescription(long l2) {
        this(l2, 0);
    }

    public EntryPointDescription(IEntryPointDescription iEntryPointDescription) {
        this(iEntryPointDescription.getAddress(), iEntryPointDescription.getMode());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.processorMode;
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EntryPointDescription entryPointDescription = (EntryPointDescription)object;
        return this.processorMode == entryPointDescription.processorMode;
    }

    public boolean almostEquals(Object object) {
        return super.equals(object);
    }

    @Override
    public int getMode() {
        return this.processorMode;
    }

    public void setMode(int n) {
        this.processorMode = n;
    }

    @Override
    public boolean isUnknownAddress() {
        return this.address == -1L;
    }

    @Override
    public String toString() {
        return String.format("EP{address=%Xh,mode=%d}", this.address, this.processorMode);
    }

    public static EntryPointDescription createFrom(long l2, INativeCodeModel<?> iNativeCodeModel) {
        INativeContinuousItem iNativeContinuousItem = iNativeCodeModel.getItemAt(l2);
        if (!(iNativeContinuousItem instanceof INativeInstructionItem)) {
            throw new IllegalArgumentException("invalid address -- no instruction here");
        }
        return new EntryPointDescription(l2, ((INativeInstructionItem)iNativeContinuousItem).getInstruction().getProcessorMode());
    }

    public static EntryPointDescription createFrom(ILocatedInstruction iLocatedInstruction) {
        return new EntryPointDescription(iLocatedInstruction.getOffset(), iLocatedInstruction.getProcessorMode());
    }

    public static EntryPointDescription createFrom(INativeMethodDataItem iNativeMethodDataItem) {
        long l2;
        CFG<?> cFG = iNativeMethodDataItem.getCFG();
        Object obj = cFG.getInstruction(l2 = cFG.getEntryAddress());
        if (obj == null) {
            throw new RuntimeException(Strings.f("Can not found entry instruction @%s", iNativeMethodDataItem.getAddress()));
        }
        return new EntryPointDescription(l2, obj.getProcessorMode());
    }

    public static EntryPointDescription createFrom(INativeMethodItem iNativeMethodItem) {
        INativeMethodDataItem iNativeMethodDataItem = iNativeMethodItem.getData();
        if (iNativeMethodDataItem == null) {
            throw new IllegalArgumentException();
        }
        return EntryPointDescription.createFrom(iNativeMethodDataItem);
    }

    public static EntryPointDescription createUnknown() {
        return EntryPointDescription.createUnknown(0);
    }

    public static EntryPointDescription createUnknown(int n) {
        return new EntryPointDescription(-1L, n);
    }
}

