/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IControlFlowGraph;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class CFGUtil {
    private static final ILogger logger = GlobalLog.getLogger(CFGUtil.class);

    public static void toTempDot(IControlFlowGraph<?> iControlFlowGraph, String string) {
        CFGUtil.toTempDot(iControlFlowGraph, string, null, null);
    }

    public static void toTempDot(IControlFlowGraph<?> iControlFlowGraph, String string, String string2, Map<Long, String> map) {
        try {
            if (!string.endsWith(".dot")) {
                string = string + ".dot";
            }
            CFGUtil.toDot(iControlFlowGraph, IO.createTempFile(string), string2, map);
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
        }
    }

    public static void toDot(IControlFlowGraph<?> iControlFlowGraph, File file, String string, Map<Long, String> map) throws IOException {
        String string2 = CFGUtil.generateDot(iControlFlowGraph, string, map);
        IO.writeFile(file, Strings.encodeUTF8(string2));
    }

    public static void toDot(IControlFlowGraph<?> iControlFlowGraph, File file) throws IOException {
        CFGUtil.toDot(iControlFlowGraph, file, null, null);
    }

    private static String generateDot(IControlFlowGraph<? extends IInstruction> iControlFlowGraph, String string, Map<Long, String> map) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph G {\n");
        if (string != null) {
            stringBuilder.append("labelloc=\"t\"\n");
            stringBuilder.append("labelfontname=\"Consolas\"\n");
            stringBuilder.append(String.format("label=\"%s\"\n", CFGUtil.dotEscape(string)));
        }
        long l2 = 0L;
        int n = 40;
        int n2 = 1;
        for (IBasicBlock<? extends IInstruction> iBasicBlock : iControlFlowGraph.getBlocks()) {
            String string2 = "(" + n2 + ")";
            if (map != null && (object = map.get(iBasicBlock.getFirstAddress())) != null) {
                string2 = string2 + " " + object;
            }
            object = string2 + "\\l";
            int n3 = 0;
            for (IInstruction iInstruction : iBasicBlock.getInstructions()) {
                char c = n3 >= 1 ? (char)':' : (iBasicBlock.getFirstAddress() == 0L ? (char)'>' : (iBasicBlock.irrinsize() == 0 ? (char)'+' : '*'));
                object = ((String)object).concat(String.format("%04X/%X%c  ", iBasicBlock.getAddressOfInstruction(n3), iInstruction.getSize(), Character.valueOf(c)));
                String string3 = iInstruction.toString();
                string3 = string3.length() < 40 ? string3 : string3.substring(0, 40) + "...";
                object = ((String)object).concat(string3);
                object = ((String)object).concat("\\l");
                ++n3;
            }
            stringBuilder.append(String.format("BB_%08x [shape=Mrecord,fontname=\"Consolas\",style=\"filled\",label=\"%s\"];\n", iBasicBlock.getFirstAddress(), CFGUtil.dotEscape(object)));
            ++n2;
        }
        for (IBasicBlock<? extends IInstruction> iBasicBlock : iControlFlowGraph.getBlocks()) {
            if (iBasicBlock.outsize() == 2) {
                IBasicBlock<? extends IInstruction> iBasicBlock2 = iBasicBlock.getOutputBlock(0);
                stringBuilder.append(String.format("BB_%08x -> BB_%08x [color=\"red\"];\n", iBasicBlock.getFirstAddress(), iBasicBlock2.getFirstAddress()));
                iBasicBlock2 = iBasicBlock.getOutputBlock(1);
                stringBuilder.append(String.format("BB_%08x -> BB_%08x [color=\"green\"];\n", iBasicBlock.getFirstAddress(), iBasicBlock2.getFirstAddress()));
            } else {
                for (int j = 0; j < iBasicBlock.outsize(); ++j) {
                    object = iBasicBlock.getOutputBlock(j);
                    stringBuilder.append(String.format("BB_%08x -> BB_%08x;\n", iBasicBlock.getFirstAddress(), object.getFirstAddress()));
                }
            }
            for (int j = 0; j < iBasicBlock.irroutsize(); ++j) {
                object = iBasicBlock.getIrregularOutputBlock(j);
                stringBuilder.append(String.format("BB_%08x -> BB_%08x [style=dotted];\n", iBasicBlock.getFirstAddress(), object.getFirstAddress()));
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String dotEscape(String string) {
        string = string.replace("|", "\\|");
        string = string.replace("<", "\\<");
        string = string.replace(">", "\\>");
        string = string.replace("{", "\\{");
        string = string.replace("}", "\\}");
        string = string.replace("\"", "\\\"");
        return string;
    }
}

