/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.AbstractPlugin;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;

public abstract class AbstractUnitIdentifier
extends AbstractPlugin
implements IUnitIdentifier {
    protected String type;
    protected double priority;
    protected IPropertyDefinitionManager pdm;
    protected IPropertyManager pm;

    public AbstractUnitIdentifier(String string, double d2) {
        if (string == null) {
            throw new IllegalArgumentException("A unit identifier must have a valid type");
        }
        this.type = string;
        this.priority = d2;
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.pdm = new PropertyDefinitionManager(this.type, iPropertyDefinitionManager);
    }

    @Override
    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    @Override
    public String getFormatType() {
        return this.type;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public ITypeIdProvider getTypeIdProvider() {
        return null;
    }

    public static boolean checkBytes(byte[] byArray, int n, byte ... byArray2) {
        if (byArray == null || n + byArray2.length > byArray.length) {
            return false;
        }
        for (byte by2 : byArray2) {
            if (byArray[n] != by2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean checkBytes(byte[] byArray, int n, int ... nArray) {
        return AbstractUnitIdentifier.checkBytes(byArray, n, ArrayUtil.integersToBytes(nArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkBytes(IInput iInput, int n, byte ... byArray) {
        if (iInput == null) return false;
        if (iInput.getHeader() == null) {
            return false;
        }
        if (AbstractUnitIdentifier.checkBytes(iInput.getHeader(), n, byArray)) {
            return true;
        }
        if (n + byArray.length <= iInput.getHeader().limit()) {
            return false;
        }
        try (SeekableByteChannel seekableByteChannel = iInput.getChannel();){
            boolean bl2 = AbstractUnitIdentifier.checkBytes(seekableByteChannel, n, byArray);
            return bl2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean checkBytes(IInput iInput, int n, int ... nArray) {
        return AbstractUnitIdentifier.checkBytes(iInput, n, ArrayUtil.integersToBytes(nArray));
    }

    public static boolean checkBytes(IInput iInput, int n, String string) {
        return AbstractUnitIdentifier.checkBytes(iInput, n, Strings.encodeUTF8(string));
    }

    public static int readHeaderByte(IInput iInput, int n) {
        if (iInput == null || iInput.getHeader() == null) {
            return -1;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer == null || n >= byteBuffer.limit()) {
            return -1;
        }
        return byteBuffer.get(n);
    }

    private static boolean checkBytes(ByteBuffer byteBuffer, int n, byte ... byArray) {
        if (byteBuffer == null || n + byArray.length > byteBuffer.limit()) {
            return false;
        }
        for (byte by2 : byArray) {
            if (byteBuffer.get(n) != by2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean checkBytes(SeekableByteChannel seekableByteChannel, int n, byte ... byArray) throws IOException {
        if (seekableByteChannel == null) {
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        seekableByteChannel.position(n);
        seekableByteChannel.read(byteBuffer);
        byteBuffer.position(0);
        for (byte by2 : byArray) {
            if (byteBuffer.get() == by2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return false;
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        return this.canIdentify(iInput, iUnitCreator, null, null);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        return this.prepare(string, iInput, iUnitProcessor, iUnitCreator, null);
    }

    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        return this.canIdentify(iInput, iUnitCreator);
    }

    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        return this.prepare(string, iInput, iUnitProcessor, iUnitCreator);
    }
}

