/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PropertyUtil {
    public static IPropertyDefinitionManager getRoot(IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyDefinitionManager iPropertyDefinitionManager2;
        while ((iPropertyDefinitionManager2 = iPropertyDefinitionManager.getParent()) != null) {
            iPropertyDefinitionManager = iPropertyDefinitionManager2;
        }
        return iPropertyDefinitionManager;
    }

    public static IPropertyDefinitionManager getNamespace(IPropertyDefinitionManager iPropertyDefinitionManager, String string) {
        if (string.startsWith(".")) {
            iPropertyDefinitionManager = PropertyUtil.getRoot(iPropertyDefinitionManager);
            string = string.substring(1);
        }
        for (String string2 : string.split("\\.")) {
            if ((iPropertyDefinitionManager = iPropertyDefinitionManager.getChild(string2)) != null) continue;
            return null;
        }
        return iPropertyDefinitionManager;
    }

    public static IPropertyDefinition getDefinition(IPropertyDefinitionManager iPropertyDefinitionManager, String string) {
        if (!string.startsWith(".")) {
            throw new IllegalArgumentException("Illegal fully-qualified name for perperty: " + string);
        }
        iPropertyDefinitionManager = PropertyUtil.getRoot(iPropertyDefinitionManager);
        String[] stringArray = Strings.splitall(string.substring(1), "\\.");
        for (int j = 0; j < stringArray.length - 1 && (iPropertyDefinitionManager = iPropertyDefinitionManager.getChild(stringArray[j])) != null; ++j) {
        }
        if (iPropertyDefinitionManager == null) {
            return null;
        }
        String string2 = stringArray[stringArray.length - 1];
        return iPropertyDefinitionManager.getDefinition(string2);
    }

    public static String formatList(IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl2) {
        TextBuilder textBuilder = new TextBuilder(2);
        ArrayList<IPropertyDefinitionManager> arrayList = new ArrayList<IPropertyDefinitionManager>();
        arrayList.add(iPropertyDefinitionManager);
        while (!arrayList.isEmpty()) {
            iPropertyDefinitionManager = (IPropertyDefinitionManager)arrayList.remove(0);
            ArrayList<IPropertyDefinition> arrayList2 = new ArrayList<IPropertyDefinition>(iPropertyDefinitionManager.getDefinitions());
            if (bl2) {
                Collections.sort(arrayList2, new Comparator<IPropertyDefinition>(){

                    @Override
                    public int compare(IPropertyDefinition iPropertyDefinition, IPropertyDefinition iPropertyDefinition2) {
                        return iPropertyDefinition.getName().compareToIgnoreCase(iPropertyDefinition2.getName());
                    }
                });
            }
            for (IPropertyDefinition iPropertyDefinition : arrayList2) {
                String string = iPropertyDefinitionManager.getNamespace() + "." + iPropertyDefinition.getName();
                textBuilder.append(String.format("%s: %s\n", string, iPropertyDefinition.getType()));
            }
            arrayList.addAll(iPropertyDefinitionManager.getChildren());
        }
        return textBuilder.toString();
    }

    public static String formatTree(IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl2) {
        TextBuilder textBuilder = new TextBuilder(2);
        PropertyUtil.formatTreeRecurse(textBuilder, iPropertyDefinitionManager, bl2);
        return textBuilder.toString();
    }

    private static void formatTreeRecurse(TextBuilder textBuilder, IPropertyDefinitionManager iPropertyDefinitionManager, boolean bl2) {
        String string = iPropertyDefinitionManager.getRegion();
        if (iPropertyDefinitionManager.isRoot()) {
            string = "<root>";
        }
        textBuilder.appendLine(string, new Object[0]);
        textBuilder.indent();
        ArrayList<IPropertyDefinition> arrayList = new ArrayList<IPropertyDefinition>(iPropertyDefinitionManager.getDefinitions());
        if (bl2) {
            Collections.sort(arrayList, new Comparator<IPropertyDefinition>(){

                @Override
                public int compare(IPropertyDefinition iPropertyDefinition, IPropertyDefinition iPropertyDefinition2) {
                    return iPropertyDefinition.getName().compareToIgnoreCase(iPropertyDefinition2.getName());
                }
            });
        }
        for (IPropertyDefinition object : arrayList) {
            textBuilder.append(String.format("%s: %s\n", object.getName(), object.getType()));
        }
        for (IPropertyDefinitionManager iPropertyDefinitionManager2 : iPropertyDefinitionManager.getChildren()) {
            PropertyUtil.formatTreeRecurse(textBuilder, iPropertyDefinitionManager2, bl2);
        }
        textBuilder.unindent();
    }
}

