/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.properties.IPropertyTypeInteger;
import java.util.Map;
import java.util.WeakHashMap;

public final class PropertyTypeInteger
implements IPropertyTypeInteger {
    private static Map<PropertyTypeInteger, PropertyTypeInteger> map = new WeakHashMap<PropertyTypeInteger, PropertyTypeInteger>();
    private int min;
    private int max;
    private Integer def;

    public static PropertyTypeInteger create(int n, int n2, Integer n3) {
        if (n3 == null) {
            throw new RuntimeException("Default value cannot be null");
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException("Default value is out of range");
        }
        PropertyTypeInteger propertyTypeInteger = new PropertyTypeInteger(n, n2, n3);
        PropertyTypeInteger propertyTypeInteger2 = map.get(propertyTypeInteger);
        if (propertyTypeInteger2 == null) {
            propertyTypeInteger2 = propertyTypeInteger;
            map.put(propertyTypeInteger2, propertyTypeInteger);
        }
        return propertyTypeInteger2;
    }

    public static PropertyTypeInteger create() {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    }

    public static PropertyTypeInteger create(Integer n) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, Integer.MAX_VALUE, n);
    }

    public static PropertyTypeInteger createPositive(Integer n) {
        return PropertyTypeInteger.create(1, Integer.MAX_VALUE, n);
    }

    public static PropertyTypeInteger createPositiveOrZero(Integer n) {
        return PropertyTypeInteger.create(0, Integer.MAX_VALUE, n);
    }

    public static PropertyTypeInteger createNegative(Integer n) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, -1, n);
    }

    public static PropertyTypeInteger createNegativeOrZero(Integer n) {
        return PropertyTypeInteger.create(Integer.MIN_VALUE, 0, n);
    }

    private PropertyTypeInteger(int n, int n2, Integer n3) {
        this.min = n;
        this.max = n2;
        this.def = n3;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public Integer getDefault() {
        return this.def;
    }

    @Override
    public boolean validate(Object object) {
        try {
            int n = Integer.parseInt(object.toString());
            return n >= this.min && n <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.def == null ? 0 : this.def.hashCode());
        n2 = 31 * n2 + this.max;
        n2 = 31 * n2 + this.min;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyTypeInteger propertyTypeInteger = (PropertyTypeInteger)object;
        if (this.def == null ? propertyTypeInteger.def != null : !this.def.equals(propertyTypeInteger.def)) {
            return false;
        }
        if (this.max != propertyTypeInteger.max) {
            return false;
        }
        return this.min == propertyTypeInteger.min;
    }

    public String toString() {
        String string = this.getName() + "(" + this.getDefault() + ")";
        if (this.min != Integer.MIN_VALUE && this.max != Integer.MAX_VALUE) {
            string = string + String.format("{%d-%d}", this.min, this.max);
        } else if (this.min != Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            string = string + String.format("{%d+}", this.min);
        } else if (this.min == Integer.MIN_VALUE && this.max != Integer.MAX_VALUE) {
            string = string + String.format("{%d-}", this.max);
        }
        return string;
    }
}

