/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.properties.impl;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.properties.IConfiguration;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.core.properties.impl.PropertyUtil;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.concurrent.atomic.AtomicInteger;

@SerDisabled
public class PropertyManager
extends EventSource
implements IPropertyManager {
    private static final ILogger logger = GlobalLog.getLogger(PropertyManager.class);
    IPropertyDefinitionManager pdm;
    IConfiguration config;
    IPropertyManager master;
    IEventListener listener;
    private static AtomicInteger gid = new AtomicInteger();
    private int id = gid.getAndIncrement();
    private String ownerName = "PM";

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IConfiguration iConfiguration, IPropertyManager iPropertyManager) {
        this.pdm = iPropertyDefinitionManager;
        this.config = iConfiguration;
        this.master = iPropertyManager;
        if (iPropertyManager != null) {
            this.listener = EventSource.relay(iPropertyManager, this);
        }
    }

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IConfiguration iConfiguration) {
        this(iPropertyDefinitionManager, iConfiguration, null);
    }

    public PropertyManager(IPropertyDefinitionManager iPropertyDefinitionManager, IPropertyManager iPropertyManager) {
        this(iPropertyDefinitionManager, null, iPropertyManager);
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            this.master.removeListener(this.listener);
        }
    }

    @Override
    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    @Override
    public IConfiguration getConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        return this.master.getConfiguration();
    }

    @Override
    public Object getValue(String string) {
        return this.getValue(string, 3, true);
    }

    @Override
    public Object getValue(String string, int n, boolean bl2) {
        IPropertyDefinition iPropertyDefinition;
        String string2 = this.genFqn(string);
        if (string2 == null) {
            return null;
        }
        Object object = null;
        if (this.config != null) {
            object = this.config.getProperty(string2);
        }
        if (object == null && this.master != null && n >= 1) {
            object = this.master.getValue(string2, 1, bl2);
        }
        IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition = this.pdm == null ? null : PropertyUtil.getDefinition(this.pdm, string2);
        if (iPropertyDefinition != null) {
            if (object != null || n < 2 || (iPropertyDefinition.getFlags() & 1) != 0) {
                // empty if block
            }
            if (object == null && n >= 3) {
                object = iPropertyDefinition.getType().getDefault();
            }
            if (object != null && bl2 && !iPropertyDefinition.getType().validate(object)) {
                return null;
            }
        }
        return object;
    }

    @Override
    public boolean setValue(String string, Object object) {
        return this.setValue(string, object, true, null);
    }

    @Override
    public boolean setValue(String string, Object object, boolean bl2, PropertyChangeObject propertyChangeObject) {
        String string2 = this.genFqn(string);
        if (string2 == null) {
            return false;
        }
        if (this.config != null) {
            IPropertyDefinition iPropertyDefinition;
            IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition = this.pdm == null ? null : PropertyUtil.getDefinition(this.pdm, string2);
            if (object == null) {
                if (propertyChangeObject == null) {
                    this.config.clearProperty(string2);
                    this.notifyListeners(new JebEvent(J.PropertyChange, new PropertyChangeNotification(string2, null, iPropertyDefinition)));
                } else {
                    propertyChangeObject.add(this, string2, null, iPropertyDefinition);
                }
                return true;
            }
            if (iPropertyDefinition != null && bl2 && !iPropertyDefinition.getType().validate(object)) {
                logger.i("Invalid property: %s", iPropertyDefinition);
                return false;
            }
            if (propertyChangeObject == null) {
                this.config.setProperty(string2, object.toString());
                this.notifyListeners(new JebEvent(J.PropertyChange, new PropertyChangeNotification(string2, object, iPropertyDefinition)));
                if (this.config instanceof CommonsConfigurationWrapper) {
                    this.config.setProperty("", "");
                }
            } else {
                propertyChangeObject.add(this, string2, object, iPropertyDefinition);
            }
            return true;
        }
        if (this.master != null) {
            return this.master.setValue(string2, object, bl2, propertyChangeObject);
        }
        return false;
    }

    private String genFqn(String string) {
        if (string.startsWith(".")) {
            return string;
        }
        if (this.pdm == null) {
            return null;
        }
        return this.pdm.getNamespace() + "." + string;
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    @Override
    public boolean getBoolean(String string, boolean bl2) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The boolean property \"%s\" does not exist!", string);
            return bl2;
        }
        return Boolean.parseBoolean(object.toString());
    }

    @Override
    public Boolean getBooleanUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The boolean property \"%s\" does not exist!", string);
            return null;
        }
        return Boolean.parseBoolean(object.toString());
    }

    @Override
    public boolean setBoolean(String string, Boolean bl2) {
        return this.setBoolean(string, bl2, null);
    }

    @Override
    public boolean setBoolean(String string, Boolean bl2, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, bl2, true, propertyChangeObject);
    }

    @Override
    public int getInteger(String string) {
        return this.getInteger(string, 0);
    }

    @Override
    public int getInteger(String string, int n) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The integer property \"%s\" does not exist!", string);
            return n;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    @Override
    public Integer getIntegerUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The integer property \"%s\" does not exist!", string);
            return null;
        }
        return Integer.parseInt(object.toString());
    }

    @Override
    public boolean setInteger(String string, Integer n) {
        return this.setInteger(string, n, null);
    }

    @Override
    public boolean setInteger(String string, Integer n, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, n, true, propertyChangeObject);
    }

    @Override
    public String getString(String string) {
        return this.getString(string, "");
    }

    @Override
    public String getString(String string, String string2) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The string property \"%s\" does not exist!", string);
            return string2;
        }
        return object.toString();
    }

    @Override
    public String getStringUnsafe(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            logger.i("The string property \"%s\" does not exist!", string);
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setString(String string, String string2) {
        return this.setValue(string, string2, true, null);
    }

    @Override
    public boolean setString(String string, String string2, PropertyChangeObject propertyChangeObject) {
        return this.setValue(string, string2, true, propertyChangeObject);
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String toString() {
        String string = "PM_" + this.id;
        if (this.master != null) {
            IPropertyManager iPropertyManager = this.master;
            while (iPropertyManager instanceof PropertyManager) {
                string = string + ">" + ((PropertyManager)iPropertyManager).id;
                iPropertyManager = ((PropertyManager)iPropertyManager).master;
            }
        }
        if (this.pdm != null) {
            string = string + "|PDM:" + this.pdm.getRegion();
        }
        if (this.ownerName != null) {
            string = string + "|" + this.ownerName;
        }
        return string;
    }
}

