/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.exceptions.NotImplementedException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.events.IEventSource;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.List;

@SerDisabled
public abstract class AbstractTextPartAsDocumentProxy
implements ITextDocument {
    private ITextDocument idoc;
    private ITextDocumentPart part;

    public AbstractTextPartAsDocumentProxy(ITextDocument iTextDocument) {
        this.idoc = iTextDocument;
    }

    public ITextDocument getFullDocument() {
        return this.idoc;
    }

    protected abstract ITextDocumentPart getPartAsDocument();

    @Override
    public void dispose() {
        this.idoc.dispose();
    }

    @Override
    public IPropertyManager getPropertyManager() {
        return this.idoc.getPropertyManager();
    }

    @Override
    public long getInitialAnchor() {
        if (this.part == null) {
            this.part = this.getPartAsDocument();
        }
        return this.part.getAnchors().get(0).getIdentifier();
    }

    @Override
    public long getFirstAnchor() {
        return this.getInitialAnchor();
    }

    @Override
    public long getAnchorCount() {
        if (this.part == null) {
            this.part = this.getPartAsDocument();
        }
        List<? extends IAnchor> list = this.part.getAnchors();
        return list.get(list.size() - 1).getIdentifier() - list.get(0).getIdentifier() + 1L;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n) {
        this.part = this.getPartAsDocument();
        return this.part;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n, int n2) {
        return this.getPartAsDocument();
    }

    @Override
    public ITextDocumentPart getDocumentPart2(long l2, long l3) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates) {
        return this.idoc.coordinatesToAddress(iCoordinates, AddressConversionPrecision.DEFAULT);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        return this.idoc.coordinatesToAddress(iCoordinates, addressConversionPrecision);
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        return this.addressToCoordinates(string, null);
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        ICoordinates iCoordinates = this.idoc.addressToCoordinates(string, coordinatesConversionPrecision);
        if (iCoordinates != null) {
            long l2 = iCoordinates.getAnchorId();
            if (this.part == null) {
                this.part = this.getPartAsDocument();
            }
            long l3 = TextPartUtil.getFirstAnchorId(this.part);
            long l4 = TextPartUtil.getLastAnchorId(this.part);
            if (l2 < l3 || l2 > l4) {
                iCoordinates = null;
            }
        }
        return iCoordinates;
    }

    @Override
    public String format() {
        return TextDocumentUtil.getText(this);
    }

    @Override
    public void setParentSource(IEventSource iEventSource) {
        this.idoc.setParentSource(iEventSource);
    }

    @Override
    public IEventSource getParentSource() {
        return this.idoc.getParentSource();
    }

    @Override
    public int countListeners() {
        return this.idoc.countListeners();
    }

    @Override
    public List<? extends IEventListener> getListeners() {
        return this.idoc.getListeners();
    }

    @Override
    public void addListener(IEventListener iEventListener) {
        this.idoc.addListener(iEventListener);
    }

    @Override
    public void insertListener(int n, IEventListener iEventListener) {
        this.idoc.insertListener(n, iEventListener);
    }

    @Override
    public void removeListener(IEventListener iEventListener) {
        this.idoc.removeListener(iEventListener);
    }

    @Override
    public void notifyListeners(IEvent iEvent) {
        this.idoc.notifyListeners(iEvent);
    }
}

