/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code;

import com.pnfsoftware.jeb.core.output.code.AssemblyItem;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.impl.TextMark;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@SerDisabled
public class CodeLine
implements ILine {
    private StringBuilder text = new StringBuilder();
    private List<AssemblyItem> items = Collections.emptyList();
    private List<TextMark> marks = Collections.emptyList();
    private ICodeCoordinates lineCoordinates = null;
    private TreeMap<Integer, ICodeCoordinates> coordinates = new TreeMap();

    @Override
    public CharSequence getText() {
        return this.text;
    }

    public List<AssemblyItem> getItems() {
        return this.items;
    }

    public List<TextMark> getMarks() {
        return this.marks;
    }

    public void setCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.coordinates.put(this.text.length(), iCodeCoordinates);
    }

    public Map<Integer, ICodeCoordinates> getCoordinates() {
        return this.coordinates;
    }

    public ICodeCoordinates getCoordinates(int n) {
        int n2;
        int n3 = -1;
        Iterator<Integer> iterator = this.coordinates.keySet().iterator();
        while (iterator.hasNext() && n >= (n2 = iterator.next().intValue())) {
            n3 = n2;
        }
        if (n3 < 0) {
            return this.lineCoordinates;
        }
        return this.coordinates.get(n3);
    }

    public void setLineCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.lineCoordinates = iCodeCoordinates;
    }

    public ICodeCoordinates getLineCoordinates() {
        return this.lineCoordinates;
    }

    boolean isEmpty() {
        return this.text.length() == 0;
    }

    void append(CharSequence charSequence) {
        this.text.append(charSequence);
    }

    boolean addItem(AssemblyItem assemblyItem) {
        if (this.items == Collections.EMPTY_LIST) {
            this.items = new ArrayList<AssemblyItem>();
        }
        this.items.add(assemblyItem);
        assemblyItem.setLine(this);
        return true;
    }

    boolean addMark(TextMark textMark) {
        if (this.marks == Collections.EMPTY_LIST) {
            this.marks = new ArrayList<TextMark>();
        }
        return this.marks.add(textMark);
    }

    public String toString() {
        return this.getText().toString();
    }
}

