/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.api.IScript;
import com.pnfsoftware.jeb.client.script.JythonDynamicWrapper;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.client.script.ScriptInitializationException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class PythonScriptFactory {
    private static final ILogger logger = GlobalLog.getLogger(PythonScriptFactory.class);
    private static int globalCreationCount;
    private JythonDynamicWrapper j;
    private String directory;
    private String filenameNoExt;
    private String classname;
    private Object interpreter;
    private Object scriptClass;

    public PythonScriptFactory(JythonDynamicWrapper jythonDynamicWrapper, String string, String string2, String string3) throws ScriptInitializationException {
        this.j = jythonDynamicWrapper;
        this.directory = string;
        this.filenameNoExt = string2;
        this.classname = string3;
        String string4 = jythonDynamicWrapper.getJythonJarFile().getParent();
        this.init(string4);
    }

    private void init(String string) throws ScriptInitializationException {
        try {
            if (globalCreationCount++ == 0) {
                logger.info("Initializing Jython, please wait...", new Object[0]);
            }
            Properties properties = new Properties();
            properties.put("python.home", string);
            properties.put("python.console.encoding", "UTF-8");
            properties.put("python.security.respectJavaAccessibility", "false");
            Properties properties2 = System.getProperties();
            this.j.PythonInterpreter_initialize(properties2, properties, new String[0]);
            long l2 = System.currentTimeMillis();
            this.interpreter = this.j.PythonInterpreter_init(null, this.j.PySystemState_init());
            logger.i("Jython interpreter init time: %dms", System.currentTimeMillis() - l2);
            this.j.PythonInterpreter_exec(this.interpreter, "import sys");
            this.j.PythonInterpreter_exec(this.interpreter, String.format("sys.path.append(\"%s\")", this.directory.replace("\\", "\\\\")));
            String string2 = String.format("%s = __import__('%s', fromlist=['%s']).%s", this.classname, this.filenameNoExt, this.classname, this.classname);
            this.j.PythonInterpreter_exec(this.interpreter, string2);
            LogRedirectionOutputStream logRedirectionOutputStream = new LogRedirectionOutputStream();
            this.j.PythonInterpreter_setOut(this.interpreter, logRedirectionOutputStream);
            this.scriptClass = this.j.PythonInterpreter_get(this.interpreter, this.classname);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptInitializationException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void close() {
        try {
            this.j.PythonInterpreter_cleanup(this.interpreter);
            this.interpreter = null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public IScript create() throws ScriptInitializationException {
        if (this.interpreter == null) {
            throw new IllegalStateException("The script interpreter is not initialized");
        }
        try {
            Object object = this.j.PyObject_call(this.scriptClass);
            return (IScript)this.j.PyObject_tojava(object, IScript.class);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptInitializationException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

