/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.reflect.ClasspathCollector;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;

public class JythonDynamicWrapper {
    private File jythonJarFile;
    private ClassLoader cl;
    private Class cPythonInterpreter;
    private Class cPyObject;
    private Class cPyNone;
    private Class cPyString;
    private Class cPySystemState;
    private Class cPyException;

    public JythonDynamicWrapper(File file) throws ReflectiveOperationException {
        this.jythonJarFile = file;
        ClasspathCollector classpathCollector = new ClasspathCollector();
        classpathCollector.addFromJar(file);
        this.cl = classpathCollector.createClassloader();
        this.cPythonInterpreter = this.cl.loadClass("org.python.util.PythonInterpreter");
        this.cPyObject = this.cl.loadClass("org.python.core.PyObject");
        this.cPyNone = this.cl.loadClass("org.python.core.PyNone");
        this.cPyString = this.cl.loadClass("org.python.core.PyString");
        this.cPySystemState = this.cl.loadClass("org.python.core.PySystemState");
        this.cPyException = this.cl.loadClass("org.python.core.PyException");
    }

    public File getJythonJarFile() {
        return this.jythonJarFile;
    }

    public void PythonInterpreter_initialize(Properties properties, Properties properties2, String[] stringArray) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("initialize", Properties.class, Properties.class, String[].class).invoke(null, properties, properties2, stringArray);
    }

    public Object PySystemState_init() throws ReflectiveOperationException {
        return this.cPySystemState.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Object PythonInterpreter_init(Object object, Object object2) throws ReflectiveOperationException {
        return this.cPythonInterpreter.getConstructor(this.cPyObject, this.cPySystemState).newInstance(object, object2);
    }

    public void PythonInterpreter_exec(Object object, String string) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("exec", String.class).invoke(object, string);
    }

    public Object PythonInterpreter_eval(Object object, String string) throws ReflectiveOperationException {
        return this.cPythonInterpreter.getMethod("eval", String.class).invoke(object, string);
    }

    public Object PythonInterpreter_eval(Object object, Object object2) throws ReflectiveOperationException {
        return this.cPythonInterpreter.getMethod("eval", this.cPyObject).invoke(object, object2);
    }

    public Object PythonInterpreter_compile(Object object, String string) throws ReflectiveOperationException {
        return this.cPythonInterpreter.getMethod("compile", String.class).invoke(object, string);
    }

    public void PythonInterpreter_setIn(Object object, Reader reader) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("setIn", Reader.class).invoke(object, reader);
    }

    public void PythonInterpreter_setOut(Object object, Writer writer) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("setOut", Writer.class).invoke(object, writer);
    }

    public void PythonInterpreter_setErr(Object object, Writer writer) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("setErr", Writer.class).invoke(object, writer);
    }

    public Object PythonInterpreter_get(Object object, String string) throws ReflectiveOperationException {
        return this.cPythonInterpreter.getMethod("get", String.class).invoke(object, string);
    }

    public void PythonInterpreter_set(Object object, String string, Object object2) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("set", String.class, Object.class).invoke(object, string, object2);
    }

    public void PythonInterpreter_cleanup(Object object) throws ReflectiveOperationException {
        this.cPythonInterpreter.getMethod("cleanup", new Class[0]).invoke(object, new Object[0]);
    }

    public Object PyObject_call(Object object) throws ReflectiveOperationException {
        return this.cPyObject.getMethod("__call__", new Class[0]).invoke(object, new Object[0]);
    }

    public Object PyObject_tojava(Object object, Class<?> clazz) throws ReflectiveOperationException {
        return this.cPyObject.getMethod("__tojava__", Class.class).invoke(object, clazz);
    }

    public boolean isPyException(Throwable throwable) {
        return this.cPyException.isInstance(throwable);
    }

    public Couple<Object, Object> getPyExceptionTypeAndValue(Object object) throws ReflectiveOperationException {
        return new Couple<Object, Object>(this.cPyException.getField("type").get(object), this.cPyException.getField("value").get(object));
    }

    public boolean isPyObject(Object object) {
        return this.cPyObject.isInstance(object);
    }

    public boolean isPyNone(Object object) {
        return this.cPyNone.isInstance(object);
    }

    public boolean isPyString(Object object) {
        return this.cPyString.isInstance(object);
    }
}

