/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.AssetManager;
import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.PublicAnnouncement;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.SoftwareBuildInfo;
import com.pnfsoftware.jeb.client.SystemInformation;
import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.MootTelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.StandardTelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.StandardTelemetryEndpoint;
import com.pnfsoftware.jeb.client.telemetry.TelemetryException;
import com.pnfsoftware.jeb.core.Artifact;
import com.pnfsoftware.jeb.core.CoreOptions;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.JebClientInformation;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.dao.impl.DataProvider;
import com.pnfsoftware.jeb.core.dao.impl.JEB2FileDatabase;
import com.pnfsoftware.jeb.core.dao.impl.SimpleFSFileStore;
import com.pnfsoftware.jeb.core.events.ControllerNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypePath;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.SizeFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.Ls;
import com.pnfsoftware.jebglobal.Ol;
import com.pnfsoftware.jebglobal.Qi;
import com.pnfsoftware.jebglobal.Rf;
import com.pnfsoftware.jebglobal.ZY;
import com.pnfsoftware.jebglobal.pi;
import com.pnfsoftware.jebglobal.qZ;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;

@SerDisabled
public abstract class AbstractClientContext
extends AbstractContext
implements IClientContext {
    private static final ILogger logger = GlobalLog.getLogger(AbstractClientContext.class);
    public static final String defaultClientConfigPath = "jeb-client.cfg";
    public static final String defaultEnginesConfigPath = "jeb-engines.cfg";
    public static final String defaultTelemetryDatabasePath = "jt.db";
    public static final String defaultScriptsFolderName = "scripts";
    public static final String defaultPluginsFolderName = "coreplugins";
    private static final String UPDATE_FILENAME = Ls.eO(new byte[]{44, 5, 20, 5, 21, 17, 75, 84, 19, 25}, 1, 89);
    private static final String UPDATE_PASS_FILENAME = Ls.eO(new byte[]{-45, 5, 20, 5, 21, 17, 75, 94, 7, 19}, 1, 166);
    protected CoreOptions coreOptions = CoreOptions.getDefault();
    protected String[] args = new String[0];
    private String configpath;
    private String engconfigpath;
    protected String inputpath;
    private boolean shouldInitEngines;
    protected boolean basicChecksPassed;
    private IPropertyDefinitionManager pdm;
    private IPropertyManager pm;
    private PropertiesConfiguration cfg;
    private String teledbpath;
    private ITelemetryDatabase teledb;
    private static Net net;
    private static pi pinger;
    private static Random prng;
    private ICoreContext corectx;
    private IEnginesContext engctx;
    private ConcurrentHashMap<Object, Object> transientStore = new ConcurrentHashMap();

    protected AbstractClientContext() {
    }

    public void initialize(String[] stringArray) {
        Object object;
        ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                File file = new File(System.getProperty("user.home"), ".jebc_ts");
                file.deleteOnExit();
                while (true) {
                    try {
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        file.setLastModified(System.currentTimeMillis());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000 + prng.nextInt(1000));
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        });
        this.parseCommandLineArguments(stringArray);
        if (this.configpath == null) {
            this.configpath = String.format("%s/%s", this.getProgramDirectory(), defaultClientConfigPath);
        }
        this.cfg = this.createPropertiesConfiguration(this.configpath);
        this.pdm = new PropertyDefinitionManager();
        this.pdm.addInternalDefinition(".Uuid", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".FirstRun", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".LastRun", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".RunCount", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".LastVersionRun", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".EulaAccepted", PropertyTypeBoolean.create(false));
        this.pdm.addInternalDefinition(".LicenseKey", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".SupportExpired", PropertyTypeBoolean.create());
        this.pdm.addInternalDefinition(".PreferredLanguage", PropertyTypeString.create(""));
        this.pdm.addInternalDefinition(".DebugEnabled", PropertyTypeBoolean.create(false));
        this.pdm.addInternalDefinition(".CheckMOTD", PropertyTypeBoolean.create(true));
        this.pdm.addInternalDefinition(".LastMOTDId", PropertyTypeInteger.create());
        this.pdm.addInternalDefinition(".TelemetryReporting", PropertyTypeBoolean.create(true));
        this.pdm.addDefinition(".NetworkProxy", PropertyTypeString.create(), "Network proxy settings for JEB client components. The format of this property is: 'type|hostname|port|user|pass|whitelist'.\n- type can be direct (no proxy), http, or socks\n- hostname and port are mandatory for non-direct proxy types\n- user and password are optional (needed only if your proxy requires authentication)\n- whitelist is an optional list of domains/IPs (with support for the wildcard character *) for which no proxy connection should be used (always direct connect)");
        this.pdm.addDefinition(".CheckUpdates", PropertyTypeBoolean.create(true), "Let JEB automatically check for software updates (requires an Internet connection)");
        this.pdm.addInternalDefinition(".WriteUpdateToDiskOnlyIfValid", PropertyTypeBoolean.create(false));
        this.pdm.addDefinition(".UploadErrorLogs", PropertyTypeBoolean.create(true), "Securely upload error logs to PNF Software error server");
        this.pdm.addInternalDefinition(".UploadErrorFiles", PropertyTypeBoolean.create(true));
        this.pdm.addInternalDefinition(".IncludeExtraDataInErrorLogs", PropertyTypeBoolean.create(Licensing.isDemoBuild()));
        this.pdm.addDefinition(".DevelopmentMode", PropertyTypeBoolean.create(false), "Increase verbosity and error messages. Recommended when developing JEB Extensions (plugins or scripts).");
        String string = new File(this.getBaseDirectory(), defaultScriptsFolderName).getAbsolutePath();
        this.pdm.addDefinition(".ScriptsFolder", PropertyTypePath.create(string), "Folder containing JEB client scripts written in Python");
        this.pm = new PropertyManager(this.pdm, new CommonsConfigurationWrapper((Configuration)this.cfg));
        this.pm.addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                PropertyChangeNotification propertyChangeNotification;
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification && (propertyChangeNotification = (PropertyChangeNotification)iEvent.getData()).has(".NetworkProxy")) {
                    String string = AbstractClientContext.this.getProxyString();
                    try {
                        Net.setGlobalProxyInformation(NetProxyInfo.parse(string));
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                    }
                }
            }
        });
        long l2 = this.getUuid();
        if (l2 == 0L) {
            object = new SecureRandom();
            l2 = ((Random)object).nextLong() & Long.MAX_VALUE;
            this.pm.setString(".Uuid", Long.toString(l2));
        }
        if (this.isDevelopmentMode()) {
            GlobalLog.setEnabledLevel(0);
        }
        net = AbstractClientContext.initNetworkUtility(this.getProxyString());
        pinger = new pi(net);
        object = this.getPreferredLanguage();
        if (object != null && !((String)object).isEmpty()) {
            S.setLanguage((String)object);
        }
        logger.trace("Current language: %s (default: %s)", S.getLanguage(), S.getDefaultLanguage());
        if (this.teledbpath == null) {
            this.teledbpath = String.format("%s/%s", this.getProgramDirectory(), defaultTelemetryDatabasePath);
        }
        if (!Licensing.isDebugBuild() && !OSType.determine().isLinux() && (Licensing.isDemoBuild() || this.pm.getBoolean(".TelemetryReporting"))) {
            try {
                StandardTelemetryDatabase standardTelemetryDatabase = new StandardTelemetryDatabase(this.teledbpath, new StandardTelemetryEndpoint(net, l2));
                standardTelemetryDatabase.startDumperThread();
                this.teledb = standardTelemetryDatabase;
            }
            catch (Exception exception) {
                this.teledb = new MootTelemetryDatabase();
                logger.catchingSilent(exception);
            }
        } else {
            this.teledb = new MootTelemetryDatabase();
        }
        this.coreOptions.setDevelopmentMode(this.isDevelopmentMode());
        this.coreOptions.setStandardProxyInfo(NetProxyInfo.parse(this.getProxyString()));
    }

    public void start() throws JebException {
        CharSequence charSequence;
        logger.info("%s %s (%s) is starting...", "JEB", app_ver.toString(), Licensing.buildkey);
        logger.info("%s: %s", S.s(226), this.getCurrentDirectory());
        logger.info("%s: %s", S.s(98), this.getBaseDirectory());
        logger.info("%s: %s", S.s(654), this.getProgramDirectory());
        logger.info("System: %s %s (%s) %s", SystemInformation.osname, SystemInformation.osversion, SystemInformation.osarch, SystemInformation.localeinfo);
        logger.info("Java: %s %s", SystemInformation.javavendor, SystemInformation.javaversion);
        Version version = Version.parseFromString(this.pm.getString(".LastVersionRun"));
        if (!this.pm.getBoolean(".EulaAccepted") || version == null || version.compareToIgnoreTimestamp(Version.create(2, 3, 5)) < 0) {
            charSequence = Licensing.getLicense();
            if (!this.displayEula((String)charSequence)) {
                logger.info(S.s(315), new Object[0]);
                this.pm.setBoolean(".EulaAccepted", false);
                AbstractClientContext.terminate();
            }
            this.pm.setBoolean(".EulaAccepted", true);
        }
        if (this.pm.getInteger(".FirstRun") == 0) {
            this.pm.setInteger(".FirstRun", this.getStartTimestamp());
        }
        this.pm.setInteger(".LastRun", this.getStartTimestamp());
        this.pm.setInteger(".RunCount", this.pm.getInteger(".RunCount") + 1);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("This software is a limited demonstration build of JEB.\n\n");
        ((StringBuilder)charSequence).append("Limitations of the demo version include:\n");
        ((StringBuilder)charSequence).append("- Decompilation is limited to a subset of code\n");
        ((StringBuilder)charSequence).append("- Saving or loading projects is disabled\n");
        ((StringBuilder)charSequence).append("- Usage of the clipboard is disallowed\n");
        ((StringBuilder)charSequence).append("- Running time of a session is limited\n");
        if (!Licensing.isAirgapBuild()) {
            ((StringBuilder)charSequence).append("- Requires the Internet connection\n");
        }
        if (!Licensing.canUseCoreAPI()) {
            ((StringBuilder)charSequence).append("- Usage of third-party back-end plugins is disabled\n");
        }
        if (!Licensing.allowAnyClient()) {
            ((StringBuilder)charSequence).append("- Usage of third-party clients is disabled\n");
        }
        this.displayDemoInformation(((StringBuilder)charSequence).toString());
        this.pm.setBoolean(".CheckUpdates", true);
        this.pm.setBoolean(".UploadErrorLogs", true);
        if (version == null || version.compareTo(app_ver) < 0) {
            String string = Strings.decodeUTF8(AssetManager.eO("CHANGELIST.TXT"));
            this.onUpdatedSoftware(string, version);
        } else if (this.integrity_failed) {
            this.pm.setBoolean(".CheckUpdates", true);
        }
        this.pm.setString(".LastVersionRun", app_ver.toString());
        boolean bl2 = this instanceof Rf;
        boolean bl3 = Licensing.isFloatingBuild();
        if (bl2 && !bl3) {
            throw new RuntimeException();
        }
        this.prepareCheckLicenseKey();
        if (this.integrity_failed) {
            AbstractClientContext.terminate();
        }
        String string = this.pm.getString(".LicenseKey");
        this.corectx = JebCoreService.getInstance(string, this.coreOptions);
        this.shouldInitEngines = !bl2;
        this.basicChecksPassed = true;
    }

    public void stop() {
        try {
            if (this.teledb != null) {
                this.teledb.close();
            }
        }
        catch (TelemetryException telemetryException) {
            logger.catchingSilent(telemetryException);
        }
        try {
            if (this.corectx != null) {
                this.corectx.close();
            }
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
        }
    }

    private void parseCommandLineArguments(String[] stringArray) {
        for (String string : stringArray) {
            logger.i("- Argument: %s", string);
        }
        int n = 0;
        for (String string : stringArray) {
            if (string.equals("--")) {
                ++n;
                break;
            }
            if (!string.startsWith("-")) break;
            if (string.startsWith("--config=")) {
                this.configpath = string.substring(string.indexOf(61) + 1);
            } else if (string.startsWith("--engconfig=")) {
                this.engconfigpath = string.substring(string.indexOf(61) + 1);
            } else if (string.startsWith("--cd=")) {
                String string2 = string.substring(string.indexOf(61) + 1);
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                SystemInformation.setCurrentDirectory(string2);
            }
            ++n;
        }
        this.args = new String[stringArray.length - n];
        for (int j = n; j < stringArray.length; ++j) {
            this.args[j - n] = stringArray[j];
        }
        if (this.args.length > 0) {
            this.inputpath = this.args[0];
        }
    }

    private PropertiesConfiguration createPropertiesConfiguration(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        Parameters parameters = new Parameters();
        FileBasedConfigurationBuilder fileBasedConfigurationBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)parameters.properties().setFileName(string)});
        fileBasedConfigurationBuilder.setAutoSave(true);
        try {
            return (PropertiesConfiguration)fileBasedConfigurationBuilder.getConfiguration();
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
    }

    @Override
    public String[] getArguments() {
        return this.args;
    }

    public String getInputpath() {
        return this.inputpath;
    }

    public Net getNetworkUtility() {
        return net;
    }

    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    public IPropertyManager getPropertyManager() {
        return this.pm;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public ITelemetryDatabase getTelemetry() {
        return this.teledb;
    }

    public boolean isDevelopmentMode() {
        return this.pm.getBoolean(".DevelopmentMode");
    }

    public void setDevelopmentMode(boolean bl2) {
        this.pm.setBoolean(".DevelopmentMode", bl2);
    }

    public final long getUuid() {
        try {
            return Long.parseLong(this.pm.getString(".Uuid"));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public final String getPreferredLanguage() {
        return this.pm.getString(".PreferredLanguage");
    }

    public final void setPreferredLanguage(String string) {
        this.pm.setString(".PreferredLanguage", string);
    }

    public final boolean shouldCheckUpdates() {
        return Licensing.isDemoBuild() || this.pm.getBoolean(".CheckUpdates");
    }

    public final boolean shouldCheckPublicAnnouncements() {
        return Licensing.isDemoBuild() || this.pm.getBoolean(".CheckMOTD");
    }

    public final String getProxyString() {
        return this.pm.getString(".NetworkProxy");
    }

    public final void setProxyString(String string) {
        this.pm.setString(".NetworkProxy", string);
    }

    public final int getLastPublicAnnouncementId() {
        return this.pm.getInteger(".LastMOTDId");
    }

    public final void setLastPublicAnnouncementId(int n) {
        this.pm.setInteger(".LastMOTDId", n);
    }

    public boolean isHeadless() {
        return true;
    }

    public abstract boolean checkUpdate();

    public abstract boolean displayEula(String var1);

    public abstract void displayDemoInformation(String var1);

    public abstract void onUpdatedSoftware(String var1, Version var2);

    public abstract String retrieveLicenseKey(String var1);

    public abstract void notifySupportExpired();

    public abstract boolean setupController();

    public abstract void notifyFloatingClient(ControllerNotification var1);

    private void prepareCheckLicenseKey() {
        ZY.eO();
        String string = this.pm.getString(".LicenseKey");
        int[] nArray = new int[1];
        boolean bl2 = false;
        if (!Strings.isBlank(string)) {
            long[] lArray;
            for (long l2 : lArray = Qi.Le()) {
                qZ qZ2 = new qZ(l2);
                if (!qZ2.eO(string, nArray)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            ZY.Le();
            long l3 = Qi.eO();
            qZ qZ3 = new qZ(l3);
            String string2 = qZ3.eO();
            string = this.retrieveLicenseKey(string2);
            ZY.eO();
            if (!qZ3.eO(string, nArray)) {
                logger.info(S.s(437), new Object[0]);
                AbstractClientContext.terminate();
            }
            this.pm.setString(".LicenseKey", string.trim());
        }
        Licensing.setLicenseTimestamp(nArray[0]);
        int n = Licensing.getExpirationTimestamp();
        if (n != 0) {
            if (n < 0 || this.getStartTimestamp() >= n) {
                this.pm.setBoolean(".SupportExpired", true);
                this.notifySupportExpired();
            } else if (this.pm.getBoolean(".SupportExpired")) {
                this.pm.setBoolean(".SupportExpired", false);
            }
        }
    }

    public static final String generateLicenseInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = AbstractClientContext.getChannelName() == null ? "" : " (" + AbstractClientContext.getChannelName() + ")";
        stringBuilder.append(String.format("JEB %s%s\n", app_ver, string));
        stringBuilder.append(String.format(S.s(434), String.format("%s (%s)", Licensing.user_name, Licensing.user_group)));
        stringBuilder.append(String.format("\n%s: %s\n%s: %d\n%s: %d", S.s(286), Licensing.user_email, S.s(812), Licensing.user_id, S.s(435), Licensing.license_id));
        int n = Licensing.user_count;
        if (n >= 1) {
            String string2 = PluralFormatter.countS(n, Licensing.isFloatingBuild() ? "floating seat" : "user");
            stringBuilder.append(String.format("\nValid for %d %s", n, string2));
        }
        stringBuilder.append(String.format("\n%s: %s\n(%s)", S.s(103), Licensing.buildkey, Licensing.getBuildTypeString()));
        int n2 = Licensing.getExpirationTimestamp();
        if (n2 > 0) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.setTime(new Date(1000L * (long)n2));
            String string3 = String.format("%04d-%02d-%02d", calendar.get(1), 1 + calendar.get(2), calendar.get(5));
            if (Licensing.isSubscription()) {
                stringBuilder.append(String.format("\n%s: %s", S.s(758), string3));
            } else {
                stringBuilder.append(String.format("\nReceiving updates until: %s", string3));
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int ping(boolean bl2, int n, SoftwareBuildInfo softwareBuildInfo, IProgressCallback iProgressCallback) {
        Object object;
        File file;
        boolean bl3;
        logger.info(S.s(797), new Object[0]);
        Ol ol2 = pinger.lS();
        if (ol2 == null) {
            logger.error(S.s(803), new Object[0]);
            return -1;
        }
        Version version = ol2.Qx().eO();
        int n3 = ol2.Qx().Le();
        int n4 = ol2.Qx().TI();
        if (softwareBuildInfo != null) {
            softwareBuildInfo.setVersion(version);
            softwareBuildInfo.setChannel(n3);
            softwareBuildInfo.setFlags(n4);
        }
        if (version.compareTo(app_ver) <= 0 || n3 > n) {
            if ((n4 & 1) != 0) {
                logger.info("JEB version %d is available. It needs to be installed separately. Please check your registered email for download details.", app_ver.getMajor() + 1);
                return 0;
            }
            logger.info(S.s(808), new Object[0]);
            return 0;
        }
        if (!bl2) {
            logger.warn(S.s(806), new Object[0]);
            return 1;
        }
        byte[] byArray = null;
        File file4 = new File(this.getBaseDirectory(), UPDATE_FILENAME);
        if (file4.exists()) {
            try {
                byArray = IO.readFile(file4);
                if (Arrays.equals(ol2.Qx().lS(), Hash.calculateSHA256(byArray))) {
                    logger.info(S.s(804), new Object[0]);
                    return 2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl3 = this.pm.getBoolean(".WriteUpdateToDiskOnlyIfValid")) {
            logger.info(S.s(802), version);
            try {
                byArray = net.queryBinary(ol2.Qx().Qx(), null, null, iProgressCallback);
            }
            catch (IOException iOException) {
                logger.catching(iOException, S.s(801));
                return -2;
            }
            if (!Arrays.equals(ol2.Qx().lS(), Hash.calculateSHA256(byArray))) {
                logger.error(S.s(799), new Object[0]);
                if (!this.pm.getBoolean(".DebugEnabled")) return -2;
                try {
                    IO.writeFile(file4, byArray, false);
                    return -2;
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                }
                return -2;
            }
            String string = ol2.Qx().ae();
            try {
                this.dumpUpdateToDisk(byArray, string);
            }
            catch (Exception exception) {
                logger.error(S.s(800), new Object[0]);
                return -2;
            }
        }
        File file3 = new File(this.getBaseDirectory(), UPDATE_FILENAME);
        File file2 = new File(this.getBaseDirectory(), UPDATE_PASS_FILENAME);
        logger.info(S.s(802), version);
        try {
            file = File.createTempFile("jeb-update-", ".zip");
            file.setReadable(true);
            file.setWritable(true);
            net.downloadBinary(file, ol2.Qx().Qx(), null, null, iProgressCallback);
        }
        catch (IOException iOException) {
            logger.catching(iOException, S.s(801));
            return -2;
        }
        try {
            object = new FileInputStream(file);
            Throwable throwable = null;
            try {
                if (!Arrays.equals(ol2.Qx().lS(), HashCalculator.sha256((InputStream)object))) {
                    logger.error(S.s(799), new Object[0]);
                    int n2 = -2;
                    return n2;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException, "Cannot read the update archive %s", file);
            return -2;
        }
        if (file3.exists() && !IO.deleteFile(file3)) {
            logger.error("Update attempt may fail as an older software archive cannot be removed: %s", file3);
        }
        if (!file.renameTo(file3)) {
            try {
                Files.move(file.toPath(), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                logger.catching(iOException, "Unable to move %s to %s", file, file3);
                try {
                    Files.copy(file.toPath(), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException2) {
                    logger.catching(iOException2, "Unable to copy %s to %s", file, file3);
                    logger.error("Cannot drop JEB update in base folder", new Object[0]);
                    return -2;
                }
            }
        }
        try {
            object = ol2.Qx().ae();
            if (object != null && ((String)object).length() > 0) {
                IO.writeFile(file2, Strings.encodeUTF8((String)object), false);
            }
        }
        catch (Exception exception) {
            logger.catching(exception, S.s(800));
            return -2;
        }
        logger.info(S.s(807), new Object[0]);
        return 2;
    }

    public final void dumpUpdateToDisk(byte[] byArray, String string) throws IOException {
        IO.writeFile(new File(this.getBaseDirectory(), UPDATE_FILENAME), byArray, false);
        if (string != null && string.length() > 0) {
            IO.writeFile(new File(this.getBaseDirectory(), UPDATE_PASS_FILENAME), Strings.encodeUTF8(string), false);
        }
    }

    public final PublicAnnouncement retrieveLatestPublicAnnouncement() {
        byte[] byArray;
        try {
            byArray = net.queryBinary("https://www.pnfsoftware.com/jeb/motd");
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
        try {
            return PublicAnnouncement.parse(Strings.decodeUTF8(byArray));
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return null;
        }
    }

    public final String getScriptsDirectory() {
        String string = this.pm.getString(".ScriptsFolder");
        if (string == null) {
            string = new File(this.getBaseDirectory(), defaultScriptsFolderName).getAbsolutePath();
        }
        return string;
    }

    public final File getScriptsDirfile() {
        String string = this.getScriptsDirectory();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Illegal script directory: %s" + file);
        }
        return file;
    }

    public final void setScriptsDirectory(String string) {
        this.pm.setString(".ScriptsFolder", string);
    }

    @Override
    public long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    @Override
    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public final void logMemoryUsage() {
        logger.info("%s", AbstractClientContext.formatMemoryUsage());
    }

    public static String formatMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory();
        long l4 = runtime.freeMemory();
        long l5 = l3 - l4;
        return String.format("%s: %s allocated (%s used, %s free) - max: %s", S.s(456), SizeFormatter.formatByteSize(l3), SizeFormatter.formatByteSize(l5), SizeFormatter.formatByteSize(l4), SizeFormatter.formatByteSize(l2));
    }

    protected final void initializeEngines() throws JebException {
        if (!this.shouldInitEngines) {
            return;
        }
        String string = this.getBaseDirectory();
        SimpleFSFileStore simpleFSFileStore = new SimpleFSFileStore(string);
        SimpleFSFileStore simpleFSFileStore2 = new SimpleFSFileStore(string + File.separator + defaultPluginsFolderName);
        JEB2FileDatabase jEB2FileDatabase = new JEB2FileDatabase(string);
        if (this.engconfigpath == null) {
            this.engconfigpath = this.getProgramDirectory() + File.separator + defaultEnginesConfigPath;
        }
        PropertiesConfiguration propertiesConfiguration = this.createPropertiesConfiguration(this.engconfigpath);
        CommonsConfigurationWrapper commonsConfigurationWrapper = new CommonsConfigurationWrapper((Configuration)propertiesConfiguration);
        DataProvider dataProvider = new DataProvider(null, jEB2FileDatabase, simpleFSFileStore, simpleFSFileStore2, null, commonsConfigurationWrapper);
        JebClientInformation jebClientInformation = new JebClientInformation(Ls.eO(new byte[]{-40, 30, 8, 102, 115, 60, 9, 18, 3, 22, 19, 23, 69, 13, 13, 106, 15, 7, 98, 111, 41, 0, 15, 10, 10, 8, 13, 76, 99, 47, 5, 12, 11, 26}, 1, 136));
        this.engctx = this.corectx.createEnginesContext(dataProvider, jebClientInformation);
    }

    public final ICoreContext getCoreContext() {
        return this.corectx;
    }

    @Override
    public final IEnginesContext getEnginesContext() {
        return this.engctx;
    }

    public final boolean hasOpenedProject() {
        return this.getOpenedProject() != null;
    }

    public final IRuntimeProject getOpenedProject() {
        IEnginesContext iEnginesContext = this.getEnginesContext();
        if (iEnginesContext == null || CollectionUtils.isEmpty(iEnginesContext.getProjects())) {
            return null;
        }
        return iEnginesContext.getProjects().get(0);
    }

    public final boolean closeOpenedProject() {
        IRuntimeProject iRuntimeProject = this.getOpenedProject();
        if (iRuntimeProject == null) {
            return false;
        }
        return this.getEnginesContext().unloadProject(iRuntimeProject.getKey());
    }

    @Override
    public IRuntimeProject getMainProject() {
        return this.getOpenedProject();
    }

    @Override
    public boolean closeMainProject() {
        return this.closeOpenedProject();
    }

    @Override
    public IUnit open(String string) throws IOException {
        File file = new File(string);
        if (file.getName().endsWith(".jdb2")) {
            if (this.hasOpenedProject()) {
                throw new IllegalStateException("A project is already loaded");
            }
            IRuntimeProject iRuntimeProject = this.engctx.loadProject(file.getAbsolutePath());
            return iRuntimeProject.getLiveArtifact(0).getMainUnit();
        }
        IRuntimeProject iRuntimeProject = this.getMainProject();
        if (iRuntimeProject == null) {
            iRuntimeProject = this.engctx.loadProject(file.getName());
        }
        Artifact artifact = new Artifact(file.getName(), new FileInput(file));
        return iRuntimeProject.processArtifact(artifact).getMainUnit();
    }

    @Override
    public Map<Object, Object> getTransientStore() {
        return this.transientStore;
    }

    public String getControllerInterface() {
        return this.pm.getString(".ControllerInterface");
    }

    public void setControllerInterface(String string) {
        this.pm.setString(".ControllerInterface", string);
    }

    public int getControllerPort() {
        return this.pm.getInteger(".ControllerPort");
    }

    public void setControllerPort(int n) {
        this.pm.setInteger(".ControllerPort", n);
    }

    public int getControllerProtocol() {
        return this.pm.getInteger(".ControllerProtocol");
    }

    public void setControllerProtocol(int n) {
        this.pm.setInteger(".ControllerProtocol", n);
    }

    public String getControllerMessage() {
        return this.pm.getString(".ControllerMessage");
    }

    private InetSocketAddress getFloatingControllerAddress() {
        if (this.getControllerInterface().isEmpty() && !this.setupController()) {
            logger.info(S.s(398), new Object[0]);
            AbstractClientContext.terminate();
        }
        return new InetSocketAddress(this.getControllerInterface(), this.getControllerPort());
    }

    static {
        prng = new Random();
    }
}

