/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb;

import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;

public class AssetManager {
    private static final ILogger eO = GlobalLog.getLogger(AssetManager.class);

    public static InputStream getAsset(String string) throws IOException {
        InputStream inputStream = AssetManager.class.getResourceAsStream("assets/" + string);
        if (inputStream == null) {
            throw new IOException(String.format("Asset \"%s\" does not exist", string));
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] eO(String string) {
        try (InputStream inputStream = AssetManager.getAsset(string);){
            byte[] byArray = IO.readInputStream(inputStream);
            return byArray;
        }
        catch (IOException iOException) {
            eO.catching(iOException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int Le(String string) {
        try (InputStream inputStream = AssetManager.getAsset(string);){
            int n = inputStream.available();
            return n;
        }
        catch (IOException iOException) {
            eO.catching(iOException);
            return -1;
        }
    }
}

