/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard
implements IWizard,
IShellProvider {
    public static final String DEFAULT_IMAGE = "org.eclipse.jface.wizard.Wizard.pageImage";
    private IWizardContainer container = null;
    private List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private ImageDescriptor defaultImageDescriptor = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;

    protected Wizard() {
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard(this);
    }

    @Override
    public void addPages() {
    }

    @Override
    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!this.pages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            page.createControl(pageContainer);
            Assert.isNotNull(page.getControl(), "getControl() of wizard page returns null. Did you call setControl() in your wizard page?");
            ++i;
        }
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.pages.size()) {
            try {
                this.pages.get(i).dispose();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.jface", 4, e.getMessage(), e);
                Policy.getLog().log(status);
            }
            ++i;
        }
        if (this.defaultImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultImageDescriptor);
            this.defaultImage = null;
        }
    }

    @Override
    public IWizardContainer getContainer() {
        return this.container;
    }

    @Override
    public Image getDefaultPageImage() {
        if (this.defaultImage == null) {
            this.defaultImage = JFaceResources.getResources().createImageWithDefault(this.defaultImageDescriptor);
        }
        return this.defaultImage;
    }

    @Override
    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return this.pages.get(index + 1);
    }

    @Override
    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return this.pages.get(index - 1);
    }

    @Override
    public Shell getShell() {
        if (this.container == null) {
            return null;
        }
        return this.container.getShell();
    }

    @Override
    public IWizardPage getStartingPage() {
        if (this.pages.isEmpty()) {
            return null;
        }
        return this.pages.get(0);
    }

    @Override
    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    @Override
    public String getWindowTitle() {
        return this.windowTitle;
    }

    @Override
    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    @Override
    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    @Override
    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public abstract boolean performFinish();

    @Override
    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDefaultPageImageDescriptor(ImageDescriptor imageDescriptor) {
        this.defaultImageDescriptor = imageDescriptor;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setTitleBarColor(RGB color) {
        this.titleBarColor = color;
    }

    public void setWindowTitle(String newTitle) {
        this.windowTitle = newTitle;
        if (this.container != null) {
            this.container.updateWindowTitle();
        }
    }
}

