/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToByteConverter
extends NumberFormatConverter<Object, Byte> {
    private String outOfRangeMessage;
    private NumberFormat numberFormat;
    private boolean primitive;

    private StringToByteConverter(NumberFormat numberFormat, Class<?> toType) {
        super(String.class, toType, numberFormat);
        this.primitive = toType.isPrimitive();
        this.numberFormat = numberFormat;
    }

    public static StringToByteConverter toByte(NumberFormat numberFormat, boolean primitive) {
        return new StringToByteConverter(numberFormat, primitive ? Byte.TYPE : Byte.class);
    }

    public static StringToByteConverter toByte(boolean primitive) {
        return StringToByteConverter.toByte(NumberFormat.getIntegerInstance(), primitive);
    }

    @Override
    public Byte convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.primitive);
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        if (StringToNumberParser.inByteRange(result.getNumber())) {
            return result.getNumber().byteValue();
        }
        StringToByteConverter stringToByteConverter = this;
        synchronized (stringToByteConverter) {
            if (this.outOfRangeMessage == null) {
                this.outOfRangeMessage = StringToNumberParser.createOutOfRangeMessage((byte)-128, (byte)127, this.numberFormat);
            }
            throw new IllegalArgumentException(this.outOfRangeMessage);
        }
    }
}

