/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;

final class GtkView
extends View {
    private boolean imEnabled = false;

    GtkView() {
    }

    private native void enableInputMethodEventsImpl(long var1, boolean var3);

    @Override
    protected void _enableInputMethodEvents(long l, boolean bl) {
        this.enableInputMethodEventsImpl(l, bl);
        this.imEnabled = bl;
    }

    @Override
    protected int _getNativeFrameBuffer(long l) {
        return 0;
    }

    @Override
    protected native long _create(Map var1);

    @Override
    protected native long _getNativeView(long var1);

    @Override
    protected native int _getX(long var1);

    @Override
    protected native int _getY(long var1);

    @Override
    protected native void _setParent(long var1, long var3);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native void _scheduleRepaint(long var1);

    @Override
    protected void _begin(long l) {
    }

    @Override
    protected void _end(long l) {
    }

    @Override
    protected void _uploadPixels(long l, Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (buffer.isDirect()) {
            this._uploadPixelsDirect(l, buffer, pixels.getWidth(), pixels.getHeight());
        } else if (buffer.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                this._uploadPixelsByteArray(l, byteBuffer.array(), byteBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                this._uploadPixelsIntArray(l, intBuffer.array(), intBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            }
        } else {
            this._uploadPixelsDirect(l, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight());
        }
    }

    private native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5);

    private native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6);

    private native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6);

    @Override
    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    @Override
    protected native void _exitFullscreen(long var1, boolean var3);

    @Override
    protected void _finishInputMethodComposition(long l) {
        if (this.imEnabled) {
            this.enableInputMethodEventsImpl(l, true);
        }
    }

    protected double[] notifyInputMethodCandidateRelativePosRequest(int n) {
        return this.convertPosToRelative(super.notifyInputMethodCandidatePosRequest(n));
    }

    private double[] convertPosToRelative(double[] dArray) {
        Window window = this.getWindow();
        if (window != null) {
            dArray[0] = dArray[0] - (double)(window.getX() + this.getX());
            dArray[1] = dArray[1] - (double)(window.getY() + this.getY());
        }
        return dArray;
    }

    protected void notifyInputMethodLinux(String string, int n, int n2, byte by) {
        if (n > 0) {
            this.notifyInputMethod(string, null, null, null, n, n2, 0);
        } else {
            int[] nArray = new int[]{0, string.length()};
            byte[] byArray = new byte[]{by};
            this.notifyInputMethod(string, nArray, nArray, byArray, 0, n2, 0);
        }
    }
}

