/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext.rtf;

import com.sun.jfx.incubator.scene.control.richtext.SegmentStyledInput;
import com.sun.jfx.incubator.scene.control.richtext.rtf.AttrSet;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFAttribute;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFAttributes;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFParser;
import com.sun.jfx.incubator.scene.control.richtext.rtf.Style;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class RTFReader
extends RTFParser {
    private static final Object STYLE_TYPE = new Object();
    private static final Object STYLE_SECTION = new Object();
    private static final Object STYLE_PARAGRAPH = new Object();
    private static final Object STYLE_CHARACTER = new Object();
    private static final Object STYLE_NEXT = new Object();
    private static final Object STYLE_ADDITIVE = new Object();
    private static final Object STYLE_HIDDEN = new Object();
    private final String text;
    private ArrayList<StyledSegment> segments;
    private HashMap<Object, Object> parserState;
    private Destination rtfDestination;
    private AttrSet documentAttributes;
    private HashMap<Integer, String> fontTable;
    private Color[] colorTable;
    private HashMap<Integer, Style> characterStyles;
    private HashMap<Integer, Style> paragraphStyles;
    private HashMap<Integer, Style> sectionStyles;
    private boolean ignoreGroupIfUnknownKeyword;
    private int skippingCharacters;
    private final AttrSet.Holder holder = new AttrSet.Holder();
    private static final String DEFAULT_STYLE = "default";
    private final HashMap<String, Style> styles = this.initStyles();
    private static final HashMap<String, RTFAttribute> straightforwardAttributes = RTFAttributes.attributesByKeyword();
    private static final HashMap<String, String> textKeywords = RTFReader.initTextKeywords();
    private static final HashMap<String, char[]> characterSets = RTFReader.initCharacterSets();

    public RTFReader(String string) {
        this.text = string;
        this.parserState = new HashMap();
        this.fontTable = new HashMap();
        this.documentAttributes = new AttrSet();
    }

    public StyledInput generateStyledInput() throws IOException {
        if (this.segments == null) {
            this.segments = new ArrayList();
            this.readFromReader(new StringReader(this.text));
        }
        return SegmentStyledInput.of(this.segments);
    }

    private static HashMap<String, String> initTextKeywords() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("\\", "\\");
        hashMap.put("{", "{");
        hashMap.put("}", "}");
        hashMap.put(" ", "\u00a0");
        hashMap.put("~", "\u00a0");
        hashMap.put("_", "\u2011");
        hashMap.put("bullet", "\u2022");
        hashMap.put("emdash", "\u2014");
        hashMap.put("emspace", "\u2003");
        hashMap.put("endash", "\u2013");
        hashMap.put("enspace", "\u2002");
        hashMap.put("ldblquote", "\u201c");
        hashMap.put("lquote", "\u2018");
        hashMap.put("ltrmark", "\u200e");
        hashMap.put("rdblquote", "\u201d");
        hashMap.put("rquote", "\u2019");
        hashMap.put("rtlmark", "\u200f");
        hashMap.put("tab", "\t");
        hashMap.put("zwj", "\u200d");
        hashMap.put("zwnj", "\u200c");
        hashMap.put("-", "\u2027");
        return hashMap;
    }

    private static HashMap<String, char[]> initCharacterSets() {
        HashMap<String, char[]> hashMap = new HashMap<String, char[]>();
        hashMap.put("ansicpg", latin1TranslationTable);
        return hashMap;
    }

    private HashMap<String, Style> initStyles() {
        HashMap<String, Style> hashMap = new HashMap<String, Style>();
        hashMap.put(DEFAULT_STYLE, new Style());
        return hashMap;
    }

    private Style addStyle(String string, Style style) {
        Style style2 = new Style();
        style2.setResolveParent(style);
        this.styles.put(string, style2);
        return style2;
    }

    private Style getDefaultStyle() {
        return this.styles.get(DEFAULT_STYLE);
    }

    @Override
    public void handleBinaryBlob(byte[] byArray) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    @Override
    public void handleText(String string) {
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= string.length()) {
                this.skippingCharacters -= string.length();
                return;
            }
            string = string.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(string);
            return;
        }
    }

    @Override
    public void begingroup() {
        Object object;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((object = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        HashMap hashMap = (HashMap)this.parserState.clone();
        if (object != null) {
            hashMap.put("_savedState", object);
        }
        this.parserState.put("_savedState", hashMap);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    @Override
    public void endgroup() {
        HashMap hashMap;
        Destination destination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((destination = (Destination)(hashMap = (HashMap)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = destination;
        }
        HashMap<Object, Object> hashMap2 = this.parserState;
        this.parserState = hashMap;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(hashMap2);
        }
    }

    protected void setRTFDestination(Destination destination) {
        HashMap hashMap = (HashMap)this.parserState.get("_savedState");
        if (hashMap != null && this.rtfDestination != hashMap.get("dst")) {
            this.rtfDestination.close();
        }
        this.rtfDestination = destination;
        this.parserState.put("dst", this.rtfDestination);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public boolean handleKeyword(String string) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        String string2 = textKeywords.get(string);
        if (string2 != null) {
            this.handleText(string2);
            return true;
        }
        if (string.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination());
            return true;
        }
        if (string.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination());
            return true;
        }
        if (string.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination());
            return true;
        }
        if (string.equals("info")) {
            this.setRTFDestination(new Destination());
            return false;
        }
        if (string.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (string.equals("ansi")) {
            this.setCharacterSet("ansi");
            return true;
        }
        if (string.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (string.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (string.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (string.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string)) {
            return true;
        }
        switch (string) {
            case "aftncn": 
            case "aftnsep": 
            case "aftnsepc": 
            case "annotation": 
            case "atnauthor": 
            case "atnicn": 
            case "atnid": 
            case "atnref": 
            case "atntime": 
            case "atrfend": 
            case "atrfstart": 
            case "bkmkend": 
            case "bkmkstart": 
            case "datafield": 
            case "do": 
            case "dptxbxtext": 
            case "falt": 
            case "field": 
            case "file": 
            case "filetbl": 
            case "fname": 
            case "fontemb": 
            case "fontfile": 
            case "footer": 
            case "footerf": 
            case "footerl": 
            case "footerr": 
            case "footnote": 
            case "ftncn": 
            case "ftnsep": 
            case "ftnsepc": 
            case "header": 
            case "headerf": 
            case "headerl": 
            case "headerr": 
            case "keycode": 
            case "nextfile": 
            case "object": 
            case "pict": 
            case "pn": 
            case "pnseclvl": 
            case "pntxtb": 
            case "pntxta": 
            case "revtbl": 
            case "rxe": 
            case "tc": 
            case "template": 
            case "txe": 
            case "xe": {
                bl = true;
            }
        }
        if (bl) {
            this.setRTFDestination(new Destination());
        }
        return false;
    }

    @Override
    public boolean handleKeyword(String string, int n) {
        boolean bl = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (string.equals("uc")) {
            this.parserState.put("UnicodeSkip", n);
            return true;
        }
        if (string.equals("u")) {
            if (n < 0) {
                n += 65536;
            }
            this.handleText((char)n);
            Number number = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = number != null ? number.intValue() : 1;
            return true;
        }
        if (string.equals("rtf")) {
            this.setRTFDestination(new DocumentDestination());
            return true;
        }
        if (string.startsWith("NeXT") || string.equals("private")) {
            bl = true;
        }
        if (string.contains("ansicpg")) {
            this.setCharacterSet("ansicpg");
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(string, n)) {
            return true;
        }
        if (bl) {
            this.setRTFDestination(new Destination());
        }
        return false;
    }

    public void setCharacterSet(String string) {
        Object object;
        try {
            object = RTFReader.getCharacterSet(string);
        }
        catch (Exception exception) {
            object = null;
        }
        if (object != null) {
            this.translationTable = (char[])object;
        } else if (!string.equals("ansi")) {
            try {
                this.translationTable = (char[])RTFReader.getCharacterSet("ansi");
            }
            catch (IOException iOException) {
                throw new InternalError("RTFReader: Unable to find character set resources (" + String.valueOf(iOException) + ")", iOException);
            }
        }
    }

    private static void defineCharacterSet(String string, char[] cArray) {
        if (cArray.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(string, cArray);
    }

    public static Object getCharacterSet(String string) throws IOException {
        char[] cArray = characterSets.get(string);
        if (cArray == null) {
            try (InputStream inputStream = RTFReader.class.getResourceAsStream("charsets/" + string + ".txt");){
                cArray = RTFReader.readCharset(inputStream);
                RTFReader.defineCharacterSet(string, cArray);
            }
        }
        return cArray;
    }

    static char[] readCharset(InputStream inputStream) throws IOException {
        char[] cArray = new char[256];
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.ISO_8859_1));){
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.commentChar(35);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            for (int i = 0; i < 256; ++i) {
                int n;
                try {
                    n = streamTokenizer.nextToken();
                }
                catch (Exception exception) {
                    throw new IOException("Unable to read from character set file (" + String.valueOf(exception) + ")");
                }
                if (n != -2) {
                    throw new IOException("Unexpected token in character set file");
                }
                cArray[i] = (char)streamTokenizer.nval;
            }
        }
        return cArray;
    }

    static class Destination {
        Destination() {
        }

        public void handleBinaryBlob(byte[] byArray) {
        }

        public void handleText(String string) {
        }

        public boolean handleKeyword(String string) {
            return true;
        }

        public boolean handleKeyword(String string, int n) {
            return true;
        }

        public void begingroup() {
        }

        public void endgroup(Map<Object, Object> map) {
        }

        public void close() {
        }
    }

    class FonttblDestination
    extends Destination {
        private int nextFontNumber;
        private Integer fontNumberKey;
        private String nextFontFamily;

        FonttblDestination() {
        }

        @Override
        public void handleText(String string) {
            int n = string.indexOf(59);
            Object object = n > -1 ? string.substring(0, n) : string;
            if (this.nextFontNumber == -1 && this.fontNumberKey != null) {
                object = RTFReader.this.fontTable.get(this.fontNumberKey) + (String)object;
            } else {
                this.fontNumberKey = this.nextFontNumber;
            }
            RTFReader.this.fontTable.put(this.fontNumberKey, (String)object);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }

        @Override
        public boolean handleKeyword(String string) {
            if (string.charAt(0) == 'f') {
                this.nextFontFamily = string.substring(1);
                return true;
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            if (string.equals("f")) {
                this.nextFontNumber = n;
                return true;
            }
            return false;
        }
    }

    class ColortblDestination
    extends Destination {
        private int red;
        private int green;
        private int blue;
        private final ArrayList<Color> colors = new ArrayList();

        @Override
        public void handleText(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ';') continue;
                Color color = Color.rgb((int)this.red, (int)this.green, (int)this.blue);
                this.colors.add(color);
            }
        }

        @Override
        public void close() {
            int n = this.colors.size();
            RTFReader.this.colorTable = this.colors.toArray(new Color[n]);
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            switch (string) {
                case "red": {
                    this.red = n;
                    return true;
                }
                case "green": {
                    this.green = n;
                    return true;
                }
                case "blue": {
                    this.blue = n;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string) {
            return false;
        }
    }

    class StylesheetDestination
    extends Destination {
        private HashMap<Integer, StyleDefiningDestination> definedStyles = new HashMap();

        @Override
        public void begingroup() {
            RTFReader.this.setRTFDestination(new StyleDefiningDestination());
        }

        @Override
        public void close() {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap<Integer, Style> hashMap3 = new HashMap<Integer, Style>();
            for (StyleDefiningDestination styleDefiningDestination : this.definedStyles.values()) {
                Style style = styleDefiningDestination.realize();
                Object object = style.getAttribute(STYLE_TYPE);
                HashMap<Integer, Style> hashMap4 = object == STYLE_SECTION ? hashMap3 : (object == STYLE_CHARACTER ? hashMap : hashMap2);
                hashMap4.put(styleDefiningDestination.number, style);
            }
            if (!hashMap.isEmpty()) {
                RTFReader.this.characterStyles = hashMap;
            }
            if (!hashMap2.isEmpty()) {
                RTFReader.this.paragraphStyles = hashMap2;
            }
            if (!hashMap3.isEmpty()) {
                RTFReader.this.sectionStyles = hashMap3;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination {
            private static final int STYLENUMBER_NONE = 222;
            private boolean additive;
            private boolean characterStyle;
            private boolean sectionStyle;
            public String styleName;
            public int number;
            private int basedOn;
            private int nextStyle;
            private boolean hidden;
            private Style realizedStyle;

            StyleDefiningDestination() {
                this.basedOn = 222;
                this.nextStyle = 222;
            }

            @Override
            public void handleText(String string) {
                this.styleName = this.styleName != null ? this.styleName + string : string;
            }

            @Override
            public void close() {
                int n;
                int n2 = n = this.styleName == null ? 0 : this.styleName.indexOf(59);
                if (n > 0) {
                    this.styleName = this.styleName.substring(0, n);
                }
                StylesheetDestination.this.definedStyles.put(this.number, this);
                super.close();
            }

            @Override
            public boolean handleKeyword(String string) {
                switch (string) {
                    case "additive": {
                        this.additive = true;
                        return true;
                    }
                    case "shidden": {
                        this.hidden = true;
                        return true;
                    }
                }
                return super.handleKeyword(string);
            }

            @Override
            public boolean handleKeyword(String string, int n) {
                if (n > Short.MAX_VALUE) {
                    n = Short.MAX_VALUE;
                } else if (n < -32767) {
                    n = -32767;
                }
                switch (string) {
                    case "s": {
                        this.characterStyle = false;
                        this.sectionStyle = false;
                        this.number = n;
                        return true;
                    }
                    case "cs": {
                        this.characterStyle = true;
                        this.sectionStyle = false;
                        this.number = n;
                        return true;
                    }
                    case "ds": {
                        this.characterStyle = false;
                        this.sectionStyle = true;
                        this.number = n;
                        return true;
                    }
                    case "sbasedon": {
                        this.basedOn = n;
                        return true;
                    }
                    case "snext": {
                        this.nextStyle = n;
                        return true;
                    }
                }
                return super.handleKeyword(string, n);
            }

            public Style realize() {
                return this.realize(null);
            }

            private Style realize(Set<Integer> set) {
                StyleDefiningDestination styleDefiningDestination;
                Style style = null;
                Style style2 = null;
                if (set == null) {
                    set = new HashSet<Integer>();
                }
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && set.add(this.basedOn) && (styleDefiningDestination = StylesheetDestination.this.definedStyles.get(this.basedOn)) != null && styleDefiningDestination != this) {
                    style = styleDefiningDestination.realize(set);
                }
                this.realizedStyle = RTFReader.this.addStyle(this.styleName, style);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_CHARACTER);
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_SECTION);
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute(STYLE_TYPE, STYLE_PARAGRAPH);
                }
                if (this.nextStyle != 222 && (styleDefiningDestination = StylesheetDestination.this.definedStyles.get(this.nextStyle)) != null) {
                    style2 = styleDefiningDestination.realize();
                }
                if (style2 != null) {
                    this.realizedStyle.addAttribute(STYLE_NEXT, style2);
                }
                this.realizedStyle.addAttribute(STYLE_ADDITIVE, this.additive);
                this.realizedStyle.addAttribute(STYLE_HIDDEN, this.hidden);
                return this.realizedStyle;
            }
        }
    }

    class DocumentDestination
    extends AttributeTrackingDestination {
        private boolean inParagraph;

        public void deliverText(String string, AttrSet attrSet) {
            StyleAttributeMap styleAttributeMap = attrSet.getStyleAttributeMap();
            StyledSegment styledSegment = StyledSegment.of(string, styleAttributeMap);
            RTFReader.this.segments.add(styledSegment);
        }

        public void finishParagraph(AttrSet attrSet, AttrSet attrSet2) {
            RTFReader.this.segments.add(StyledSegment.LINE_BREAK);
        }

        protected void endSection() {
        }

        @Override
        public void handleText(String string) {
            if (!this.inParagraph) {
                this.beginParagraph();
            }
            this.deliverText(string, this.currentTextAttributes());
        }

        @Override
        public void close() {
            if (this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        @Override
        public boolean handleKeyword(String string) {
            switch (string) {
                case "\r": 
                case "\n": 
                case "par": {
                    this.endParagraph();
                    return true;
                }
                case "sect": {
                    this.endSection();
                    return true;
                }
            }
            return super.handleKeyword(string);
        }

        protected void beginParagraph() {
            this.inParagraph = true;
        }

        protected void endParagraph() {
            AttrSet attrSet = this.currentParagraphAttributes();
            AttrSet attrSet2 = this.currentTextAttributes();
            this.finishParagraph(attrSet, attrSet2);
            this.inParagraph = false;
        }
    }

    abstract class AttributeTrackingDestination
    extends Destination {
        private AttrSet characterAttributes = this.rootCharacterAttributes();
        private AttrSet paragraphAttributes;
        private AttrSet sectionAttributes;

        @Override
        public abstract void handleText(String var1);

        public AttributeTrackingDestination() {
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public void begingroup() {
            AttrSet attrSet = this.currentTextAttributes();
            AttrSet attrSet2 = this.currentParagraphAttributes();
            AttrSet attrSet3 = this.currentSectionAttributes();
            this.characterAttributes = new AttrSet();
            this.characterAttributes.addAttributes(attrSet);
            RTFReader.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new AttrSet();
            this.paragraphAttributes.addAttributes(attrSet2);
            RTFReader.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new AttrSet();
            this.sectionAttributes.addAttributes(attrSet3);
            RTFReader.this.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public void endgroup(Map<Object, Object> map) {
            this.characterAttributes = (AttrSet)RTFReader.this.parserState.get("chr");
            this.paragraphAttributes = (AttrSet)RTFReader.this.parserState.get("pgf");
            this.sectionAttributes = (AttrSet)RTFReader.this.parserState.get("sec");
        }

        @Override
        public boolean handleKeyword(String string) {
            if (string.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            Object object = straightforwardAttributes.get(string);
            if (object != null) {
                int n;
                switch (((RTFAttribute)object).domain()) {
                    case 0: {
                        n = ((RTFAttribute)object).set(this.characterAttributes) ? 1 : 0;
                        break;
                    }
                    case 1: {
                        n = ((RTFAttribute)object).set(this.paragraphAttributes) ? 1 : 0;
                        break;
                    }
                    case 2: {
                        n = ((RTFAttribute)object).set(this.sectionAttributes) ? 1 : 0;
                        break;
                    }
                    case 4: {
                        RTFReader.this.holder.backing = RTFReader.this.parserState;
                        n = ((RTFAttribute)object).set(RTFReader.this.holder) ? 1 : 0;
                        RTFReader.this.holder.backing = null;
                        break;
                    }
                    case 3: {
                        n = ((RTFAttribute)object).set(RTFReader.this.documentAttributes) ? 1 : 0;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                if (n != 0) {
                    return true;
                }
            }
            switch (string) {
                case "plain": {
                    this.resetCharacterAttributes();
                    return true;
                }
                case "pard": {
                    this.resetParagraphAttributes();
                    return true;
                }
                case "sectd": {
                    this.resetSectionAttributes();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String string, int n) {
            if (string.equals("fc")) {
                string = "cf";
            }
            switch (string) {
                case "f": {
                    RTFReader.this.parserState.put(string, n);
                    return true;
                }
                case "cf": {
                    RTFReader.this.parserState.put(string, n);
                    return true;
                }
                case "cb": {
                    RTFReader.this.parserState.put(string, n);
                    return true;
                }
            }
            Object object = straightforwardAttributes.get(string);
            if (object != null) {
                int n2;
                switch (((RTFAttribute)object).domain()) {
                    case 0: {
                        n2 = ((RTFAttribute)object).set(this.characterAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 1: {
                        n2 = ((RTFAttribute)object).set(this.paragraphAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 2: {
                        n2 = ((RTFAttribute)object).set(this.sectionAttributes, n) ? 1 : 0;
                        break;
                    }
                    case 4: {
                        RTFReader.this.holder.backing = RTFReader.this.parserState;
                        n2 = ((RTFAttribute)object).set(RTFReader.this.holder, n) ? 1 : 0;
                        RTFReader.this.holder.backing = null;
                        break;
                    }
                    case 3: {
                        n2 = ((RTFAttribute)object).set(RTFReader.this.documentAttributes, n) ? 1 : 0;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                if (n2 != 0) {
                    return true;
                }
            }
            switch (string) {
                case "fs": {
                    this.characterAttributes.addAttribute(StyleAttributeMap.FONT_SIZE, n / 2);
                    return true;
                }
            }
            if (string.equals("s") && RTFReader.this.paragraphStyles != null) {
                RTFReader.this.parserState.put("paragraphStyle", RTFReader.this.paragraphStyles.get(n));
                return true;
            }
            if (string.equals("cs") && RTFReader.this.characterStyles != null) {
                RTFReader.this.parserState.put("characterStyle", RTFReader.this.characterStyles.get(n));
                return true;
            }
            if (string.equals("ds") && RTFReader.this.sectionStyles != null) {
                RTFReader.this.parserState.put("sectionStyle", RTFReader.this.sectionStyles.get(n));
                return true;
            }
            return false;
        }

        protected AttrSet rootCharacterAttributes() {
            AttrSet attrSet = new AttrSet();
            attrSet.setItalic(false);
            attrSet.setBold(false);
            attrSet.setUnderline(false);
            attrSet.setForeground(Color.BLACK);
            return attrSet;
        }

        protected AttrSet rootParagraphAttributes() {
            AttrSet attrSet = new AttrSet();
            attrSet.setLeftIndent(0.0);
            attrSet.setRightIndent(0.0);
            attrSet.setFirstLineIndent(0.0);
            attrSet.setResolveParent(RTFReader.this.getDefaultStyle());
            return attrSet;
        }

        protected AttrSet rootSectionAttributes() {
            AttrSet attrSet = new AttrSet();
            return attrSet;
        }

        AttrSet currentTextAttributes() {
            Color color;
            Object object;
            AttrSet attrSet = new AttrSet(this.characterAttributes);
            Integer n = (Integer)RTFReader.this.parserState.get("f");
            String string = n != null ? RTFReader.this.fontTable.get(n) : null;
            attrSet.setFontFamily(string);
            if (RTFReader.this.colorTable != null) {
                object = (Integer)RTFReader.this.parserState.get("cf");
                if (object != null) {
                    color = RTFReader.this.colorTable[(Integer)object];
                    attrSet.setForeground(color);
                } else {
                    attrSet.setForeground(null);
                }
            }
            if (RTFReader.this.colorTable != null) {
                object = (Integer)RTFReader.this.parserState.get("cb");
                if (object != null) {
                    color = RTFReader.this.colorTable[(Integer)object];
                    attrSet.setBackground(color);
                } else {
                    attrSet.setBackground(null);
                }
            }
            if ((object = (Style)RTFReader.this.parserState.get("characterStyle")) != null) {
                attrSet.setResolveParent((AttrSet)object);
            }
            return attrSet;
        }

        AttrSet currentParagraphAttributes() {
            AttrSet attrSet = new AttrSet(this.paragraphAttributes);
            Style style = (Style)RTFReader.this.parserState.get("paragraphStyle");
            if (style != null) {
                attrSet.setResolveParent(style);
            }
            return attrSet;
        }

        public AttrSet currentSectionAttributes() {
            AttrSet attrSet = new AttrSet(this.sectionAttributes);
            Style style = (Style)RTFReader.this.parserState.get("sectionStyle");
            if (style != null) {
                attrSet.setResolveParent(style);
            }
            return attrSet;
        }

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 0) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            RTFReader.this.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            RTFReader.this.parserState.remove("_tabs");
            RTFReader.this.parserState.remove("_tabs_immutable");
            RTFReader.this.parserState.remove("paragraphStyle");
            this.paragraphAttributes.setAlignment(TextAlignment.LEFT);
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 1) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            for (RTFAttribute rTFAttribute : straightforwardAttributes.values()) {
                if (rTFAttribute.domain() != 2) continue;
                rTFAttribute.setDefault(this.characterAttributes);
            }
            RTFReader.this.parserState.remove("sectionStyle");
        }
    }
}

