#!/usr/bin/perl
use threads;
use threads::shared;
use IO::Socket::INET;
use Getopt::Long qw(GetOptions);
use POSIX qw(setsid strftime);
use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::MsgBox;
require Tk::Dialog;


# ------- global variables declaration ----------------
my @ProtosTestList = ("SIP-Method (1-193)","SIP-Request-URI (194-254)","SIP-Version (255-329)","SIP-Via-Host (330-435)","SIP-Via-Hostcolon (436-451)","SIP-Via-Version (498-572)","SIP-Via-Tag (573-629)","SIP-From-Displayname (630-822)","SIP-From-Tag (823-879)","SIP-From-Colon (880-895)","SIP-From-URI (896-956)","SIP-Contact-Displayname (957-1149)","SIP-Contact-URI (1150-1210)","SIP-Contact-Left-Paranthesis (1211-1226)","SIP-Contact-Right-Paranthesis (1227-1242)","SIP-To (1243-1435)","SIP-To-Left-Paranthesis (1436-1451)","SIP-To-Right-Paranthesis (1452-1467)","SIP-Call-Id-Value (1468-1660)","SIP-Call-Id-At (1661-1676)","SIP-Call-Id-Ip 1677-1783","SIP-Expires 1783-1828","SIP-Max-Forwards 1829-1874","SIP-Cseq-Integer 1875-1920","SIP-Cseq-String 1921-2113","SIP-Content-Type 2114-2360","SIP-Content-Length (2361-2406)","IP-Request-CRLF (2407-2416)","CRLF-Request (2417-2426)","SDP-Attribute-CRLF (2427-2436)","SDP-Proto-v-Identifier (2437-2629)","SDP-Proto-v-Equal (2630-2645)","SDP-Proto-v-Integer (2646-2691)","SDP-Origin-Username (2692-2884)","SDP-Origin-Sessionid (2885-2930)","SDP-Origin-Networktype (2931-3123)","SDP-Origin-Ip (3124-3229)","SDP-Session (3230-3422)","SDP-Connection-Networktype (3423-3610)","SDP-Connection-Ip (3611-3716)","SDP-Time-Start (3717-3762)","SDP-Time-Stop (3763)","SDP-Media-Media (3764-3956)","SDP-Media-Port (3957-4002)","SDP-Media-Transport (4003-4120)","SDP-Media-Type (4121-4166)","SDP-Attribute-Rtpmap (4167-4284)","SDP-Attribute-Colon (4285-4300)","SDP-Attribute-Payloadtype (4301-4346)","SDP-Attribute-Encodingname (4347-4464)","SDP-Attribute-Slash (4465-4480)","SDP-Attribute-Clockrate (4481-4527)");
@ProtosFuzzingType=("No","Yes");

#-------- GUI creation --------------------------------

my $subweb_mw = MainWindow->new(
						-title => 'SIP Fuzzing (protos)');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
		
$file_mb->command(
		-label=>'Launch fuzzing session',
		-command => sub{&LAUNCH_FUZZING}
		);

$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		

#-------------DEFAULT WIDTH 79 --------------
my $FrameTOP = $subweb_mw -> Frame ();
$FrameTOP->Label(
	-text => 'Target IP Address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel = $FrameTOP -> Entry(
	-width   => 40,
	-textvariable => \$AddressToFuzz
	)->pack(-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');

#-------------DEFAULT WIDTH 79 --------------
my $Frame6 = $subweb_mw -> Frame ();
$Frame6->Label(
	-text => 'Select fuzzing method:               '
	)->pack(-side => 'left');

my $FuzzingType = 'type_2';
$Frame6->Radiobutton(-text => 'Yes (All fuzzing cases)', -variable => \$FuzzingType,
			-value => "type_1"
			 )->pack(-side => 'left');
$Frame6->Radiobutton(-text => 'No (Selected fuzzing cases)', -variable => \$FuzzingType,
			-value => "type_2"
			)->pack(-side => 'left');			
$Frame6 -> pack (-side => 'top', -anchor => 'w');			

#-------------DEFAULT WIDTH 79 --------------
my $Frame11 = $subweb_mw -> Frame ();
$Frame11->Label(
	-text => 'Select fuzzing method:               '
	)->pack(-side => 'left');
my $Lbox11 = $Frame11 -> Listbox (
	-height  => 10,
	-width   => 40,
	-selectmode => 'single',
	);	
$Frame11 -> pack (-side => 'top', -anchor => 'w');
$Lbox11->insert('end', @ProtosTestList );
$Lbox11->selectionSet(1);

my $scroll11 = $Frame11->Scrollbar(-command => ['yview', $Lbox11]);
$Lbox11->configure(-yscrollcommand => ['set', $scroll11]);
$Lbox11->pack(-side => 'left', -fill => 'both', -expand => 1);
$scroll11->pack(-side => 'right', -fill => 'y');
$Frame11 -> pack (-side => 'top', -anchor => 'w');
#-------------
my $FrameMIDDLE4 = $subweb_mw -> Frame (-width => 40, -height => 13);

$TextWidget = $FrameMIDDLE4->Text(); 
$TextWidget->configure(-height => 20);
my $scrollbar = $FrameMIDDLE4 ->Scrollbar(-command => ['yview', $TextWidget]);

$TextWidget->configure(-yscrollcommand => ['set', $scrollbar]);
$TextWidget->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar->pack(-side => 'right', -fill => 'y');

$FrameMIDDLE4 -> pack (-side => 'top', -anchor => 'w');

$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
$TextWidget->insert ("end","Detail of fuzzing cases can be found either in ISME documentation or on PROTOS\n web site (https://www.ee.oulu.fi/research/ouspg/PROTOS_Test-Suite_c07-sip)\n");	
$TextWidget->update();
$TextWidget->see ('end');

#------------ LAUNCHING THE MAIN LOOP --------
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------
sub LAUNCH_FUZZING()
{
	my $commande = "";
	my $Result = "";
	@index = $Lbox11->curselection();
	my $src_port = rand(65534)+1;
	my $src_addr = &RANDOMIP();
	$TextWidget->delete ('0.0','end');	
	
	if ($FuzzingType eq "type_2")
	{
		$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
		$TextWidget->insert ("end","Start SIP fuzzing session (with PROTOS)\n\n");	
		$TextWidget->update();
		$TextWidget->see ('end');
		if (@index[0] == 0)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1 -stop 193";
		}
		elsif (@index[0] == 1)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 194 -stop 254";
	
		}
		elsif (@index[0] == 2)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 255 -stop 329";
	
		}
		elsif (@index[0] == 3)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 330 -stop 435";
	
		}
		elsif (@index[0] == 4)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 436 -stop 451";
	
		}
		elsif (@index[0] == 5)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 452 -stop 572";
	
		}
		elsif (@index[0] == 6)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 573 -stop 629";
	
		}
		elsif (@index[0] == 7)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 630 -stop 822";
	
		}
		elsif (@index[0] == 8)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 823 -stop 879";
	
		}
		elsif (@index[0] == 9)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 880 -stop 895";
	
		}
		elsif (@index[0] == 10)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 896 -stop 956";
	
		}
		elsif (@index[0] == 11)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 957 -stop 1149";
	
		}
		elsif (@index[0] == 12)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1150 -stop 1210";
	
		}
		elsif (@index[0] == 13)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1211 -stop 1226";
	
		}
		elsif (@index[0] == 14)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1227 -stop 1242";
	
		}
		elsif (@index[0] == 15)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1243 -stop 1435";
	
		}
		elsif (@index[0] == 16)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1436 -stop 1451";
	
		}
		elsif (@index[0] == 17)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1452 -stop 1467";
	
		}
		elsif (@index[0] == 18)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1468 -stop 1660";
	
		}
		elsif (@index[0] == 19)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1661 -stop 1676";
	
		}
		elsif (@index[0] == 20)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1677 -stop 1783";
	
		}
		elsif (@index[0] == 21)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1784 -stop 1828";
	
		}
		elsif (@index[0] == 22)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1829 -stop 1874";
	
		}
		elsif (@index[0] == 23)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1875 -stop 1920";
	
		}
		elsif (@index[0] == 24)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1921 -stop 2113";
	
		}
		elsif (@index[0] == 25)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2114 -stop 2360";
	
		}
		elsif (@index[0] == 26)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2361 -stop 2406";
	
		}
		elsif (@index[0] == 27)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2407 -stop 2416";
	
		}
		elsif (@index[0] == 28)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2417 -stop 2426";
	
		}
		elsif (@index[0] == 29)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2427 -stop 2436";
	
		}
		elsif (@index[0] == 30)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2437 -stop 2629";
	
		}
		elsif (@index[0] == 31)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2630 -stop 2645";
	
		}
		elsif (@index[0] == 32)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2646 -stop 2691";
	
		}
		elsif (@index[0] == 33)
		{
			$commande ="sudo java -jar c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2692 -stop 2884";
	
		}
		elsif (@index[0] == 34)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2885 -stop 2930";
	
		}
		elsif (@index[0] == 35)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2931 -stop 3123";
	
		}
		elsif (@index[0] == 36)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3124 -stop 3229";
	
		}
		elsif (@index[0] == 37)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3230 -stop 3422";
	
		}
		elsif (@index[0] == 38)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3423 -stop 3610";
	
		}
		elsif (@index[0] == 39)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3611 -stop 3716";
	
		}
		elsif (@index[0] == 40)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3717 -stop 3762";
	
		}
		elsif (@index[0] == 41)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3763 -stop 3763";
	
		}
		elsif (@index[0] == 42)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3764 -stop 3956";
	
		}
		elsif (@index[0] == 43)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3957 -stop 4002";
	
		}
		elsif (@index[0] == 44)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4003 -stop 4120";
	
		}
		elsif (@index[0] == 45)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4121 -stop 4166";
	
		}
		elsif (@index[0] == 46)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4167 -stop 4284";
	
		}
		elsif (@index[0] == 47)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4285 -stop 4300";
	
		}
		elsif (@index[0] == 48)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4301 -stop 4346";
	
		}
		elsif (@index[0] == 49)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4347 -stop 4464";
	
		}
		elsif (@index[0] == 50)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4465 -stop 4480";
	
		}
		elsif (@index[0] == 51)
		{
			$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4481 -stop 4527";
	
		}
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->insert ("end","End of SIP fuzzing session\n");	
		$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
		$TextWidget->update();
		$TextWidget  -> see ('end');
	}
	elsif ($FuzzingType eq "type_1")
	{
		$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
		$TextWidget->insert ("end","Start SIP fuzzing session (with PROTOS)\n\n");	
		$TextWidget->insert ("end","Be patient, there is 4527 cases to execute.\n\n");	
		$TextWidget->update();
		$TextWidget->see ('end');
		
#		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr;		
#		$result = `$commande`;
		
		
		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1 -stop 500";		
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 501 -stop 1000";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1001 -stop 1500";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 1501 -stop 2000";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2001 -stop 2500";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 2501 -stop 3000";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3001 -stop 3500";
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 3501 -stop 4000";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");		
		$TextWidget->update();
		$TextWidget  -> see ('end');		

		$commande ="sudo java -jar tools/c07-sip-r2.jar -touri sip@".$AddressToFuzz." -fromuri isme@".$src_addr." -start 4001 -stop 4527";	
		$result = "";
		$result = `$commande`;
		$TextWidget->insert ("end","\n$result\n");
		$TextWidget->insert ("end","End of SIP fuzzing session\n");			
		$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
		$TextWidget->update();
		$TextWidget  -> see ('end');		
											
	}
}

sub RANDOMIP()
{
	$range = 255;
	$iA = int(rand($range));
	$iB = int(rand($range));
	$iC = int(rand($range));
	$iD = int(rand($range));
	
	return $iA.".".$iB.".".$iC.".".$iD;
}

sub STOP_FLOOD()
{
	$StopFlood=1;
	$TextWidget->insert ("end","\nStop flooding on TCP Port: $ActivePort \n");		
	$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
	$TextWidget->update();
	$TextWidget  -> see ('end');
}



