# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------
# STEP TO RESPECT TO BE COMPLETE
#
# OK/NOK- Present script test and completed (include explanation)
# OK- Launcher tool/exploit menu modified
# OK- Launcher editor menu modified
# OK/NOK- Documentation uadated
#
# --------------------------------------------------------


use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::Photo;
use Tk::JPEG;
use Tk::NoteBook;
use Tk::ProgressBar;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Request::Common; #http://search.cpan.org/~gaas/HTTP-Message-6.02/lib/HTTP/Request/Common.pm 
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;
use IO::Socket::INET;
use IO::Select;
use Socket;
use Digest::MD5 qw(md5 md5_hex md5_base64);
use Net::SSH::Expect;


# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "single";
my $IpAddress = "";
my $IpAddress_single = "";
my $IpAddress_sub = "";
my $SubnetToScan = "";
my $Results = "";

my $SipType = "udp";

my $ipdest ="";
my $sipoption = "";
my $answer ="";#variable destiné à recevoir la réponse de la machine interrogées.
my $GlobalCounter = 0;
my $NoSIPAnswerCounter = 0;
my $SIPAnswerCounter = 0;
my $SIPDetermined = 0;


my @colors = (  0, '#ff002a',  1, '#ff0014',  2, '#ff000a',  3, '#ff0500',  4, '#ff1000',
	     5, '#ff1b00',  6, '#ff3000',  7, '#ff3b00',  8, '#ff4600',  9, '#ff5100',
	    10, '#ff6100', 11, '#ff7600', 12, '#ff8100', 13, '#ff8c00', 14, '#ff9700',
	    15, '#ffa100', 16, '#ffbc00', 17, '#ffc700', 18, '#ffd200', 19, '#ffdd00',
	    20, '#ffe700', 21, '#fffd00', 22, '#f0ff00', 23, '#e5ff00', 24, '#dbff00',
	    25, '#d0ff00', 26, '#baff00', 27, '#afff00', 28, '#9fff00', 29, '#95ff00',
	    30, '#8aff00', 31, '#74ff00', 32, '#6aff00', 33, '#5fff00', 34, '#54ff00',
	    35, '#44ff00', 36, '#2eff00', 37, '#24ff00', 38, '#19ff00', 39, '#0eff00',
	    40, '#03ff00', 41, '#00ff17', 42, '#00ff21', 43, '#00ff2c', 44, '#00ff37',
	    45, '#00ff42', 46, '#00ff57', 47, '#00ff67', 48, '#00ff72', 49, '#00ff7d',
	    50, '#00ff87', 51, '#00ff9d', 52, '#00ffa8', 53, '#00ffb8', 54, '#00ffc3',
	    55, '#00ffcd', 56, '#00ffe3', 57, '#00ffee', 58, '#00fff8', 59, '#00faff',
	    60, '#00eaff', 61, '#00d4ff', 62, '#00c9ff', 63, '#00bfff', 64, '#00b4ff',
	    65, '#00a9ff', 66, '#008eff', 67, '#0083ff', 68, '#0079ff', 69, '#006eff',
	    70, '#0063ff', 71, '#004eff', 72, '#003eff', 73, '#0033ff', 74, '#0028ff',
	    75, '#001dff', 76, '#0008ff', 77, '#0200ff', 78, '#1200ff', 79, '#1d00ff',
	    80, '#2800ff', 81, '#3d00ff', 82, '#4800ff', 83, '#5300ff', 84, '#5d00ff',
	    85, '#6e00ff', 86, '#8300ff', 87, '#8e00ff', 88, '#9900ff', 89, '#a300ff',
	    90, '#ae00ff', 91, '#c900ff', 92, '#d400ff', 93, '#df00ff', 94, '#e900ff',
	    95, '#f400ff', 96, '#ff00f3', 97, '#ff00e3', 98, '#ff00d9', 99, '#ff00ce' );

	
my $subweb_mw = MainWindow->new(
						-title => 'SIP Scanner');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Scanning tool details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch tool',
		-command => 
			sub {&LAUNCH}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		#------------- Button menu --------------
my $FrameButton = $subweb_mw -> Frame ();

my $ImageDetail = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_oeil.jpg",
									 );									 
my $ImageLaunch = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_launch.jpg",
									 );									 
my $ImageSave = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_save.jpg",
									 );		
my $ImageExit = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_exit.jpg",
									 );	
									 									 									 
my $ButtonDetail = $FrameButton->Button (
    								-image => $ImageDetail, 
								    -command => sub {&EXPLANATION}
									)->pack(-side => 'left');
my $ButtonLaunch = $FrameButton->Button (
    								-image => $ImageLaunch, 
								    -command => sub {&LAUNCH}
									)->pack(-side => 'left');
my $ButtonSave = $FrameButton->Button (
    								-image => $ImageSave, 
								    -command => sub {&SAVERESULTS}
									)->pack(-side => 'left');
my $ButtonExit = $FrameButton->Button (
    								-image => $ImageExit, 
								    -command => [$subweb_mw => 'destroy']
									)->pack(-side => 'right');									
																		
$FrameButton -> pack (-side => 'top', -anchor => 'w'); 	

#---------- LABEL FRAME CONFIGURE -------------------------------------
my $labeled_frame = $subweb_mw ->LabFrame(
										-label => "Configure",
                                   		-labelside => "acrosstop"
                                   		)->pack(-side => 'top', -anchor => 'w');

#----------
my $FrameTOP = $labeled_frame -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Subnet to test",
												-value=>"scan",
												-variable=>\$ScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $labeled_frame -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Subnet (192.168.1.0/24):            '
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$SubnetToScan,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single device to test",  
												-value=>"single",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $labeled_frame -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'Device IP Address (192.168.1.1):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$IpAddress_single,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');


#----------
my $FrameBottom = $labeled_frame -> Frame ();
my $rdb_udp = $FrameBottom  -> Radiobutton(-text=>"SIP over UDP",
												-value=>"udp",
												-variable=>\$SipType);
my $rdb_tcp = $FrameBottom  -> Radiobutton(-text=>"SIP over TCP",
												-value=>"tcp",
												-variable=>\$SipType);
#my $rdb_sips = $FrameBottom  -> Radiobutton(-text=>"SIP Encryption",
#												-value=>"sips",
#												-variable=>\$SipSecurity);
$rdb_udp -> pack (-side => 'left');
$rdb_tcp -> pack (-side => 'left');
#$rdb_sips -> pack (-side => 'left');
$FrameBottom -> pack (-side => 'top', -anchor => 'w');

#-------------PROGRESS BAR ----------------------------

$bar1 = $subweb_mw->ProgressBar( -borderwidth=>2, -blocks=>100, -gap=>0,
			  -troughcolor=>'white',-colors=>\@colors,
			  -length=>106 )->pack( -padx=>5, -pady=>5, -fill=>'x' );
#$bar1->value( 100 - $val );


#------------- TAB BOOK -------------------------------

my $FrameTab= $subweb_mw -> Frame (-width => 40, -height => 20);
my $book = $FrameTab->NoteBook()->pack( -fill=>'both', -expand=>1 );

$tab1 = $book->add( "Sheet 1", -label=>"Details");
$tab2 = $book->add( "Sheet 2", -label=>"Positive results" );
$tab3 = $book->add( "Sheet 3", -label=>"All logs");
$book->raise("Sheet 1");

my $TextWidget_tab1 = $tab1->Text(); 
$TextWidget_tab1 ->configure(-height => 28);
my $scrollbar_tab1 = $tab1 ->Scrollbar(-command => ['yview', $TextWidget_tab1 ]);
$TextWidget_tab1 ->configure(-yscrollcommand => ['set', $scrollbar_tab1]);

my $TextWidget_tab2 = $tab2->Text(); 
$TextWidget_tab2 ->configure(-height => 28);
my $scrollbar_tab2 = $tab2 ->Scrollbar(-command => ['yview', $TextWidget_tab2 ]);
$TextWidget_tab2 ->configure(-yscrollcommand => ['set', $scrollbar_tab2]);

my $TextWidget_tab3 = $tab3->Text(); 
$TextWidget_tab3 ->configure(-height => 28);
my $scrollbar_tab3 = $tab3 ->Scrollbar(-command => ['yview', $TextWidget_tab3 ]);
$TextWidget_tab3 ->configure(-yscrollcommand => ['set', $scrollbar_tab3]);


$TextWidget_tab1 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab2 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab3 ->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar_tab1->pack(-side => 'right', -fill => 'y');
$scrollbar_tab2->pack(-side => 'right', -fill => 'y');
$scrollbar_tab3->pack(-side => 'right', -fill => 'y');

$FrameTab -> pack (-side => 'top', -anchor => 'w');

#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------

sub LAUNCH
{
	# variable initialization
	$Results = "";
	$TextWidget_tab3 -> delete('0.0', 'end');
	$TextWidget_tab2 -> delete('0.0', 'end');
	$bar1->value(0);
	$book->raise("Sheet 3");

	if ($ScanType =~ /single/)
	{
		&SINGLE;	
	}
	elsif ($ScanType =~ /scan/)
	{
		&EXPLOITSUBNET;
	}
}

sub EXPLOITSUBNET
{
	# Subnet testing

	if ($SubnetToScan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{		
		$IpAddress_sub = $SubnetToScan;	

		&TESTDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SINGLE
{
	# Subnet testing
	
	if ($IpAddress_single =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		$IpAddress_sub=$IpAddress_single."/32";
		
		&TESTDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	


sub TESTDEFAULT
{
	# Subnet calculation and detail stuff
	my $sn = Net::Subnets->new;
   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
    my $lowIP = $$lowipref;
	my $highIP = $$highipref;
	my $listref = $sn->list( \( $lowIP, $highIP ) );# Creating a table with all the IP Address.

	# Creation of ICMP object.
	my $p=Net::Ping->new("icmp");

	# Progres bar stuff		
	my $counter_global = 0;#Used for progress bar measure
	my $counter_temp = 0;#Used for progress bar status
	my $percentage = 0;#Used for progress bar status
				
	# Calcultaion of the number of case to properly set the progress bar.
	foreach my $scan_count ( @{ $listref } ) 
	{
		$counter_global++;	
	}
		
		
	#----------------------------------------------------------------------
	# LAUNCHING OF THE EXPLOIT/TOOL. GUI HANDLING 
	#----------------------------------------------------------------------				
	$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");			
    $TextWidget_tab3 -> insert ("end","Launching SIP scanning\n");
	$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");		
	$TextWidget_tab3  -> update ();	
	$TextWidget_tab3  -> see ('end');

	$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");			
    $TextWidget_tab2 -> insert ("end","Launching SIP scanning\n");
	$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
	$TextWidget_tab2  -> update ();	
	$TextWidget_tab2  -> see ('end');
		
	$Results = $Results."-------------------------------------------------------------------------------\n";	
	$Results = $Results."Launching SIP scanning\n";	
	$Results = $Results."-------------------------------------------------------------------------------\n";	
		
	# END -----------------------------------------------------------------
		
		
						
	foreach my $scan_address ( @{ $listref } ) 
	{
		# Initialization.
		$ipdest = $scan_address;	

		my $ipsource="127.0.0.1";
		my $SIPOptionResult = "";
		my $PingAnswer = 0;
		my $UAAnswer = 0;
		my $HttpAnswer = 0;
		my $HttpsAnswer = 0;
		my $SSHAnswer = 0;
		my $TelnetAnswer = 0;
		
		my $port5060UDPfound == 0;
		my $port5060TCPfound == 0;
		
		$answer = "";
		$SaveResult = "";		
		    
		#---- START SIP PART ---------------------------------------------	

	    $TextWidget_tab3 -> insert ("end","------$ipdest: Identifying available services\n");
	    $TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
			
		$Results = $Results."------$IpAddress: Identifying available services\n";

		#------------------------------------
		# SIP tests.
		#------------------------------------

		if ($SipType =~ /udp/)
		{				
			#---UDP 5060---------------
			my $icmp_timeout=3;	
			
			my $icmp_sock = new IO::Socket::INET(Proto=>"icmp");
			my $read_set = new IO::Select();
			$read_set->add($icmp_sock);
				
			my $buf="hello";
			my $sock = new IO::Socket::INET(
				PeerAddr=>$ipdest,
		    	PeerPort=>"5060" ,
		    	Proto=>"udp");
			 # Send the buffer and close the UDP socket.
		    $sock->send("$buf");
		    close($sock);
		    
		    # Wait for incoming packets.
		    ($new_readable) = IO::Select->select($read_set, undef, undef, $icmp_timeout);
		    # Set the arrival flag.
		    $icmp_arrived = "0";
			
			# For every socket we had received packets (In our case only one - icmp_socket)
		    foreach $socket (@$new_readable)
		    {
		    	# If we have captured an icmp packages, Its probably "destination unreachable"
		        if ($socket == $icmp_sock)
		        {
		        	# Set the flag and clean the socket buffers
		            $icmp_arrived = "1";
		            $icmp_sock->recv($buffer,50,0);
		        }
		    }
		    if ( $icmp_arrived == "0" )
		    {
		         # print that UDP port 506O has been found.
		         $port5060UDPfound=1;
		    }
			# Close the icmp sock
			close($icmp_sock);
						
			#------------------------------------------------
			# Is there any answer to SIP OPTION request ?
			#------------------------------------------------		
	
			if ($port5060UDPfound == 1)
			{

				my $sock_udp = new IO::Socket::INET ( 
											LocalPort => '8888',
				                            PeerAddr => $ipdest,
						                    PeerPort => '5060',
											Proto => 'udp',
											Timeout => 3,
												); 
							die unless $sock_udp;			
				#--DEBUG------------------------------------------------
				# 2- Envoi du paquet SIP\n";
				#--DEBUG------------------------------------------------		
				my $callid = md5_base64("$ipsource:$ipdest");
				$callid =~ s/[^a-zA-Z1-9]//g;
				my $fromtag = 1000000000 + int(rand(1000000000));
				my $cseq = 60000 + int(rand(5001));
				my $branch = md5_base64("$callid");
				$branch =~ s/[^a-zA-Z1-9]//g;
					
				$sipoption = "OPTIONS sip:user\@$ipdest SIP/2.0\n";
				$sipoption = $sipoption."From: \"isme\" <sip:isme\@$ipsource>;tag=$fromtag\n";
				$sipoption = $sipoption."Via: SIP/2.0/udp $ipsource:5060;branch=$branch\n";
				$sipoption = $sipoption."To: <sip:user\@$ipdest:5060>\n";
				$sipoption = $sipoption."Contact: <sip:isme\@$ipsource>\n";
				$sipoption = $sipoption."Call-ID: $callid\@isme.net\n";
				$sipoption = $sipoption."CSeq: $cseq OPTIONS\n";
				$sipoption = $sipoption."User-Agent: ISME Script\n";
				$sipoption = $sipoption."Max_forwards: 70\n";
				$sipoption = $sipoption."Content-Type: application/sdp\n";
				$sipoption = $sipoption."Content-Length: 0\n";
				$sipoption = $sipoption."\r\n";
	
				# Envoi de la requète SIP OPTION.
				print $sock_udp $sipoption;
					
				#--DEBUG------------------------------------------------
				# print "3- Lecture de la réponse\n";
				#--DEBUG------------------------------------------------		
				
				my $select = IO::Select->new();
				$select->add($sock_udp);
					
				if ($select->can_read(5))
				{
					unless ($sock_udp->recv($data_read,'1024'))
					{
						$data_read = "Cannot Receive $!"; # " "	
					}
					$UAAnswer = 1;
				}
				else 
				{ #------------> Time out <-------------
					$data_read = "TIME OUT receiving datas";
					$UAAnswer = 0;
				}
				$select->remove($sock_udp);
				close($sock_udp);
		
				if (($data_read =~ /Cannot Receive/)||($data_read =~ /TIME OUT/))
				{
					$SIPOptionResult="SIP Option answer:\n".$data_read."\n";
					#GUI Handling for OPTION test no answer (which is positive
				}
				else 
				{
					$SIPOptionResult="SIP Option answer:\n".$data_read."\n";
					#GUI Handling for OPTION test positive answer
				}				
			}
		}
		if ($SipType =~ /tcp/)
		{				
	
			my $sock_tcp = new IO::Socket::INET ( 
											LocalPort => '8888',
				                            PeerAddr => $ipdest,
						                    PeerPort => '5060',
											Proto => 'tcp',
											Timeout => 3,
												); 
							#die unless $sock_tcp;
							
			if ($sock_tcp)
			{
				$port5060TCPfound == 1;

				#--DEBUG------------------------------------------------
				# 2- Envoi du paquet SIP\n";
				#--DEBUG------------------------------------------------		
				my $callid = md5_base64("$ipsource:$ipdest");
				$callid =~ s/[^a-zA-Z1-9]//g;
				my $fromtag = 1000000000 + int(rand(1000000000));
				my $cseq = 60000 + int(rand(5001));
				my $branch = md5_base64("$callid");
				$branch =~ s/[^a-zA-Z1-9]//g;
						
				$sipoption = "OPTIONS sip:user\@$ipdest SIP/2.0\n";
				$sipoption = $sipoption."From: \"isme\" <sip:isme\@$ipsource>;tag=$fromtag\n";
				$sipoption = $sipoption."Via: SIP/2.0/udp $ipsource:5060;branch=$branch\n";
				$sipoption = $sipoption."To: <sip:user\@$ipdest:5060>\n";
				$sipoption = $sipoption."Contact: <sip:isme\@$ipsource>\n";
				$sipoption = $sipoption."Call-ID: $callid\@isme.net\n";
				$sipoption = $sipoption."CSeq: $cseq OPTIONS\n";
				$sipoption = $sipoption."User-Agent: ISME Script\n";
				$sipoption = $sipoption."Max_forwards: 70\n";
				$sipoption = $sipoption."Content-Type: application/sdp\n";
				$sipoption = $sipoption."Content-Length: 0\n";
				$sipoption = $sipoption."\r\n";
		
				# Envoi de la requète SIP OPTION.
				print $sock_tcp $sipoption;
						
				#--DEBUG------------------------------------------------
				# print "3- Lecture de la réponse\n";
				#--DEBUG------------------------------------------------		
					
				my $select = IO::Select->new();
				$select->add($sock_tcp);
						
				if ($select->can_read(5))
				{
					unless ($sock_tcp->recv($data_read,'1024'))
					{
						$data_read = "Cannot Receive $!"; # " "	
					}
					$UAAnswer = 1;
				}
				else 
				{ #------------> Time out <-------------
					$data_read = "TIME OUT receiving datas";
					$UAAnswer = 0;
				}
				$select->remove($sock_tcp);
				close($sock_tcp);
			}
			else
			{
				$port5060TCPfound == 0;
				close($sock_tcp);
			}			
		}
		#---- END OF SIP PART ---------------------------------------------

		# SIP port found, we move ahead with other tests
		if (( $port5060UDPfound == 1 )||($port5060TCPfound == 1))
	    {

			#---- START PING PART ---------------------------------------------
			if ($p->ping($ipdest))
			{
				$PingAnswer = 1;
			}
			else
			{
				$PingAnswer = 0;
			}
			#---- END PING PART ---------------------------------------------
			
			#---- START TELNET PART ---------------------------------------------
			my $port23TCP = IO::Socket::INET -> new (
		             Proto => "tcp",
				     Timeout => 3,
		             PeerAddr => $ipdest,
		             PeerPort => "23" );	
		
			if ($port23TCP)
			{
				$TelnetAnswer = 1;
				close ($port23TCP);	
			}
			else
			{
				$TelnetAnswer = 0;
			}		
			#---- END TELNET PART ---------------------------------------------
	
			#---- START SSH PART ---------------------------------------------
			my $port22TCP = IO::Socket::INET -> new (
		             Proto => "tcp",
				     Timeout => 3,
		             PeerAddr => $ipdest,
		             PeerPort => "22" );
		
			if ($port22TCP)
			{
				$SSHAnswer = 1;
				close ($port22TCP);	
			}
			else
			{
				$SSHAnswer = 0;
			}
	
			#---- END SSH PART ---------------------------------------------
	
			#---- START HTTP PART ---------------------------------------------
			my $port80TCP = IO::Socket::INET -> new (
	    	         Proto => "tcp",
				     Timeout => 3,
	            	 PeerAddr => $ipdest,
	            	 PeerPort => "80" );
	
			if ($port80TCP)
			{
				$HttpAnswer = 1;
				close ($port80TCP);	
			}
			else
			{
				$HttpAnswer = 0;
			}
			#---- END HTTP PART ---------------------------------------------
	
			#---- START HTTPS PART ---------------------------------------------
			my $port443TCP = IO::Socket::INET -> new (
	    	         Proto => "tcp",
				     Timeout => 3,
	            	 PeerAddr => $ipdest,
	            	 PeerPort => "443" );
	
			if ($port443TCP)
			{
				$HttpsAnswer = 1;
				close ($port443TCP);	
			}
			else
			{
				$HttpsAnswer = 0;
			}
			#---- END HTTPS PART ---------------------------------------------
		}
		

		#----------------------------------------------------------------------
	    #END OF TEST. GUI HANDLING
	    #----------------------------------------------------------------------


		if (( $port5060UDPfound == 1 )||($port5060TCPfound == 1))
	    {
			if ($port5060UDPfound == 1)
		    {
			    $TextWidget_tab3 -> insert ("end","$ipdest: SIP service available on UDP port 5060 (Open/Filtered)\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
	
			    $TextWidget_tab2 -> insert ("end","$ipdest: SIP service available on UDP port 5060\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
					
				$Results = $Results."$ipdest: SIP service available on UDP port 5060\n";
				
				if (($data_read =~ /Cannot Receive/)||($data_read =~ /TIME OUT/))
				{
					$SIPOptionResult="SIP Option answer: NO\n";
				    $TextWidget_tab3 -> insert ("end","$ipdest: SIP Option answer - NO\n");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
		
				    $TextWidget_tab2 -> insert ("end","$ipdest: SIP Option answer - NO\n");
					$TextWidget_tab2  -> update ();	
					$TextWidget_tab2  -> see ('end');
						
					$Results = $Results."$ipdest: SIP Option answer - NO\n";					
				}
				else 
				{
					$SIPOptionResult=$ipdest.": SIP Option answer - YES\n----\n".$data_read."----\n";
				    $TextWidget_tab3 -> insert ("end","$SIPOptionResult");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
		
				    $TextWidget_tab2 -> insert ("end","$SIPOptionResult");
					$TextWidget_tab2  -> update ();	
					$TextWidget_tab2  -> see ('end');
						
					$Results = $Results."$SIPOptionResult";	
				}
			}
			elsif ($port5060TCPfound == 1)
		    {
			    $TextWidget_tab3 -> insert ("end","$ipdest: SIP service available on TCP port 5060\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
	
			    $TextWidget_tab2 -> insert ("end","$ipdest: SIP service available on TCP port 5060\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
					
				$Results = $Results."$ipdest: SIP service available on TCP port 5060\n";
				
				if (($data_read =~ /Cannot Receive/)||($data_read =~ /TIME OUT/))
				{
					$SIPOptionResult="SIP Option answer: NO\n";
				    $TextWidget_tab3 -> insert ("end","$ipdest: SIP Option answer - NO\n");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
		
				    $TextWidget_tab2 -> insert ("end","$ipdest: SIP Option answer - NO\n");
					$TextWidget_tab2  -> update ();	
					$TextWidget_tab2  -> see ('end');
						
					$Results = $Results."$ipdest: SIP Option answer - NO\n";					
				}
				else 
				{
					$SIPOptionResult=$ipdest.": SIP Option answer - YES\n----\n".$data_read."----\n";
				    $TextWidget_tab3 -> insert ("end","$SIPOptionResult");
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
		
				    $TextWidget_tab2 -> insert ("end","$SIPOptionResult");
					$TextWidget_tab2  -> update ();	
					$TextWidget_tab2  -> see ('end');
						
					$Results = $Results."$SIPOptionResult";	
				}
			}
			if ( $PingAnswer == 1 )
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to ping - YES\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to ping - YES\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to ping - YES\n";
			}
			elsif ($PingAnswer == 0)
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to ping - NO\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to ping - NO\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to ping - NO\n";
			}
	
			if ( $TelnetAnswer == 1 )
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to telnet - YES\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to telnet - YES\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to telnet - YES\n";
			}
			elsif ($TelnetAnswer == 0)
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to telnet - NO\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to telnet - NO\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to telnet - NO\n";
			}
	
			if ( $SSHAnswer == 1 )
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to SSH - YES\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to SSH - YES\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to SSH - YES\n";
			}
			elsif ($SSHAnswer == 0)
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to SSH - NO\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to SSH - NO\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to SSH - NO\n";
			}
			if ( $HttpAnswer == 1 )
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to HTTP - YES\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to HTTP - YES\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to HTTP - YES\n";
			}
			elsif ($HttpAnswer == 0)
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to HTTP - NO\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to HTTP - NO\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to HTTP - NO\n";
			}
			if ( $HttpsAnswer == 1 )
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to HTTPS - YES\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to HTTPS - YES\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to HTTPS - YES\n";
			}
			elsif ($HttpsAnswer == 0)
			{
			    $TextWidget_tab3 -> insert ("end","$ipdest: Answering to HTTPS - NO\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
		
			    $TextWidget_tab2 -> insert ("end","$ipdest: Answering to HTTPS - NO\n");
				$TextWidget_tab2  -> update ();	
				$TextWidget_tab2  -> see ('end');
						
				$Results = $Results."$ipdest: Answering to HTTPS - NO\n";
			}
		}	
	    else
	    {
		    $TextWidget_tab3 -> insert ("end","$ipdest: No SIP service found\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
				
			$Results = $Results."$ipdest: No SIP service found\n";			    
		}

		# PROGRESS BAR UPDATE
	   	#----------------------------------------------------------------------
	   	$counter_temp = $counter_temp + 1;
	   	$percentage = int (($counter_temp/$counter_global)*100);
		$bar1->value($percentage);
	}

    $TextWidget_tab3 -> insert ("end","END\n");
	$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");	
	$TextWidget_tab3  -> update ();	
	$TextWidget_tab3  -> see ('end');

	$TextWidget_tab2 -> insert ("end", "END\n");			
	$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
	$TextWidget_tab2  -> update ();	
	$TextWidget_tab2  -> see ('end');
	
	$Results = $Results."END\n";
	$Results = $Results."-------------------------------------------------------------------------------\n";
}



sub EXPLANATION
{
	$TextWidget_tab1 -> delete('0.0', 'end');
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1 -> insert ("end", "This module will try to detect if a SIP service is available on the specify IP address. This test will be done for UDP port 5060. Once a SIP service has been detected, the script will try to detect if the following services usually provided for administration are available or not: telnet, ssh, http, https and answer to ping. Administration services should be properly identified, encrypted and unreachable from public area.\n");
	$TextWidget_tab1 -> insert ("end", "\n");	
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1  -> update ();	
	$TextWidget_tab1  -> see ('end'); 
	
	$book->raise("Sheet 1");			
}
