#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["MissingHttpOnlyFlag"]

from . import CookieVulnerability

class MissingHttpOnlyFlag(CookieVulnerability):
    """
    Missing "HttpOnly" Flag.

    A cookie without the "HttpOnly" flag was found. An attacker who can
    successfully exploit a Cross-Site Scripting (XSS) vulnerability would
    be able to capture the contents of this cookie from affected users.

    Always set the "HttpOnly" flag to prevent JavaScript code from reading the
    contents of your cookies.
    """

    DEFAULTS = CookieVulnerability.DEFAULTS.copy()
    DEFAULTS["cwe"]        = "CWE-79"     # XXX points to XSS...
    DEFAULTS["capec"]      = "CAPEC-102"
    DEFAULTS["cvss_base"]  = "4.0"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/HttpOnly",
        "https://www.owasp.org/index.php/"
                            "Testing_for_cookies_attributes_(OWASP-SM-002)",
        "http://msdn2.microsoft.com/en-us/library/ms533046.aspx",
        "http://msdn.microsoft.com/en-us/library/"
                                        "system.web.httpcookie.httponly.aspx",
        "https://kb.bluecoat.com/index?page=content&id=KB5698&actp=RSS",
    )
