#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__ = """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

# Fix the module path.
import sys
import os
from os import path
here = path.split(path.abspath(__file__))[0]
if not here:  # if it fails use cwd instead
    here = path.abspath(os.getcwd())
golismero = path.join(here, "..", "..")
thirdparty_libs = path.join(golismero, "thirdparty_libs")
if path.exists(thirdparty_libs):
    sys.path.insert(0, thirdparty_libs)
    sys.path.insert(0, golismero)

index = """GoLismero - The Web Knife
=========================

Indices
-------

* :ref:`genindex`
* :ref:`modindex`
* :ref:`search`

Table of Contents
-----------------

.. toctree::
   :maxdepth: 4

   golismero
""".replace("\r\n", "\n")

from os import chdir, listdir, unlink
from os.path import dirname, isfile, join
from sphinx import apidoc

def gen():
    apidoc.main(["sphinx-autodoc-script.py", "-o", ".", "-f", "--no-toc", join("..", "..", "golismero")])
    with open("index.rst", "wb") as f:
        f.write(index)

if __name__ == '__main__':
    gen()
