/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree.parse;

import com.google.common.collect.AbstractIterator;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.util.CharArrayUtils;

public class TokenScanner
extends AbstractIterator<Token> {
    private final JinjavaConfig config;
    private final char[] is;
    private final int length;
    private int currPost = 0;
    private int tokenStart = 0;
    private int tokenLength = 0;
    private int tokenKind = -1;
    private int lastStart = 0;
    private int inComment = 0;
    private int inRaw = 0;
    private int inBlock = 0;
    private char inQuote = '\u0000';
    private int currLine = 1;
    private int lastNewlinePos = 0;

    public TokenScanner(String input, JinjavaConfig config) {
        this.config = config;
        this.is = input.toCharArray();
        this.length = this.is.length;
        this.currPost = 0;
        this.tokenStart = 0;
        this.tokenKind = -1;
        this.lastStart = 0;
        this.inComment = 0;
        this.inRaw = 0;
        this.inBlock = 0;
        this.inQuote = '\u0000';
        this.currLine = 1;
        this.lastNewlinePos = 0;
    }

    private Token getNextToken() {
        block10: while (this.currPost < this.length) {
            char c = this.is[this.currPost++];
            if (this.currPost == this.length) {
                return this.getEndToken();
            }
            if (this.inBlock > 0) {
                if (this.inQuote != '\u0000') {
                    if (this.inQuote == c) {
                        this.inQuote = '\u0000';
                        continue;
                    }
                    if (c != '\\') continue;
                    ++this.currPost;
                    continue;
                }
                if (this.inQuote == '\u0000' && (c == '\'' || c == '\"')) {
                    this.inQuote = c;
                    continue;
                }
            }
            switch (c) {
                case '{': {
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        switch (c) {
                            case '#': {
                                if (this.inComment == 1 || this.inRaw == 1) continue block10;
                                this.inComment = 1;
                                this.tokenLength = this.currPost - this.tokenStart - 1;
                                if (this.tokenLength > 0) {
                                    this.lastStart = this.tokenStart;
                                    this.tokenStart = --this.currPost;
                                    this.tokenKind = c;
                                    this.inComment = 0;
                                    return this.newToken(0);
                                }
                                this.tokenKind = c;
                                continue block10;
                            }
                            case '%': 
                            case '{': {
                                if (this.inComment > 0 || this.inRaw > 0 && (c == '{' || !this.isEndRaw()) || !this.matchToken(c) && this.tokenKind > 0 || this.inBlock++ > 0) continue block10;
                                this.tokenLength = this.currPost - this.tokenStart - 1;
                                if (this.tokenLength > 0) {
                                    this.lastStart = this.tokenStart;
                                    this.tokenStart = --this.currPost;
                                    this.tokenKind = c;
                                    return this.newToken(0);
                                }
                                this.tokenKind = c;
                                continue block10;
                            }
                        }
                        continue block10;
                    }
                    return this.getEndToken();
                }
                case '%': 
                case '}': {
                    if (this.inComment > 0 || !this.matchToken(c)) continue block10;
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        if (c != '}') continue block10;
                        this.inBlock = 0;
                        this.tokenLength = this.currPost - this.tokenStart + 1;
                        if (this.tokenLength <= 0) continue block10;
                        this.lastStart = this.tokenStart;
                        this.tokenStart = ++this.currPost;
                        int kind = this.tokenKind;
                        this.tokenKind = 0;
                        return this.newToken(kind);
                    }
                    return this.getEndToken();
                }
                case '#': {
                    if (!this.matchToken(c)) continue block10;
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        if (c != '}') continue block10;
                        this.inComment = 0;
                        this.tokenLength = this.currPost - this.tokenStart + 1;
                        if (this.tokenLength <= 0) continue block10;
                        this.lastStart = this.tokenStart;
                        this.tokenStart = ++this.currPost;
                        this.tokenKind = 0;
                        return this.newToken(35);
                    }
                    return this.getEndToken();
                }
                case '\n': {
                    ++this.currLine;
                    this.lastNewlinePos = this.currPost;
                    if (this.inComment > 0 || this.inBlock > 0) continue block10;
                    this.tokenKind = 0;
                    continue block10;
                }
            }
            if (this.tokenKind != -1) continue;
            this.tokenKind = 0;
        }
        return null;
    }

    private boolean isEndRaw() {
        int pos = this.currPost + 1;
        while (pos < this.length && Character.isWhitespace(this.is[pos++])) {
        }
        if (pos + 5 >= this.length) {
            return false;
        }
        return CharArrayUtils.charArrayRegionMatches(this.is, pos - 1, "endraw");
    }

    private Token getEndToken() {
        this.tokenLength = this.currPost - this.tokenStart;
        int type = 0;
        if (this.inComment > 0) {
            type = 35;
        }
        return Token.newToken(type, String.valueOf(this.is, this.tokenStart, this.tokenLength), this.currLine, this.tokenStart - this.lastNewlinePos + 1);
    }

    private Token newToken(int kind) {
        Token t = Token.newToken(kind, String.valueOf(this.is, this.lastStart, this.tokenLength), this.currLine, this.lastStart - this.lastNewlinePos + 1);
        if (t instanceof TagToken) {
            TagToken tt;
            if (this.config.isTrimBlocks() && this.currPost < this.length && this.is[this.currPost] == '\n') {
                this.lastNewlinePos = this.currPost++;
                ++this.tokenStart;
            }
            if ("raw".equals((tt = (TagToken)t).getTagName())) {
                this.inRaw = 1;
                return tt;
            }
            if ("endraw".equals(tt.getTagName())) {
                this.inRaw = 0;
                return tt;
            }
        }
        if (this.inRaw > 0 && t.getType() != 0) {
            return Token.newToken(0, t.image, this.currLine, this.tokenStart);
        }
        return t;
    }

    private boolean matchToken(char kind) {
        if (kind == '{') {
            return this.tokenKind == 125;
        }
        if (kind == '}') {
            return this.tokenKind == 123;
        }
        return kind == this.tokenKind;
    }

    protected Token computeNext() {
        Token t = this.getNextToken();
        if (t == null) {
            return (Token)this.endOfData();
        }
        return t;
    }
}

