/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@JinjavaDoc(value="Return the number of items of a sequence or mapping", params={@JinjavaParam(value="object", desc="The sequence to count")}, snippets={@JinjavaSnippet(code="{% set services = ['Web design', 'SEO', 'Inbound Marketing', 'PPC'] %}\n{{ services|length }}")})
public class LengthFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (null == object) {
            return 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof Iterable) {
            Iterator it = ((Iterable)object).iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }
        if (object instanceof String) {
            return ((String)object).length();
        }
        return 0;
    }

    @Override
    public String getName() {
        return "length";
    }
}

