﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using FuzzTalk;
using FuzzTalkUI.Models;

namespace FuzzTalkUI.Models
{
    public class ItemViewModel<T> : BaseViewModel
        where T : class
    {
        private T _Item;
        
        public T Item
        {
        	get { return _Item; }
        	set
        	{                
        		_Item = value;
        
        		InvokePropertyChanged("Item");
        	}
        }

        public ItemViewModel(T Item, FrameworkElement Element, BaseViewModel Parent)
            : base(Element, Parent)
        {
            _Item = Item;
        }

        public ItemViewModel(T Item, FrameworkElement Element)
            : base(Element)
        {
            _Item = Item;
        }
    }
}
