﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FuzzTalk
{
    public class IndexPermutator
    {
        private int[] _indexes, _lengths;

        private int _currentIndex = 0;

        private bool _singleIndexMode;

        public bool SingleIndexMode
        {
            get { return _singleIndexMode; }
            set { _singleIndexMode = value; }
        }

        public IndexPermutator(int[] Lengths, bool SingleIndexMode)
        {
            _singleIndexMode = SingleIndexMode;
            _indexes = new int[Lengths.Length];
            _indexes[0] = -1;
            _lengths = Lengths;
        }

        public int[] GetNext()
        {
            if (!_singleIndexMode)
                _currentIndex = 0;

            while (true)
            {
                if (++_indexes[_currentIndex] != _lengths[_currentIndex])
                    break;
                else
                {
                    _indexes[_currentIndex++] = 0;

                    if (_currentIndex == _indexes.Length)
                        return null;
                }
            }

            return _indexes.Clone() as int[];
        }
    }
}
