﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.IO;

namespace FuzzTalk.Actions
{
    public class SendFuzz : SocketAction
    {
        private byte[] _fuzzBytes;

        [XmlIgnore]
        public byte[] FuzzBytes
        {
            get { return _fuzzBytes; }
            set 
            {
                _fuzzBytes = value;

                FuzzString = new string(_fuzzBytes.Select(x => (char)x).ToArray());
            }
        }

        [XmlIgnore]
        public string FuzzString { get; private set; }

        [XmlAttribute]
        public SendFuzzLogMode LogMode { get; set; }

        public override void Process(ActionInterpreter Interpreter)
        {
            try
            {
                if (Log)
                {
                    Program.Log.AddEntry(LogMode == SendFuzzLogMode.String ?
                        ("Send:\r\n\r\n" + FuzzString) :
                        ("Send Template Indexes: " + string.Join(",",
                            Program.StringIndexes
                            .Select(x => x.ToString())
                            .ToArray())));
                }

                //FuzzTalkScript.Current.InputTemplate.Component.First().

                var c = Interpreter.FindActionByName(Socket) as Connect;
                c.SendData(_fuzzBytes);
            }
            catch (System.Exception ex)
            {
                Program.Log.AddEntry("Send Error:\r\n\r\n" + ex);
            }

            //foreach (var debugger in FuzzTalkScript.Current.GetAllActions()
            //    .OfType<AttachDebugger>())
            //{
            //    foreach (var file in debugger.DumpDirectory.GetFiles())
            //    {
            //        ActionHelper.Try<IOException>(() =>
            //                Program.Logger.AddEntry("Crash dump\r\n" + File.ReadAllText(file.FullName)));

            //        ActionHelper.Try<IOException>(() => File.Delete(file.FullName));
            //    }
            //}
        }
    }
}
