﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml.Serialization;

namespace FuzzTalk.Actions
{
    public enum RegexLogMode
    {
        [XmlEnum]
        OnSuccess,
        [XmlEnum]
        OnFailure
    }

    public class RegexMonitor : FuzzTalkAction
    {
        [XmlAttribute]
        public string TargetAction { get; set; }

        [XmlAttribute]
        public string TargetProperty { get; set; }

        [XmlAttribute]
        public string Pattern { get; set; }

        [XmlAttribute]
        public RegexLogMode LogMode { get; set; }

        [XmlAttribute]
        public string Message { get; set; }

        [XmlAttribute]
        public override bool Log
        {
            get { throw new NotSupportedException("RegexMonitorAction.Log not supported."); }
            set { throw new NotSupportedException("RegexMonitorAction.Log not supported."); }
        }

        public override void Process(ActionInterpreter Interpreter)
        {
            var action = Interpreter.FindActionByName(TargetAction);

            var actionType = action.GetType();
            var property = actionType.GetProperty(TargetProperty);

            var propertyValue = property.GetValue(action, null);

            string propertyValue2 = propertyValue as string;

            if (propertyValue != null && propertyValue2 == null)
                throw new InvalidOperationException(string.Format(
                    "Target property {0}.{1} is not a string.",
                        TargetAction, TargetProperty));

            var success = Regex.IsMatch(propertyValue2, Pattern);

            if ((success && LogMode == RegexLogMode.OnSuccess) ||
                (!success && LogMode == RegexLogMode.OnFailure))
            {
                Program.Log.AddEntry(string.IsNullOrEmpty(Message) ?
                    "Regex Monitor Match" :
                    Message);
            }
        }

        public RegexMonitor()
        {
            
        }
    }
}
