﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FuzzTalk.Actions
{
    public class ActionInterpreter
    {
        private FuzzTalkAction[] _actions;

        public ActionInterpreter(FuzzTalkAction[] Actions)
        {
            _actions = Actions;
        }

        public void SetFuzzBytes(byte[] FuzzBytes)
        {
            foreach (var action in _actions
                .Where(x => x is SendFuzz)
                .OfType<SendFuzz>())
                action.FuzzBytes = FuzzBytes;                
        }

        public void Run()
        {
            // use for validating names
            //if (_actionData.Keys
            //    .SingleOrDefault(x => x.Name == a.Name) != null)
            //    throw new InvalidOperationException(string.Format("Action with name {0} already exists.", a.Name));

            foreach (var a in _actions)
                a.Process(this);
        }

        public FuzzTalkAction FindActionByName(string Name)
        {
            return FindAction(x => x.Name == Name);
        }

        public FuzzTalkAction FindAction(Func<FuzzTalkAction, bool> Predicate)
        {
            return _actions.SingleOrDefault(Predicate);
        }
    }
}
