﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Reflection;

namespace Debugger
{
    public class DisassemblerWrapper
    {
        private static Random _random = new Random();

        public string DisassemblerPath { get; set; }
        public string TempPath { get; set; }

        public DisassemblerWrapper()
        {
            //var location = Assembly.GetExecutingAssembly().Location;

            //DisassemblerPath = location.Remove(location.LastIndexOf('\\')) + @"\disasm32.exe";

            DisassemblerPath = @".\disasm32.exe";
            TempPath = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
        }

        public string Disassemble(byte[] Bytes, uint PatchOffset)
        {
            var tmpBin = TempPath + "\\" + Environment.TickCount + _random.Next() + ".bin";

            File.WriteAllBytes(tmpBin, Bytes);

            var process = Process.Start(new ProcessStartInfo(DisassemblerPath, "\"" + tmpBin + "\"")
            {
                UseShellExecute = false,
                RedirectStandardOutput = true,
            });

            var output = new StringBuilder();

            var buffer = "";

            while (!process.HasExited && 
                !string.IsNullOrEmpty((buffer = process.StandardOutput.ReadToEnd())))
                output.Append(buffer);

            output.Append(process.StandardOutput.ReadToEnd());

            var disassemblyLines = output
                .ToString()
                .Split(new[] { '\r', '\n' }, StringSplitOptions.RemoveEmptyEntries)
                .Skip(4)
                .ToArray();

            if (disassemblyLines.Length == 0)
                return "";

            if (PatchOffset != 0)
                for (int i = 0; i < disassemblyLines.Length; i++)
                {
                    var address = Convert.ToUInt32(disassemblyLines[i].Remove(8), 16) + PatchOffset;

                    disassemblyLines[i] = 
                        address.ToString("X8") + disassemblyLines[i].Substring(8);
                }

            var disassembly = disassemblyLines.Aggregate((x, y) => x + "\n" + y);

            return disassembly;
        }

        public string Disassemble(byte[] Bytes)
        {
            return Disassemble(Bytes, 0);
        }
    }
}
