/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class DoStatement
extends Statement {
    private final List<@Nullable Exprent> initExprent = new ArrayList<Exprent>();
    private final List<@Nullable Exprent> conditionExprent = new ArrayList<Exprent>();
    private final List<@Nullable Exprent> incExprent = new ArrayList<Exprent>();
    @NotNull
    private LoopType loopType;

    private DoStatement() {
        super(Statement.StatementType.DO);
        this.initExprent.add(null);
        this.conditionExprent.add(null);
        this.incExprent.add(null);
        this.loopType = LoopType.DO;
    }

    private DoStatement(Statement head) {
        this();
        this.first = head;
        this.stats.addWithKey(this.first, this.first.id);
    }

    @Nullable
    public static Statement isHead(Statement head) {
        if (head.getLastBasicType() == Statement.StatementType.GENERAL && !head.isMonitorEnter()) {
            StatEdge edge = null;
            List<StatEdge> successorEdges = head.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
            if (!successorEdges.isEmpty()) {
                edge = successorEdges.get(0);
            }
            if (edge != null && edge.getType() == StatEdge.EdgeType.REGULAR && edge.getDestination() == head) {
                return new DoStatement(head);
            }
            if (head.type != Statement.StatementType.DO && (edge == null || edge.getType() != StatEdge.EdgeType.REGULAR) && head.getContinueSet().contains(head.getBasichead())) {
                return new DoStatement(head);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(Integer.toString(this.id)).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        switch (this.loopType) {
            case DO: {
                buf.appendIndent(indent).append("while(true) {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false, tracer));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                break;
            }
            case DO_WHILE: {
                buf.appendIndent(indent).append("do {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false, tracer));
                buf.appendIndent(indent).append("} while(").append(Objects.requireNonNull(this.conditionExprent.get(0)).toJava(indent, tracer)).append(");").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                break;
            }
            case WHILE: {
                buf.appendIndent(indent).append("while(").append(Objects.requireNonNull(this.conditionExprent.get(0)).toJava(indent, tracer)).append(") {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false, tracer));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                break;
            }
            case FOR: {
                buf.appendIndent(indent).append("for(");
                Exprent firstInitExprent = this.initExprent.get(0);
                if (firstInitExprent != null) {
                    buf.append(firstInitExprent.toJava(indent, tracer));
                }
                Exprent firstIncExprent = Objects.requireNonNull(this.incExprent.get(0));
                buf.append("; ").append(Objects.requireNonNull(this.conditionExprent.get(0)).toJava(indent, tracer)).append("; ").append(firstIncExprent.toJava(indent, tracer)).append(") {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, false, tracer));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                break;
            }
            case FOREACH: {
                Exprent incFirstExprent = this.incExprent.get(0);
                Exprent initFirstExprent = this.initExprent.get(0);
                if (initFirstExprent == null || incFirstExprent == null) break;
                buf.appendIndent(indent).append("for(").append(initFirstExprent.toJava(indent, tracer));
                incFirstExprent.inferExprType(null);
                buf.append(" : ").append(incFirstExprent.toJava(indent, tracer)).append(") {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                buf.append(ExprProcessor.jmpWrapper(this.first, indent + 1, true, tracer));
                buf.appendIndent(indent).append("}").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
            }
        }
        return buf;
    }

    @Override
    @NotNull
    public List<IMatchable> getSequentialObjects() {
        ArrayList<IMatchable> lst = new ArrayList<IMatchable>();
        switch (this.loopType) {
            case FOR: {
                if (this.getInitExprent() != null) {
                    lst.add(this.getInitExprent());
                }
            }
            case WHILE: {
                lst.add(this.getConditionExprent());
                break;
            }
            case FOREACH: {
                lst.add(this.getInitExprent());
                lst.add(this.getIncExprent());
            }
        }
        lst.add(this.first);
        switch (this.loopType) {
            case DO_WHILE: {
                lst.add(this.getConditionExprent());
                break;
            }
            case FOR: {
                lst.add(this.getIncExprent());
            }
        }
        return lst;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (this.initExprent.get(0) == oldExpr) {
            this.initExprent.set(0, newExpr);
        }
        if (this.conditionExprent.get(0) == oldExpr) {
            this.conditionExprent.set(0, newExpr);
        }
        if (this.incExprent.get(0) == oldExpr) {
            this.incExprent.set(0, newExpr);
        }
    }

    @Override
    @NotNull
    public Statement getSimpleCopy() {
        return new DoStatement();
    }

    @NotNull
    public List<Exprent> getInitExprentList() {
        return this.initExprent;
    }

    @NotNull
    public List<Exprent> getConditionExprentList() {
        return this.conditionExprent;
    }

    @NotNull
    public List<Exprent> getIncExprentList() {
        return this.incExprent;
    }

    @Nullable
    public Exprent getConditionExprent() {
        return this.conditionExprent.get(0);
    }

    public void setConditionExprent(Exprent conditionExprent) {
        this.conditionExprent.set(0, conditionExprent);
    }

    @Nullable
    public Exprent getIncExprent() {
        return this.incExprent.get(0);
    }

    public void setIncExprent(Exprent incExprent) {
        this.incExprent.set(0, incExprent);
    }

    @Nullable
    public Exprent getInitExprent() {
        return this.initExprent.get(0);
    }

    public void setInitExprent(Exprent initExprent) {
        this.initExprent.set(0, initExprent);
    }

    @NotNull
    public LoopType getLoopType() {
        return this.loopType;
    }

    public void setLoopType(@NotNull LoopType loopType) {
        this.loopType = loopType;
    }

    public static enum LoopType {
        DO,
        DO_WHILE,
        WHILE,
        FOR,
        FOREACH;

    }
}

