"""update/__init__.py

Created by Thomas Mangin on 2010-01-15.
Copyright (c) 2009-2017 Exa Networks. All rights reserved.
License: 3-clause BSD. (See the COPYRIGHT file)
"""

# Every Message should be imported from this file
# as it makes sure that all the registering decorator are run

# flake8: noqa: F401,E261

from __future__ import annotations

from exabgp.bgp.message.action import Action
from exabgp.bgp.message.scheduling import Scheduling
from exabgp.bgp.message.scheduling import NOP, AWAKE, DONE
from exabgp.bgp.message.scheduling import _NOP, _AWAKE, _DONE

from exabgp.bgp.message.message import Message
from exabgp.bgp.message.open import Open
from exabgp.bgp.message.update import Update, UpdateCollection
from exabgp.bgp.message.update import EOR
from exabgp.bgp.message.keepalive import KeepAlive
from exabgp.bgp.message.notification import Notification
from exabgp.bgp.message.notification import Notify
from exabgp.bgp.message.operational import Operational

__all__ = [
    'Action',
    'Scheduling',
    'NOP',
    'AWAKE',
    'DONE',
    '_NOP',
    '_AWAKE',
    '_DONE',
    'Message',
    'Open',
    'Update',
    'UpdateCollection',
    'EOR',
    'KeepAlive',
    'Notification',
    'Notify',
    'Operational',
]
