/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.flattened.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.flattened.mapper.FlatObjectFieldParser;
import org.elasticsearch.xpack.flattened.mapper.KeyedFlatObjectLeafFieldData;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flattened";
    private static final String KEYED_FIELD_SUFFIX = "._keyed";
    private FlatObjectFieldParser fieldParser;
    private final String nullValue;
    private int depthLimit;
    private int ignoreAbove;

    private FlatObjectFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, int ignoreAbove, int depthLimit, String nullValue) {
        super(simpleName, fieldType, mappedFieldType, FieldMapper.CopyTo.empty());
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.depthLimit = depthLimit;
        this.ignoreAbove = ignoreAbove;
        this.nullValue = nullValue;
        this.fieldParser = new FlatObjectFieldParser(mappedFieldType.name(), this.keyedFieldName(), mappedFieldType, depthLimit, ignoreAbove, nullValue);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void mergeOptions(FieldMapper mergeWith, List<String> conflicts) {
        FlatObjectFieldMapper other = (FlatObjectFieldMapper)mergeWith;
        if (!Objects.equals(this.nullValue, other.nullValue)) {
            conflicts.add("mapper [" + this.name() + "] has different [null_value] settings");
        }
        this.depthLimit = other.depthLimit;
        this.ignoreAbove = other.ignoreAbove;
        this.fieldParser = new FlatObjectFieldParser(this.mappedFieldType.name(), this.keyedFieldName(), this.mappedFieldType, this.depthLimit, this.ignoreAbove, this.nullValue);
    }

    protected FlatObjectFieldMapper clone() {
        return (FlatObjectFieldMapper)super.clone();
    }

    public RootFlatObjectFieldType fieldType() {
        return (RootFlatObjectFieldType)super.fieldType();
    }

    public KeyedFlatObjectFieldType keyedFieldType(String key) {
        return new KeyedFlatObjectFieldType(this.keyedFieldName(), key, this.fieldType());
    }

    public String keyedFieldName() {
        return this.mappedFieldType.name() + KEYED_FIELD_SUFFIX;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (this.fieldType.indexOptions() == IndexOptions.NONE && !this.mappedFieldType.hasDocValues()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser xContentParser = context.parser();
        context.doc().addAll(this.fieldParser.parse(xContentParser));
        if (!this.mappedFieldType.hasDocValues()) {
            this.createFieldNamesField(context);
        }
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType.indexOptions() != IndexOptions.NONE && (includeDefaults || this.fieldType.indexOptions() != Defaults.FIELD_TYPE.indexOptions())) {
            builder.field("index_options", FlatObjectFieldMapper.indexOptionToString((IndexOptions)this.fieldType.indexOptions()));
        }
        if (includeDefaults || this.depthLimit != 20) {
            builder.field("depth_limit", this.depthLimit);
        }
        if (includeDefaults || this.ignoreAbove != Integer.MAX_VALUE) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (includeDefaults || this.fieldType().eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (includeDefaults || this.fieldType().splitQueriesOnWhitespace) {
            builder.field("split_queries_on_whitespace", this.fieldType().splitQueriesOnWhitespace);
        }
    }

    public static final class RootFlatObjectFieldType
    extends StringFieldType {
        private final boolean splitQueriesOnWhitespace;

        public RootFlatObjectFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta, boolean splitQueriesOnWhitespace) {
            super(name, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity((String)this.name(), (MapperService)mapperService, (String)format);
        }
    }

    public static class KeyedFlatObjectFieldData
    implements IndexOrdinalsFieldData {
        private final String key;
        private final IndexOrdinalsFieldData delegate;

        private KeyedFlatObjectFieldData(String key, IndexOrdinalsFieldData delegate) {
            this.delegate = delegate;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getFieldName() {
            return this.delegate.getFieldName();
        }

        public ValuesSourceType getValuesSourceType() {
            return this.delegate.getValuesSourceType();
        }

        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource((IndexFieldData)this, missingValue, sortMode, nested);
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }

        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
            throw new IllegalArgumentException("only supported on numeric fields");
        }

        public LeafOrdinalsFieldData load(LeafReaderContext context) {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.load(context);
            return new KeyedFlatObjectLeafFieldData(this.key, fieldData);
        }

        public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.loadDirect(context);
            return new KeyedFlatObjectLeafFieldData(this.key, fieldData);
        }

        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobal(indexReader);
            return new KeyedFlatObjectFieldData(this.key, fieldData);
        }

        public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) throws Exception {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobalDirect(indexReader);
            return new KeyedFlatObjectFieldData(this.key, fieldData);
        }

        public OrdinalMap getOrdinalMap() {
            throw new UnsupportedOperationException("The field data for the flat object field [" + this.delegate.getFieldName() + "] does not allow access to the underlying ordinal map.");
        }

        public boolean supportsGlobalOrdinalsMapping() {
            return false;
        }

        public static class Builder
        implements IndexFieldData.Builder {
            private final String fieldName;
            private final String key;
            private final ValuesSourceType valuesSourceType;

            Builder(String fieldName, String key, ValuesSourceType valuesSourceType) {
                this.fieldName = fieldName;
                this.key = key;
                this.valuesSourceType = valuesSourceType;
            }

            public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
                SortedSetOrdinalsIndexFieldData delegate = new SortedSetOrdinalsIndexFieldData(cache, this.fieldName, this.valuesSourceType, breakerService, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
                return new KeyedFlatObjectFieldData(this.key, (IndexOrdinalsFieldData)delegate);
            }
        }
    }

    public static final class KeyedFlatObjectFieldType
    extends StringFieldType {
        private final String key;

        public KeyedFlatObjectFieldType(String name, boolean indexed, boolean hasDocValues, String key, boolean splitQueriesOnWhitespace, Map<String, String> meta) {
            super(name, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.key = key;
        }

        private KeyedFlatObjectFieldType(String name, String key, RootFlatObjectFieldType ref) {
            this(name, ref.isSearchable(), ref.hasDocValues(), key, ref.splitQueriesOnWhitespace, ref.meta());
        }

        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        public String key() {
            return this.key;
        }

        public Query existsQuery(QueryShardContext context) {
            Term term = new Term(this.name(), FlatObjectFieldParser.createKeyedValue(this.key, ""));
            return new PrefixQuery(term);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            if (lowerTerm == null || upperTerm == null) {
                throw new IllegalArgumentException("[range] queries on keyed [flattened] fields must include both an upper and a lower bound.");
            }
            return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
            throw new UnsupportedOperationException("[fuzzy] queries are not currently supported on keyed [flattened] fields.");
        }

        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not currently supported on keyed [flattened] fields.");
        }

        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not currently supported on keyed [flattened] fields.");
        }

        public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
            AutomatonQuery query = AutomatonQueries.caseInsensitiveTermQuery((Term)new Term(this.name(), this.indexedValueForSearch(value)));
            if (this.boost() != 1.0f) {
                query = new BoostQuery((Query)query, this.boost());
            }
            return query;
        }

        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            String keyedValue = FlatObjectFieldParser.createKeyedValue(this.key, stringValue);
            return new BytesRef((CharSequence)keyedValue);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new KeyedFlatObjectFieldData.Builder(this.name(), this.key, (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            return lookup -> Collections.emptyList();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("depth_limit")) {
                    builder.depthLimit(XContentMapValues.nodeIntegerValue((Object)propNode, (int)-1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue((Object)propNode, (String)"eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue((Object)propNode, (int)-1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("split_queries_on_whitespace")) continue;
                builder.splitQueriesOnWhitespace(XContentMapValues.nodeBooleanValue((Object)propNode, (String)"split_queries_on_whitespace"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private int depthLimit = 20;
        private int ignoreAbove = Integer.MAX_VALUE;
        private String nullValue = null;
        private boolean eagerGlobalOrdinals = false;
        private boolean splitQueriesOnWhitespace = false;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder indexOptions(IndexOptions indexOptions) {
            if (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) > 0) {
                throw new IllegalArgumentException("The [flattened] field does not support positions, got [index_options]=" + FlatObjectFieldMapper.indexOptionToString((IndexOptions)indexOptions));
            }
            return (Builder)super.indexOptions(indexOptions);
        }

        public Builder depthLimit(int depthLimit) {
            if (depthLimit < 0) {
                throw new IllegalArgumentException("[depth_limit] must be positive, got " + depthLimit);
            }
            this.depthLimit = depthLimit;
            return this;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            if (ignoreAbove < 0) {
                throw new IllegalArgumentException("[ignore_above] must be positive, got " + ignoreAbove);
            }
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder splitQueriesOnWhitespace(boolean splitQueriesOnWhitespace) {
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
            return (Builder)this.builder;
        }

        public Builder addMultiField(Mapper.Builder<?> mapperBuilder) {
            throw new UnsupportedOperationException("[fields] is not supported for [flattened] fields.");
        }

        public Builder copyTo(FieldMapper.CopyTo copyTo) {
            throw new UnsupportedOperationException("[copy_to] is not supported for [flattened] fields.");
        }

        public Builder store(boolean store) {
            throw new UnsupportedOperationException("[store] is not supported for [flattened] fields.");
        }

        public FlatObjectFieldMapper build(Mapper.BuilderContext context) {
            RootFlatObjectFieldType ft = new RootFlatObjectFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta, this.splitQueriesOnWhitespace);
            if (this.eagerGlobalOrdinals) {
                ft.setEagerGlobalOrdinals(true);
            }
            return new FlatObjectFieldMapper(this.name, this.fieldType, (MappedFieldType)ft, this.ignoreAbove, this.depthLimit, this.nullValue);
        }
    }

    private static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final int DEPTH_LIMIT = 20;
        public static final int IGNORE_ABOVE = Integer.MAX_VALUE;

        private Defaults() {
        }

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

