/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.Node;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

class NodeDeprecationChecks {
    NodeDeprecationChecks() {
    }

    static DeprecationIssue checkPidfile(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, Environment.PIDFILE_SETTING, Environment.NODE_PIDFILE_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-pidfile");
    }

    static DeprecationIssue checkProcessors(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, EsExecutors.PROCESSORS_SETTING, EsExecutors.NODE_PROCESSORS_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.4/breaking-changes-7.4.html#deprecate-processors");
    }

    static DeprecationIssue checkMissingRealmOrders(Settings settings, PluginsAndModules pluginsAndModules) {
        Set orderNotConfiguredRealms = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> false == ((Settings)e.getValue()).hasValue("order")).map(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order").collect(Collectors.toSet());
        if (orderNotConfiguredRealms.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "Found realms without order config: [%s]. In next major release, node will fail to start with missing realm order.", String.join((CharSequence)"; ", orderNotConfiguredRealms));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm order will be required in next major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-missing-realm-order", details);
    }

    static DeprecationIssue checkUniqueRealmOrders(Settings settings, PluginsAndModules pluginsAndModules) {
        Map orderToRealmSettings = RealmSettings.getRealmSettings((Settings)settings).entrySet().stream().filter(e -> ((Settings)e.getValue()).hasValue("order")).collect(Collectors.groupingBy(e -> ((Settings)e.getValue()).get("order"), Collectors.mapping(e -> RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)((RealmConfig.RealmIdentifier)e.getKey())) + "order", Collectors.toList())));
        Set duplicateOrders = orderToRealmSettings.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.toSet());
        if (duplicateOrders.isEmpty()) {
            return null;
        }
        String details = String.format(Locale.ROOT, "Found multiple realms configured with the same order: [%s]. In next major release, node will fail to start with duplicated realm order.", String.join((CharSequence)"; ", duplicateOrders));
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm orders must be unique in next major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-duplicated-realm-orders", details);
    }

    static DeprecationIssue checkThreadPoolListenerQueueSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.queue_size", settings);
    }

    static DeprecationIssue checkThreadPoolListenerSize(Settings settings) {
        return NodeDeprecationChecks.checkThreadPoolListenerSetting("thread_pool.listener.size", settings);
    }

    private static DeprecationIssue checkThreadPoolListenerSetting(String name, Settings settings) {
        FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "listener", 1, -1, "thread_pool.listener", true);
        List listenerSettings = builder.getRegisteredSettings();
        Optional<Setting> setting = listenerSettings.stream().filter(s -> s.getKey().equals(name)).findFirst();
        assert (setting.isPresent());
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting.get(), "https://www.elastic.co/guide/en/elasticsearch/reference/7.x/breaking-changes-7.7.html#deprecate-listener-thread-pool");
    }

    public static DeprecationIssue checkClusterRemoteConnectSetting(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.boolSetting((String)"node.remote_cluster_client", (Setting)RemoteClusterService.ENABLE_REMOTE_CLUSTERS, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope}), "https://www.elastic.co/guide/en/elasticsearch/reference/7.7/breaking-changes-7.7.html#deprecate-cluster-remote-connect");
    }

    public static DeprecationIssue checkNodeLocalStorageSetting(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, Node.NODE_LOCAL_STORAGE_SETTING, "https://www.elastic.co/guide/en/elasticsearch/reference/7.8/breaking-changes-7.8.html#deprecate-node-local-storage");
    }

    public static DeprecationIssue checkNodeBasicLicenseFeatureEnabledSetting(Settings settings, Setting<?> setting) {
        return NodeDeprecationChecks.checkRemovedSetting(settings, setting, "https://www.elastic.co/guide/en/elasticsearch/reference/7.8/breaking-changes-7.8.html#deprecate-basic-license-feature-enabled");
    }

    public static DeprecationIssue checkGeneralScriptSizeSetting(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_CACHE_SIZE_SETTING, ScriptService.SCRIPT_CACHE_SIZE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_cache_size");
    }

    public static DeprecationIssue checkGeneralScriptExpireSetting(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_CACHE_EXPIRE_SETTING, ScriptService.SCRIPT_CACHE_EXPIRE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_expire");
    }

    public static DeprecationIssue checkGeneralScriptCompileSettings(Settings settings, PluginsAndModules pluginsAndModules) {
        return NodeDeprecationChecks.checkDeprecatedSetting(settings, pluginsAndModules, ScriptService.SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING, ScriptService.SCRIPT_MAX_COMPILATIONS_RATE_SETTING, "a script context", "https://www.elastic.co/guide/en/elasticsearch/reference/7.9/breaking-changes-7.9.html#deprecate_general_script_compile_rate");
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting<?> replacementSetting, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated in favor of setting [%s]", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], instead set [%s] to [%s]", deprecatedSettingKey, value, replacementSettingKey, value);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details);
    }

    private static DeprecationIssue checkDeprecatedSetting(Settings settings, PluginsAndModules pluginsAndModules, Setting<?> deprecatedSetting, Setting.AffixSetting<?> replacementSetting, String star, String url) {
        assert (deprecatedSetting.isDeprecated()) : deprecatedSetting;
        if (!deprecatedSetting.exists(settings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String replacementSettingKey = replacementSetting.getKey();
        String value = deprecatedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated in favor of grouped setting [%s]", deprecatedSettingKey, replacementSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], instead set [%s] to [%s] where * is %s", deprecatedSettingKey, value, replacementSettingKey, value, star);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details);
    }

    static DeprecationIssue checkRemovedSetting(Settings settings, Setting<?> removedSetting, String url) {
        if (!removedSetting.exists(settings)) {
            return null;
        }
        String removedSettingKey = removedSetting.getKey();
        String value = removedSetting.get(settings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in the next major version", removedSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], remove this setting", removedSettingKey, value);
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details);
    }
}

