/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;

public class PutSamlServiceProviderRequest
extends ActionRequest {
    public static final WriteRequest.RefreshPolicy DEFAULT_REFRESH_POLICY = WriteRequest.RefreshPolicy.NONE;
    private final SamlServiceProviderDocument document;
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public static PutSamlServiceProviderRequest fromXContent(String entityId, WriteRequest.RefreshPolicy refreshPolicy, XContentParser parser) throws IOException {
        SamlServiceProviderDocument document = SamlServiceProviderDocument.fromXContent(null, parser);
        if (document.entityId == null) {
            document.setEntityId(entityId);
        } else if (entityId != null && !entityId.equals(document.entityId)) {
            throw new ElasticsearchParseException("Entity id [{}] inside request body and entity id [{}] from parameter do not match", new Object[]{document.entityId, entityId});
        }
        if (document.created != null) {
            throw new ElasticsearchParseException("Field [{}] may not be specified in a request", new Object[]{SamlServiceProviderDocument.Fields.CREATED_DATE});
        }
        if (document.lastModified != null) {
            throw new ElasticsearchParseException("Field [{}] may not be specified in a request", new Object[]{SamlServiceProviderDocument.Fields.LAST_MODIFIED});
        }
        document.setCreatedMillis(System.currentTimeMillis());
        document.setLastModifiedMillis(System.currentTimeMillis());
        return new PutSamlServiceProviderRequest(document, refreshPolicy);
    }

    public PutSamlServiceProviderRequest(SamlServiceProviderDocument document, WriteRequest.RefreshPolicy refreshPolicy) {
        this.document = document;
        this.refreshPolicy = refreshPolicy;
    }

    public PutSamlServiceProviderRequest(StreamInput in) throws IOException {
        this.document = new SamlServiceProviderDocument(in);
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.document.writeTo(out);
        this.refreshPolicy.writeTo(out);
    }

    public SamlServiceProviderDocument getDocument() {
        return this.document;
    }

    public ActionRequestValidationException validate() {
        ValidationException docException = this.document.validate();
        ActionRequestValidationException validationException = null;
        if (docException != null) {
            validationException = new ActionRequestValidationException();
            validationException.addValidationErrors((Iterable)docException.validationErrors());
        }
        if (Strings.hasText((String)this.document.acs)) {
            try {
                URL url = new URL(this.document.acs);
                if (!url.getProtocol().equals("https")) {
                    validationException = ValidateActions.addValidationError((String)("[" + SamlServiceProviderDocument.Fields.ACS + "] must use the [https] protocol"), (ActionRequestValidationException)validationException);
                }
            }
            catch (MalformedURLException e) {
                String error = "[" + SamlServiceProviderDocument.Fields.ACS + "] must be a valid URL";
                if (e.getMessage() != null) {
                    error = error + " - " + e.getMessage();
                }
                validationException = ValidateActions.addValidationError((String)error, (ActionRequestValidationException)validationException);
            }
        }
        if (!this.document.certificates.identityProviderSigning.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)("[" + SamlServiceProviderDocument.Fields.Certificates.IDP_SIGNING + "] certificates may not be specified"), (ActionRequestValidationException)validationException);
        }
        if (!this.document.certificates.identityProviderMetadataSigning.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)("[" + SamlServiceProviderDocument.Fields.Certificates.IDP_METADATA + "] certificates may not be specified"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PutSamlServiceProviderRequest that = (PutSamlServiceProviderRequest)((Object)o);
        return Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(this.document);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + this.document + "}";
    }
}

