/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanQuery;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.transforms.pivot.DateHistogramGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.transform.transforms.Function;

public class CompositeBucketsChangeCollector
implements Function.ChangeCollector {
    private final Map<String, FieldCollector> fieldCollectors;
    private final CompositeAggregationBuilder compositeAggregation;
    private Map<String, Object> afterKey = null;

    private CompositeBucketsChangeCollector(@Nullable CompositeAggregationBuilder compositeAggregation, Map<String, FieldCollector> fieldCollectors) {
        this.compositeAggregation = compositeAggregation;
        this.fieldCollectors = fieldCollectors;
    }

    @Override
    public SearchSourceBuilder buildChangesQuery(SearchSourceBuilder sourceBuilder, Map<String, Object> position, int pageSize) {
        sourceBuilder.size(0);
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            AggregationBuilder aggregationForField = fieldCollector.aggregateChanges();
            if (aggregationForField != null) {
                sourceBuilder.aggregation(aggregationForField);
            }
            pageSize = Math.min(pageSize, fieldCollector.getMaxPageSize());
        }
        if (this.compositeAggregation != null) {
            CompositeAggregationBuilder changesAgg = this.compositeAggregation;
            changesAgg.size(pageSize).aggregateAfter(position);
            sourceBuilder.aggregation((AggregationBuilder)changesAgg);
        }
        return sourceBuilder;
    }

    @Override
    public QueryBuilder buildFilterQuery(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
        if (this.fieldCollectors.size() == 1) {
            return this.fieldCollectors.values().iterator().next().filterByChanges(lastCheckpointTimestamp, nextcheckpointTimestamp);
        }
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder();
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            QueryBuilder filter = fieldCollector.filterByChanges(lastCheckpointTimestamp, nextcheckpointTimestamp);
            if (filter == null) continue;
            filteredQuery.filter(filter);
        }
        return filteredQuery;
    }

    @Override
    public boolean processSearchResponse(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return true;
        }
        CompositeAggregation agg = (CompositeAggregation)aggregations.get(this.compositeAggregation.getName());
        List buckets = agg.getBuckets();
        this.afterKey = agg.afterKey();
        if (buckets.isEmpty()) {
            return true;
        }
        for (FieldCollector fieldCollector : this.fieldCollectors.values()) {
            fieldCollector.collectChanges(buckets);
        }
        return false;
    }

    @Override
    public void clear() {
        this.fieldCollectors.forEach((k, c) -> c.clear());
    }

    @Override
    public Map<String, Object> getBucketPosition() {
        return this.afterKey;
    }

    @Override
    public boolean isOptimized() {
        return this.fieldCollectors.values().stream().anyMatch(FieldCollector::isOptimized);
    }

    public static Function.ChangeCollector buildChangeCollector(@Nullable CompositeAggregationBuilder compositeAggregationBuilder, Map<String, SingleGroupSource> groups, String synchronizationField) {
        Map<String, FieldCollector> fieldCollectors = CompositeBucketsChangeCollector.createFieldCollectors(groups, synchronizationField);
        return new CompositeBucketsChangeCollector(compositeAggregationBuilder, fieldCollectors);
    }

    static Map<String, FieldCollector> createFieldCollectors(Map<String, SingleGroupSource> groups, String synchronizationField) {
        HashMap<String, FieldCollector> fieldCollectors = new HashMap<String, FieldCollector>();
        block6: for (Map.Entry<String, SingleGroupSource> entry : groups.entrySet()) {
            if (entry.getValue().getScriptConfig() != null) continue;
            switch (entry.getValue().getType()) {
                case TERMS: {
                    fieldCollectors.put(entry.getKey(), new TermsFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket()));
                    continue block6;
                }
                case HISTOGRAM: {
                    fieldCollectors.put(entry.getKey(), new HistogramFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket()));
                    continue block6;
                }
                case DATE_HISTOGRAM: {
                    fieldCollectors.put(entry.getKey(), new DateHistogramFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket(), ((DateHistogramGroupSource)entry.getValue()).getRounding(), entry.getValue().getField() != null && entry.getValue().getField().equals(synchronizationField)));
                    continue block6;
                }
                case GEOTILE_GRID: {
                    fieldCollectors.put(entry.getKey(), new GeoTileFieldCollector(entry.getValue().getField(), entry.getKey(), entry.getValue().getMissingBucket()));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("unknown type");
        }
        return fieldCollectors;
    }

    static class GeoTileFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;
        private final Set<String> changedBuckets;
        private boolean foundNullBucket;

        GeoTileFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket) {
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
            this.changedBuckets = new HashSet<String>();
            this.foundNullBucket = false;
        }

        @Override
        public int getMaxPageSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        public boolean collectChanges(Collection<? extends CompositeAggregation.Bucket> buckets) {
            this.changedBuckets.clear();
            this.foundNullBucket = false;
            for (CompositeAggregation.Bucket bucket : buckets) {
                Object bucket2 = bucket.getKey().get(this.targetFieldName);
                if (bucket2 != null) {
                    this.changedBuckets.add(bucket2.toString());
                    continue;
                }
                assert (this.missingBucket);
                this.foundNullBucket = true;
            }
            return true;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            BoolQueryBuilder boundingBoxesQueryBuilder = null;
            if (!this.changedBuckets.isEmpty()) {
                boundingBoxesQueryBuilder = QueryBuilders.boolQuery();
                this.changedBuckets.stream().map(GeoTileUtils::toBoundingBox).map(this::toGeoQuery).forEach(arg_0 -> ((BoolQueryBuilder)boundingBoxesQueryBuilder).should(arg_0));
            }
            if (this.missingBucket && this.foundNullBucket) {
                BoolQueryBuilder missingBucketQuery = new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(this.sourceFieldName));
                if (boundingBoxesQueryBuilder == null) {
                    return missingBucketQuery;
                }
                return boundingBoxesQueryBuilder.should((QueryBuilder)missingBucketQuery);
            }
            return boundingBoxesQueryBuilder;
        }

        @Override
        public void clear() {
            this.changedBuckets.clear();
            this.foundNullBucket = false;
        }

        @Override
        public AggregationBuilder aggregateChanges() {
            return null;
        }

        private GeoBoundingBoxQueryBuilder toGeoQuery(Rectangle rectangle) {
            return QueryBuilders.geoBoundingBoxQuery((String)this.sourceFieldName).setCorners(new GeoPoint(rectangle.getMaxLat(), rectangle.getMinLon()), new GeoPoint(rectangle.getMinLat(), rectangle.getMaxLon()));
        }

        @Override
        public boolean isOptimized() {
            return true;
        }
    }

    static class HistogramFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;

        HistogramFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket) {
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
        }

        @Override
        public int getMaxPageSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean collectChanges(Collection<? extends CompositeAggregation.Bucket> buckets) {
            return false;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public AggregationBuilder aggregateChanges() {
            return null;
        }

        @Override
        public boolean isOptimized() {
            return false;
        }
    }

    static class DateHistogramFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;
        private final boolean applyOptimizationForSyncField;
        private final Rounding.Prepared rounding;

        DateHistogramFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket, Rounding.Prepared rounding, boolean isSynchronizationField) {
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
            this.rounding = rounding;
            this.applyOptimizationForSyncField = isSynchronizationField && !missingBucket;
        }

        @Override
        public int getMaxPageSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean collectChanges(Collection<? extends CompositeAggregation.Bucket> buckets) {
            return false;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            if (this.applyOptimizationForSyncField && lastCheckpointTimestamp > 0L) {
                assert (!this.missingBucket);
                return new RangeQueryBuilder(this.sourceFieldName).gte((Object)this.rounding.round(lastCheckpointTimestamp)).format("epoch_millis");
            }
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public AggregationBuilder aggregateChanges() {
            return null;
        }

        @Override
        public boolean isOptimized() {
            return this.applyOptimizationForSyncField;
        }
    }

    static class TermsFieldCollector
    implements FieldCollector {
        private final String sourceFieldName;
        private final String targetFieldName;
        private final boolean missingBucket;
        private final Set<String> changedTerms;
        private boolean foundNullBucket;

        TermsFieldCollector(String sourceFieldName, String targetFieldName, boolean missingBucket) {
            this.sourceFieldName = sourceFieldName;
            this.targetFieldName = targetFieldName;
            this.missingBucket = missingBucket;
            this.changedTerms = new HashSet<String>();
            this.foundNullBucket = false;
        }

        @Override
        public int getMaxPageSize() {
            return 65536;
        }

        @Override
        public boolean collectChanges(Collection<? extends CompositeAggregation.Bucket> buckets) {
            this.changedTerms.clear();
            this.foundNullBucket = false;
            for (CompositeAggregation.Bucket bucket : buckets) {
                Object term = bucket.getKey().get(this.targetFieldName);
                if (term != null) {
                    this.changedTerms.add(term.toString());
                    continue;
                }
                assert (this.missingBucket);
                this.foundNullBucket = true;
            }
            return true;
        }

        @Override
        public QueryBuilder filterByChanges(long lastCheckpointTimestamp, long nextcheckpointTimestamp) {
            if (this.missingBucket && this.foundNullBucket) {
                BoolQueryBuilder missingBucketQuery = new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(this.sourceFieldName));
                if (this.changedTerms.isEmpty()) {
                    return missingBucketQuery;
                }
                return new BoolQueryBuilder().should((QueryBuilder)new TermsQueryBuilder(this.sourceFieldName, this.changedTerms)).should((QueryBuilder)missingBucketQuery);
            }
            if (!this.changedTerms.isEmpty()) {
                return new TermsQueryBuilder(this.sourceFieldName, this.changedTerms);
            }
            return null;
        }

        @Override
        public void clear() {
            this.changedTerms.clear();
            this.foundNullBucket = false;
        }

        @Override
        public AggregationBuilder aggregateChanges() {
            return null;
        }

        @Override
        public boolean isOptimized() {
            return true;
        }
    }

    static interface FieldCollector {
        public int getMaxPageSize();

        public AggregationBuilder aggregateChanges();

        public boolean collectChanges(Collection<? extends CompositeAggregation.Bucket> var1);

        public QueryBuilder filterByChanges(long var1, long var3);

        public void clear();

        public boolean isOptimized();
    }
}

