/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.pivot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.GeoCentroid;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.Percentile;
import org.elasticsearch.search.aggregations.metrics.Percentiles;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetric;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.xpack.transform.transforms.IDGenerator;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.utils.OutputFieldNameConverter;

public final class AggregationResultUtils {
    private static final Map<String, AggValueExtractor> TYPE_VALUE_EXTRACTOR_MAP;

    public static Stream<Map<String, Object>> extractCompositeAggregationResults(CompositeAggregation agg, GroupConfig groups, Collection<AggregationBuilder> aggregationBuilders, Collection<PipelineAggregationBuilder> pipelineAggs, Map<String, String> fieldTypeMap, TransformIndexerStats stats) {
        return agg.getBuckets().stream().map(bucket -> {
            stats.incrementNumDocuments(bucket.getDocCount());
            HashMap<String, Object> document = new HashMap<String, Object>();
            IDGenerator idGen = new IDGenerator();
            groups.getGroups().forEach((destinationFieldName, singleGroupSource) -> {
                Object value = bucket.getKey().get(destinationFieldName);
                idGen.add((String)destinationFieldName, value);
                AggregationResultUtils.updateDocument(document, destinationFieldName, singleGroupSource.transformBucketKey(value));
            });
            List aggNames = aggregationBuilders.stream().map(AggregationBuilder::getName).collect(Collectors.toList());
            aggNames.addAll(pipelineAggs.stream().map(PipelineAggregationBuilder::getName).collect(Collectors.toList()));
            for (String aggName : aggNames) {
                Aggregation aggResult = bucket.getAggregations().get(aggName);
                if (aggResult == null) continue;
                AggValueExtractor extractor = AggregationResultUtils.getExtractor(aggResult);
                AggregationResultUtils.updateDocument(document, aggName, extractor.value(aggResult, fieldTypeMap, ""));
            }
            document.put(TransformField.DOCUMENT_ID_FIELD, idGen.getID());
            return document;
        });
    }

    static AggValueExtractor getExtractor(Aggregation aggregation) {
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(NumericMetricsAggregation.SingleValue.class.getName());
        }
        if (aggregation instanceof ScriptedMetric) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(ScriptedMetric.class.getName());
        }
        if (aggregation instanceof GeoCentroid) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(GeoCentroid.class.getName());
        }
        if (aggregation instanceof GeoBounds) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(GeoBounds.class.getName());
        }
        if (aggregation instanceof Percentiles) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(Percentiles.class.getName());
        }
        if (aggregation instanceof SingleBucketAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(SingleBucketAggregation.class.getName());
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            return TYPE_VALUE_EXTRACTOR_MAP.get(MultiBucketsAggregation.class.getName());
        }
        throw new AggregationExtractionException("unsupported aggregation [{}] with name [{}]", aggregation.getType(), aggregation.getName());
    }

    static void updateDocument(Map<String, Object> document, String fieldName, Object value) {
        String[] fieldTokens = fieldName.split("\\.");
        if (fieldTokens.length == 1) {
            document.put(fieldName, value);
            return;
        }
        HashMap<String, Object> internalMap = document;
        for (int i = 0; i < fieldTokens.length; ++i) {
            String token = fieldTokens[i];
            if (i == fieldTokens.length - 1) {
                if (internalMap.containsKey(token)) {
                    if (internalMap.get(token) instanceof Map) {
                        throw new AggregationExtractionException("mixed object types of nested and non-nested fields [{}]", fieldName);
                    }
                    throw new AggregationExtractionException("duplicate key value pairs key [{}] old value [{}] duplicate value [{}]", fieldName, internalMap.get(token), value);
                }
                internalMap.put(token, value);
                continue;
            }
            if (internalMap.containsKey(token)) {
                if (internalMap.get(token) instanceof Map) {
                    internalMap = (HashMap<String, Object>)internalMap.get(token);
                    continue;
                }
                throw new AggregationExtractionException("mixed object types of nested and non-nested fields [{}]", fieldName);
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            internalMap.put(token, newMap);
            internalMap = newMap;
        }
    }

    static {
        HashMap<String, AggValueExtractor> tempMap = new HashMap<String, AggValueExtractor>();
        tempMap.put(NumericMetricsAggregation.SingleValue.class.getName(), new SingleValueAggExtractor());
        tempMap.put(ScriptedMetric.class.getName(), new ScriptedMetricAggExtractor());
        tempMap.put(GeoCentroid.class.getName(), new GeoCentroidAggExtractor());
        tempMap.put(GeoBounds.class.getName(), new GeoBoundsAggExtractor());
        tempMap.put(Percentiles.class.getName(), new PercentilesAggExtractor());
        tempMap.put(SingleBucketAggregation.class.getName(), new SingleBucketAggExtractor());
        tempMap.put(MultiBucketsAggregation.class.getName(), new MultiBucketsAggExtractor());
        TYPE_VALUE_EXTRACTOR_MAP = Collections.unmodifiableMap(tempMap);
    }

    static class GeoBoundsAggExtractor
    implements AggValueExtractor {
        GeoBoundsAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            GeoBounds aggregation = (GeoBounds)agg;
            if (aggregation.bottomRight() == null || aggregation.topLeft() == null) {
                return null;
            }
            HashMap<String, Object> geoShape = new HashMap<String, Object>();
            if (aggregation.topLeft().equals((Object)aggregation.bottomRight())) {
                geoShape.put(ShapeParser.FIELD_TYPE.getPreferredName(), PointBuilder.TYPE.shapeName());
                geoShape.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), Arrays.asList(aggregation.topLeft().getLon(), aggregation.bottomRight().getLat()));
            } else if (Double.compare(aggregation.topLeft().getLat(), aggregation.bottomRight().getLat()) == 0 || Double.compare(aggregation.topLeft().getLon(), aggregation.bottomRight().getLon()) == 0) {
                geoShape.put(ShapeParser.FIELD_TYPE.getPreferredName(), LineStringBuilder.TYPE.shapeName());
                geoShape.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), Arrays.asList({aggregation.topLeft().getLon(), aggregation.topLeft().getLat()}, {aggregation.bottomRight().getLon(), aggregation.bottomRight().getLat()}));
            } else {
                geoShape.put(ShapeParser.FIELD_TYPE.getPreferredName(), PolygonBuilder.TYPE.shapeName());
                GeoPoint tl = aggregation.topLeft();
                GeoPoint br = aggregation.bottomRight();
                geoShape.put(ShapeParser.FIELD_COORDINATES.getPreferredName(), Collections.singletonList(Arrays.asList({tl.getLon(), tl.getLat()}, {br.getLon(), tl.getLat()}, {br.getLon(), br.getLat()}, {tl.getLon(), br.getLat()}, {tl.getLon(), tl.getLat()})));
            }
            return geoShape;
        }
    }

    static class GeoCentroidAggExtractor
    implements AggValueExtractor {
        GeoCentroidAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            GeoCentroid aggregation = (GeoCentroid)agg;
            return aggregation.count() > 0L ? aggregation.centroid().toString() : null;
        }
    }

    static class ScriptedMetricAggExtractor
    implements AggValueExtractor {
        ScriptedMetricAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            ScriptedMetric aggregation = (ScriptedMetric)agg;
            return aggregation.aggregation();
        }
    }

    static class MultiBucketsAggExtractor
    implements AggValueExtractor {
        MultiBucketsAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            MultiBucketsAggregation aggregation = (MultiBucketsAggregation)agg;
            HashMap<String, Serializable> nested = new HashMap<String, Serializable>();
            for (MultiBucketsAggregation.Bucket bucket : aggregation.getBuckets()) {
                if (!bucket.getAggregations().iterator().hasNext()) {
                    nested.put(bucket.getKeyAsString(), Long.valueOf(bucket.getDocCount()));
                    continue;
                }
                HashMap<String, Object> nestedBucketObject = new HashMap<String, Object>();
                for (Aggregation subAgg : bucket.getAggregations()) {
                    nestedBucketObject.put(subAgg.getName(), AggregationResultUtils.getExtractor(subAgg).value(subAgg, fieldTypeMap, lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName()));
                }
                nested.put(bucket.getKeyAsString(), nestedBucketObject);
            }
            return nested;
        }
    }

    static class SingleBucketAggExtractor
    implements AggValueExtractor {
        SingleBucketAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            SingleBucketAggregation aggregation = (SingleBucketAggregation)agg;
            if (!aggregation.getAggregations().iterator().hasNext()) {
                return aggregation.getDocCount();
            }
            HashMap<String, Object> nested = new HashMap<String, Object>();
            for (Aggregation subAgg : aggregation.getAggregations()) {
                nested.put(subAgg.getName(), AggregationResultUtils.getExtractor(subAgg).value(subAgg, fieldTypeMap, lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName()));
            }
            return nested;
        }
    }

    static class PercentilesAggExtractor
    implements AggValueExtractor {
        PercentilesAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            Percentiles aggregation = (Percentiles)agg;
            HashMap<String, Double> percentiles = new HashMap<String, Double>();
            for (Percentile p : aggregation) {
                if (!Numbers.isValidDouble((double)p.getValue())) {
                    percentiles.put(OutputFieldNameConverter.fromDouble(p.getPercent()), null);
                    continue;
                }
                percentiles.put(OutputFieldNameConverter.fromDouble(p.getPercent()), p.getValue());
            }
            return percentiles;
        }
    }

    static class SingleValueAggExtractor
    implements AggValueExtractor {
        SingleValueAggExtractor() {
        }

        @Override
        public Object value(Aggregation agg, Map<String, String> fieldTypeMap, String lookupFieldPrefix) {
            NumericMetricsAggregation.SingleValue aggregation = (NumericMetricsAggregation.SingleValue)agg;
            if (!Numbers.isValidDouble((double)aggregation.value())) {
                return null;
            }
            String fieldType = fieldTypeMap.get(lookupFieldPrefix.isEmpty() ? agg.getName() : lookupFieldPrefix + "." + agg.getName());
            if (SchemaUtil.isNumericType(fieldType) || aggregation.getValueAsString().equals(String.valueOf(aggregation.value()))) {
                return SchemaUtil.dropFloatingPointComponentIfTypeRequiresIt(fieldType, aggregation.value());
            }
            return aggregation.getValueAsString();
        }
    }

    static interface AggValueExtractor {
        public Object value(Aggregation var1, Map<String, String> var2, String var3);
    }

    public static class AggregationExtractionException
    extends ElasticsearchException {
        AggregationExtractionException(String msg, Object ... args) {
            super(msg, args);
        }
    }
}

