/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.notifications;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.transform.notifications.TransformAuditMessage;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;

public class TransformAuditor
extends AbstractAuditor<TransformAuditMessage> {
    public TransformAuditor(Client client, String nodeName, ClusterService clusterService) {
        super(new OriginSettingClient(client, "transform"), ".transform-notifications-000002", ".transform-notifications-000002", () -> {
            try {
                IndexTemplateMetadata templateMeta = TransformInternalIndex.getAuditIndexTemplateMetadata(clusterService.state().nodes().getMinNodeVersion());
                PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateMeta.name()).patterns(templateMeta.patterns()).version(templateMeta.version()).settings(templateMeta.settings()).mapping((String)((ObjectObjectCursor)templateMeta.mappings().iterator().next()).key, ((CompressedXContent)((ObjectObjectCursor)templateMeta.mappings().iterator().next()).value).uncompressed(), XContentType.JSON);
                for (ObjectObjectCursor cursor : templateMeta.getAliases()) {
                    AliasMetadata meta = (AliasMetadata)cursor.value;
                    Alias alias = new Alias(meta.alias()).indexRouting(meta.indexRouting()).searchRouting(meta.searchRouting()).isHidden(meta.isHidden()).writeIndex(meta.writeIndex());
                    if (meta.filter() != null) {
                        alias.filter(meta.getFilter().string());
                    }
                    request.alias(alias);
                }
                return request;
            }
            catch (IOException e) {
                return null;
            }
        }, nodeName, TransformAuditMessage::new, clusterService);
    }
}

